/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.dao.impl;

import java.util.HashSet;
import java.util.List;
import javax.persistence.Query;
import org.apache.syncope.core.persistence.beans.AbstractVirAttr;
import org.apache.syncope.core.persistence.beans.AbstractVirSchema;
import org.apache.syncope.core.persistence.dao.ResourceDAO;
import org.apache.syncope.core.persistence.dao.VirAttrDAO;
import org.apache.syncope.core.persistence.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.dao.impl.AbstractDAOImpl;
import org.apache.syncope.core.util.AttributableUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class VirSchemaDAOImpl
extends AbstractDAOImpl
implements VirSchemaDAO {
    @Autowired
    private VirAttrDAO virtualAttributeDAO;
    @Autowired
    private ResourceDAO resourceDAO;

    @Override
    public <T extends AbstractVirSchema> T find(String name, Class<T> reference) {
        return (T)((AbstractVirSchema)this.entityManager.find(reference, (Object)name));
    }

    @Override
    public <T extends AbstractVirSchema> List<T> findAll(Class<T> reference) {
        Query query = this.entityManager.createQuery("SELECT e FROM " + reference.getSimpleName() + " e");
        return query.getResultList();
    }

    @Override
    public <T extends AbstractVirSchema> T save(T virtualSchema) {
        return (T)((AbstractVirSchema)this.entityManager.merge(virtualSchema));
    }

    @Override
    public void delete(String name, AttributableUtil attributableUtil) {
        Object virtualSchema = this.find(name, attributableUtil.virtualSchemaClass());
        if (virtualSchema == null) {
            return;
        }
        List attributes = this.getAttributes((AbstractVirSchema)virtualSchema, attributableUtil.virtualAttributeClass());
        HashSet<Long> virtualAttributeIds = new HashSet<Long>(attributes.size());
        Class<?> attributeClass = null;
        for (AbstractVirAttr attribute : attributes) {
            virtualAttributeIds.add(attribute.getId());
            attributeClass = attribute.getClass();
        }
        for (Long virtualAttributeId : virtualAttributeIds) {
            this.virtualAttributeDAO.delete(virtualAttributeId, attributeClass);
        }
        this.resourceDAO.deleteMappings(name, attributableUtil.virtualIntMappingType());
        this.entityManager.remove(virtualSchema);
    }

    @Override
    public <T extends AbstractVirAttr> List<T> getAttributes(AbstractVirSchema virtualSchema, Class<T> reference) {
        Query query = this.entityManager.createQuery("SELECT e FROM " + reference.getSimpleName() + " e" + " WHERE e.virtualSchema=:schema");
        query.setParameter("schema", (Object)virtualSchema);
        return query.getResultList();
    }
}

