/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.dao.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.validation.ValidationException;
import org.apache.syncope.client.search.AttributeCond;
import org.apache.syncope.client.search.MembershipCond;
import org.apache.syncope.client.search.NodeCond;
import org.apache.syncope.client.search.ResourceCond;
import org.apache.syncope.client.search.SyncopeUserCond;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.beans.user.UAttrValue;
import org.apache.syncope.core.persistence.beans.user.USchema;
import org.apache.syncope.core.persistence.dao.RoleDAO;
import org.apache.syncope.core.persistence.dao.SchemaDAO;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.apache.syncope.core.persistence.dao.UserSearchDAO;
import org.apache.syncope.core.persistence.dao.impl.AbstractDAOImpl;
import org.apache.syncope.types.SchemaType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class UserSearchDAOImpl
extends AbstractDAOImpl
implements UserSearchDAO {
    private static final String EMPTY_ATTR_QUERY = "SELECT user_id FROM user_search_attr WHERE 1=2";
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private RoleDAO roleDAO;
    @Autowired
    private SchemaDAO schemaDAO;

    private String getAdminRolesFilter(Set<Long> adminRoles) {
        StringBuilder adminRolesFilter = new StringBuilder();
        adminRolesFilter.append("SELECT syncopeUser_id AS user_id ").append("FROM Membership M1 ").append("WHERE syncopeRole_id IN (");
        adminRolesFilter.append("SELECT syncopeRole_id ").append("FROM Membership M2 ").append("WHERE M2.syncopeUser_id=M1.syncopeUser_id ").append("AND syncopeRole_id NOT IN (");
        adminRolesFilter.append("SELECT id AS syncopeRole_id FROM SyncopeRole");
        boolean firstRole = true;
        for (Long adminRoleId : adminRoles) {
            if (firstRole) {
                adminRolesFilter.append(" WHERE");
                firstRole = false;
            } else {
                adminRolesFilter.append(" OR");
            }
            adminRolesFilter.append(" id=").append(adminRoleId);
        }
        adminRolesFilter.append("))");
        return adminRolesFilter.toString();
    }

    @Override
    public int count(Set<Long> adminRoles, NodeCond searchCondition) {
        List<Object> parameters = Collections.synchronizedList(new ArrayList());
        StringBuilder queryString = this.getQuery(searchCondition, parameters);
        queryString.insert(0, "SELECT u.user_id FROM (");
        queryString.append(") u WHERE user_id NOT IN (");
        queryString.append(this.getAdminRolesFilter(adminRoles)).append(")");
        queryString.insert(0, "SELECT COUNT(user_id) FROM (");
        queryString.append(") count_user_id");
        Query countQuery = this.entityManager.createNativeQuery(queryString.toString());
        this.fillWithParameters(countQuery, parameters);
        LOG.debug("Native count query\n{}\nwith parameters\n{}", (Object)queryString.toString(), parameters);
        int result = ((Number)countQuery.getSingleResult()).intValue();
        LOG.debug("Native count query result: {}", (Object)result);
        return result;
    }

    @Override
    public List<SyncopeUser> search(Set<Long> adminRoles, NodeCond searchCondition) {
        return this.search(adminRoles, searchCondition, -1, -1);
    }

    @Override
    public List<SyncopeUser> search(Set<Long> adminRoles, NodeCond searchCondition, int page, int itemsPerPage) {
        List<SyncopeUser> result = Collections.emptyList();
        if (adminRoles != null && (!adminRoles.isEmpty() || this.roleDAO.findAll().isEmpty())) {
            LOG.debug("Search condition:\n{}", (Object)searchCondition);
            if (!searchCondition.checkValidity()) {
                LOG.error("Invalid search condition:\n{}", (Object)searchCondition);
            } else {
                try {
                    result = this.doSearch(adminRoles, searchCondition, page, itemsPerPage);
                }
                catch (Exception e) {
                    LOG.error("While searching users", (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public boolean matches(SyncopeUser user, NodeCond searchCondition) {
        List<Object> parameters = Collections.synchronizedList(new ArrayList());
        StringBuilder queryString = this.getQuery(searchCondition, parameters);
        queryString.insert(0, "SELECT u.user_id FROM (");
        queryString.append(") u WHERE user_id=?").append(this.setParameter(parameters, user.getId()));
        Query query = this.entityManager.createNativeQuery(queryString.toString());
        this.fillWithParameters(query, parameters);
        List result = query.getResultList();
        return !result.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setParameter(List<Object> parameters, Object parameter) {
        int key;
        List<Object> list = parameters;
        synchronized (list) {
            parameters.add(parameter);
            key = parameters.size();
        }
        return key;
    }

    private void fillWithParameters(Query query, List<Object> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            if (parameters.get(i) instanceof Date) {
                query.setParameter(i + 1, (Date)parameters.get(i), TemporalType.TIMESTAMP);
                continue;
            }
            if (parameters.get(i) instanceof Boolean) {
                query.setParameter(i + 1, (Object)((Boolean)parameters.get(i) != false ? 1 : 0));
                continue;
            }
            query.setParameter(i + 1, parameters.get(i));
        }
    }

    private List<SyncopeUser> doSearch(Set<Long> adminRoles, NodeCond nodeCond, int page, int itemsPerPage) {
        List<Object> parameters = Collections.synchronizedList(new ArrayList());
        StringBuilder queryString = this.getQuery(nodeCond, parameters);
        if (queryString.charAt(0) == '(') {
            queryString.insert(0, "SELECT u.user_id FROM ");
            queryString.append(" u WHERE user_id NOT IN (");
        } else {
            queryString.insert(0, "SELECT u.user_id FROM (");
            queryString.append(") u WHERE user_id NOT IN (");
        }
        queryString.append(this.getAdminRolesFilter(adminRoles)).append(")");
        Query query = this.entityManager.createNativeQuery(queryString.toString());
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage >= 0) {
            query.setMaxResults(itemsPerPage);
        }
        this.fillWithParameters(query, parameters);
        LOG.debug("Native query\n{}\nwith parameters\n{}", (Object)queryString.toString(), parameters);
        HashSet<Number> userIds = new HashSet<Number>();
        List resultList = query.getResultList();
        if (resultList != null) {
            for (Object userId : resultList) {
                if (userId instanceof Object[]) {
                    userIds.add((Number)((Object[])userId)[0]);
                    continue;
                }
                userIds.add((Number)userId);
            }
        }
        ArrayList<SyncopeUser> result = new ArrayList<SyncopeUser>(userIds.size());
        for (Number userId : userIds) {
            SyncopeUser user = this.userDAO.find(userId.longValue());
            if (user == null) {
                LOG.error("Could not find user with id {}, even though returned by the native query", (Object)userId);
                continue;
            }
            result.add(user);
        }
        return result;
    }

    private StringBuilder getQuery(NodeCond nodeCond, List<Object> parameters) {
        StringBuilder query = new StringBuilder();
        switch (nodeCond.getType()) {
            case LEAF: 
            case NOT_LEAF: {
                if (nodeCond.getMembershipCond() != null) {
                    query.append(this.getQuery(nodeCond.getMembershipCond(), nodeCond.getType() == NodeCond.Type.NOT_LEAF, parameters));
                }
                if (nodeCond.getResourceCond() != null) {
                    query.append(this.getQuery(nodeCond.getResourceCond(), nodeCond.getType() == NodeCond.Type.NOT_LEAF, parameters));
                }
                if (nodeCond.getAttributeCond() != null) {
                    query.append(this.getQuery(nodeCond.getAttributeCond(), nodeCond.getType() == NodeCond.Type.NOT_LEAF, parameters));
                }
                if (nodeCond.getSyncopeUserCond() == null) break;
                query.append(this.getQuery(nodeCond.getSyncopeUserCond(), nodeCond.getType() == NodeCond.Type.NOT_LEAF, parameters));
                break;
            }
            case AND: {
                query.append((CharSequence)this.getQuery(nodeCond.getLeftNodeCond(), parameters)).append(" AND user_id IN ( ").append((CharSequence)this.getQuery(nodeCond.getRightNodeCond(), parameters).append(")"));
                break;
            }
            case OR: {
                query.append("(").append((CharSequence)this.getQuery(nodeCond.getLeftNodeCond(), parameters)).append(" UNION ").append((CharSequence)this.getQuery(nodeCond.getRightNodeCond(), parameters).append(")"));
                break;
            }
        }
        return query;
    }

    private String getQuery(MembershipCond cond, boolean not, List<Object> parameters) {
        StringBuilder query = new StringBuilder("SELECT DISTINCT user_id FROM user_search WHERE ");
        if (not) {
            query.append("user_id NOT IN (");
        } else {
            query.append("user_id IN (");
        }
        query.append("SELECT DISTINCT user_id ").append("FROM user_search_membership WHERE ");
        if (cond.getRoleId() != null) {
            query.append("role_id=?").append(this.setParameter(parameters, cond.getRoleId()));
        } else if (cond.getRoleName() != null) {
            query.append("role_name=?").append(this.setParameter(parameters, cond.getRoleName()));
        }
        query.append(")");
        return query.toString();
    }

    private String getQuery(ResourceCond cond, boolean not, List<Object> parameters) {
        StringBuilder query = new StringBuilder("SELECT DISTINCT user_id FROM user_search WHERE ");
        if (not) {
            query.append("user_id NOT IN (");
        } else {
            query.append("user_id IN (");
        }
        query.append("SELECT DISTINCT user_id ").append("FROM user_search_resource WHERE ");
        query.append("resource_name=?").append(this.setParameter(parameters, cond.getResourceName()));
        query.append(")");
        return query.toString();
    }

    private void fillAttributeQuery(StringBuilder query, UAttrValue attrValue, USchema schema, AttributeCond cond, boolean not, List<Object> parameters) {
        String column = cond instanceof SyncopeUserCond ? cond.getSchema() : "' AND " + this.getFieldName(schema.getType());
        switch (cond.getType()) {
            case ISNULL: {
                query.append(column).append(not ? " IS NOT NULL" : " IS NULL");
                break;
            }
            case ISNOTNULL: {
                query.append(column).append(not ? " IS NULL" : " IS NOT NULL");
                break;
            }
            case LIKE: {
                if (schema.getType() == SchemaType.String || schema.getType() == SchemaType.Enum) {
                    query.append(column);
                    if (not) {
                        query.append(" NOT ");
                    }
                    query.append(" LIKE '").append(cond.getExpression()).append("'");
                    break;
                }
                if (!(cond instanceof SyncopeUserCond)) {
                    query.append("' AND");
                }
                query.append(" 1=2");
                LOG.error("LIKE is only compatible with string schemas");
                break;
            }
            case EQ: {
                query.append(column);
                if (not) {
                    query.append("<>");
                } else {
                    query.append("=");
                }
                query.append("?").append(this.setParameter(parameters, attrValue.getValue()));
                break;
            }
            case GE: {
                query.append(column);
                if (not) {
                    query.append("<");
                } else {
                    query.append(">=");
                }
                query.append("?").append(this.setParameter(parameters, attrValue.getValue()));
                break;
            }
            case GT: {
                query.append(column);
                if (not) {
                    query.append("<=");
                } else {
                    query.append(">");
                }
                query.append("?").append(this.setParameter(parameters, attrValue.getValue()));
                break;
            }
            case LE: {
                query.append(column);
                if (not) {
                    query.append(">");
                } else {
                    query.append("<=");
                }
                query.append("?").append(this.setParameter(parameters, attrValue.getValue()));
                break;
            }
            case LT: {
                query.append(column);
                if (not) {
                    query.append(">=");
                } else {
                    query.append("<");
                }
                query.append("?").append(this.setParameter(parameters, attrValue.getValue()));
                break;
            }
        }
    }

    private String getFieldName(SchemaType type) {
        String result;
        switch (type) {
            case Boolean: {
                result = "booleanvalue";
                break;
            }
            case Date: {
                result = "datevalue";
                break;
            }
            case Double: {
                result = "doublevalue";
                break;
            }
            case Long: {
                result = "longvalue";
                break;
            }
            case String: 
            case Enum: {
                result = "stringvalue";
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private String getQuery(AttributeCond cond, boolean not, List<Object> parameters) {
        USchema schema = this.schemaDAO.find(cond.getSchema(), USchema.class);
        if (schema == null) {
            LOG.warn("Ignoring invalid schema '{}'", (Object)cond.getSchema());
            return EMPTY_ATTR_QUERY;
        }
        UAttrValue attrValue = new UAttrValue();
        try {
            if (cond.getType() != AttributeCond.Type.LIKE && cond.getType() != AttributeCond.Type.ISNULL && cond.getType() != AttributeCond.Type.ISNOTNULL) {
                schema.getValidator().validate(cond.getExpression(), attrValue);
            }
        }
        catch (ValidationException e) {
            LOG.error("Could not validate expression '" + cond.getExpression() + "'", (Throwable)e);
            return EMPTY_ATTR_QUERY;
        }
        StringBuilder query = new StringBuilder("SELECT DISTINCT user_id FROM user_search_attr WHERE ").append("schema_name='").append(schema.getName());
        this.fillAttributeQuery(query, attrValue, schema, cond, not, parameters);
        return query.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getQuery(SyncopeUserCond cond, boolean not, List<Object> parameters) {
        Field syncopeUserClassField = null;
        Class i = SyncopeUser.class;
        while (syncopeUserClassField == null && i != Object.class) {
            try {
                syncopeUserClassField = i.getDeclaredField(cond.getSchema());
            }
            catch (Exception ignore) {
                LOG.debug("Field '{}' not found on class '{}'", (Object)new String[]{cond.getSchema(), i.getSimpleName()}, (Object)ignore);
            }
            finally {
                i = i.getSuperclass();
            }
        }
        if (syncopeUserClassField == null) {
            LOG.warn("Ignoring invalid schema '{}'", (Object)cond.getSchema());
            return EMPTY_ATTR_QUERY;
        }
        USchema schema = new USchema();
        schema.setName(syncopeUserClassField.getName());
        for (SchemaType type : SchemaType.values()) {
            if (!syncopeUserClassField.getType().getName().equals(type.getClassName())) continue;
            schema.setType(type);
        }
        UAttrValue attrValue = new UAttrValue();
        try {
            if (cond.getType() != AttributeCond.Type.LIKE && cond.getType() != AttributeCond.Type.ISNULL && cond.getType() != AttributeCond.Type.ISNOTNULL) {
                schema.getValidator().validate(cond.getExpression(), attrValue);
            }
        }
        catch (ValidationException e) {
            LOG.error("Could not validate expression '" + cond.getExpression() + "'", (Throwable)e);
            return EMPTY_ATTR_QUERY;
        }
        StringBuilder query = new StringBuilder("SELECT DISTINCT user_id FROM user_search WHERE ");
        this.fillAttributeQuery(query, attrValue, schema, (AttributeCond)cond, not, parameters);
        return query.toString();
    }
}

