/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.dao.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import org.apache.commons.jexl2.parser.Parser;
import org.apache.commons.jexl2.parser.Token;
import org.apache.syncope.core.persistence.beans.AbstractAttr;
import org.apache.syncope.core.persistence.beans.AbstractAttrValue;
import org.apache.syncope.core.persistence.beans.AbstractVirAttr;
import org.apache.syncope.core.persistence.beans.AbstractVirSchema;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.PropagationTask;
import org.apache.syncope.core.persistence.beans.membership.Membership;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.beans.user.UAttrUniqueValue;
import org.apache.syncope.core.persistence.beans.user.UAttrValue;
import org.apache.syncope.core.persistence.beans.user.UDerSchema;
import org.apache.syncope.core.persistence.beans.user.USchema;
import org.apache.syncope.core.persistence.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.dao.RoleDAO;
import org.apache.syncope.core.persistence.dao.SchemaDAO;
import org.apache.syncope.core.persistence.dao.TaskDAO;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.apache.syncope.core.persistence.dao.impl.AbstractDAOImpl;
import org.apache.syncope.core.rest.controller.InvalidSearchConditionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class UserDAOImpl
extends AbstractDAOImpl
implements UserDAO {
    @Autowired
    private SchemaDAO schemaDAO;
    @Autowired
    private DerSchemaDAO derSchemaDAO;
    @Autowired
    private RoleDAO roleDAO;
    @Autowired
    private TaskDAO taskDAO;

    @Override
    public SyncopeUser find(Long id) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + SyncopeUser.class.getSimpleName() + " e " + "WHERE e.id = :id", SyncopeUser.class);
        query.setParameter("id", (Object)id);
        SyncopeUser result = null;
        try {
            return (SyncopeUser)query.getSingleResult();
        }
        catch (NoResultException e) {
            return result;
        }
    }

    @Override
    public SyncopeUser find(String username) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + SyncopeUser.class.getSimpleName() + " e " + "WHERE e.username = :username", SyncopeUser.class);
        query.setParameter("username", (Object)username);
        SyncopeUser result = null;
        try {
            return (SyncopeUser)query.getSingleResult();
        }
        catch (NoResultException e) {
            return result;
        }
    }

    @Override
    public SyncopeUser findByWorkflowId(String workflowId) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + SyncopeUser.class.getSimpleName() + " e " + "WHERE e.workflowId = :workflowId", SyncopeUser.class);
        query.setParameter("workflowId", (Object)workflowId);
        return (SyncopeUser)query.getSingleResult();
    }

    @Override
    public List<SyncopeUser> findByDerAttrValue(String schemaName, String value) throws InvalidSearchConditionException {
        UDerSchema schema = this.derSchemaDAO.find(schemaName, UDerSchema.class);
        if (schema == null) {
            LOG.error("Invalid schema name '{}'", (Object)schemaName);
            return Collections.emptyList();
        }
        StringBuilder querystring = new StringBuilder();
        boolean subquery = false;
        for (String clause : this.getWhereClause(schema.getExpression(), value)) {
            if (querystring.length() > 0) {
                subquery = true;
                querystring.append(" AND a.owner_id IN ( ");
            }
            querystring.append("SELECT a.owner_id ").append("FROM UAttr a, UAttrValue v, USchema s ").append("WHERE ").append(clause);
            if (!subquery) continue;
            querystring.append(')');
        }
        LOG.debug("Execute query {}", (Object)querystring);
        Query query = this.entityManager.createNativeQuery(querystring.toString());
        ArrayList<SyncopeUser> result = new ArrayList<SyncopeUser>();
        for (Object userId : query.getResultList()) {
            SyncopeUser user = this.find(Long.parseLong(userId.toString()));
            if (result.contains(user)) continue;
            result.add(user);
        }
        return result;
    }

    @Override
    public List<SyncopeUser> findByAttrValue(String schemaName, UAttrValue attrValue) {
        USchema schema = this.schemaDAO.find(schemaName, USchema.class);
        if (schema == null) {
            LOG.error("Invalid schema name '{}'", (Object)schemaName);
            return Collections.emptyList();
        }
        String entityName = schema.isUniqueConstraint() ? UAttrUniqueValue.class.getName() : UAttrValue.class.getName();
        Query query = this.entityManager.createQuery("SELECT e FROM " + entityName + " e" + " WHERE e.attribute.schema.name = :schemaName " + " AND (e.stringValue IS NOT NULL" + " AND e.stringValue = :stringValue)" + " OR (e.booleanValue IS NOT NULL" + " AND e.booleanValue = :booleanValue)" + " OR (e.dateValue IS NOT NULL" + " AND e.dateValue = :dateValue)" + " OR (e.longValue IS NOT NULL" + " AND e.longValue = :longValue)" + " OR (e.doubleValue IS NOT NULL" + " AND e.doubleValue = :doubleValue)");
        query.setParameter("schemaName", (Object)schemaName);
        query.setParameter("stringValue", (Object)attrValue.getStringValue());
        query.setParameter("booleanValue", attrValue.getBooleanValue() == null ? null : attrValue.getBooleanAsInteger(attrValue.getBooleanValue()));
        if (attrValue.getDateValue() != null) {
            query.setParameter("dateValue", attrValue.getDateValue(), TemporalType.TIMESTAMP);
        } else {
            query.setParameter("dateValue", null);
        }
        query.setParameter("longValue", (Object)attrValue.getLongValue());
        query.setParameter("doubleValue", (Object)attrValue.getDoubleValue());
        ArrayList<SyncopeUser> result = new ArrayList<SyncopeUser>();
        for (AbstractAttrValue value : query.getResultList()) {
            SyncopeUser user = (SyncopeUser)((AbstractAttr)value.getAttribute()).getOwner();
            if (result.contains(user)) continue;
            result.add(user);
        }
        return result;
    }

    @Override
    public SyncopeUser findByAttrUniqueValue(String schemaName, UAttrValue attrUniqueValue) {
        USchema schema = this.schemaDAO.find(schemaName, USchema.class);
        if (schema == null) {
            LOG.error("Invalid schema name '{}'", (Object)schemaName);
            return null;
        }
        if (!schema.isUniqueConstraint()) {
            LOG.error("This schema has not unique constraint: '{}'", (Object)schemaName);
            return null;
        }
        List<SyncopeUser> result = this.findByAttrValue(schemaName, attrUniqueValue);
        return result.isEmpty() ? null : result.iterator().next();
    }

    @Override
    public List<SyncopeUser> findByResource(ExternalResource resource) {
        Query query = this.entityManager.createQuery("SELECT e FROM " + SyncopeUser.class.getSimpleName() + " e " + "WHERE :resource MEMBER OF e.resources");
        query.setParameter("resource", (Object)resource);
        return query.getResultList();
    }

    private StringBuilder getFindAllQuery(Set<Long> adminRoles) {
        StringBuilder queryString = new StringBuilder("SELECT id FROM SyncopeUser WHERE id NOT IN (");
        if (adminRoles == null || adminRoles.isEmpty()) {
            queryString.append("SELECT syncopeUser_id AS id FROM Membership");
        } else {
            queryString.append("SELECT syncopeUser_id FROM Membership M1 ").append("WHERE syncopeRole_id IN (");
            queryString.append("SELECT syncopeRole_id FROM Membership M2 ").append("WHERE M2.syncopeUser_id=M1.syncopeUser_id ").append("AND syncopeRole_id NOT IN (");
            queryString.append("SELECT id AS syncopeRole_id FROM SyncopeRole");
            boolean firstRole = true;
            for (Long adminRoleId : adminRoles) {
                if (firstRole) {
                    queryString.append(" WHERE");
                    firstRole = false;
                } else {
                    queryString.append(" OR");
                }
                queryString.append(" id=").append(adminRoleId);
            }
            queryString.append("))");
        }
        queryString.append(")");
        return queryString;
    }

    @Override
    public final List<SyncopeUser> findAll(Set<Long> adminRoles) {
        return this.findAll(adminRoles, -1, -1);
    }

    @Override
    public final List<SyncopeUser> findAll(Set<Long> adminRoles, int page, int itemsPerPage) {
        Query query = this.entityManager.createNativeQuery(this.getFindAllQuery(adminRoles).toString());
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage > 0) {
            query.setMaxResults(itemsPerPage);
        }
        ArrayList<Number> userIds = new ArrayList<Number>();
        List resultList = query.getResultList();
        if (resultList != null) {
            for (Object userId : resultList) {
                if (userId instanceof Object[]) {
                    userIds.add((Number)((Object[])userId)[0]);
                    continue;
                }
                userIds.add((Number)userId);
            }
        }
        ArrayList<SyncopeUser> result = new ArrayList<SyncopeUser>(userIds.size());
        for (Number userId : userIds) {
            SyncopeUser user = this.find(userId.longValue());
            if (user == null) {
                LOG.error("Could not find user with id {}, even though returned by the native query", (Object)userId);
                continue;
            }
            result.add(user);
        }
        return result;
    }

    @Override
    public final int count(Set<Long> adminRoles) {
        StringBuilder queryString = this.getFindAllQuery(adminRoles);
        queryString.insert(0, "SELECT COUNT(id) FROM (");
        queryString.append(") count_user_id");
        Query countQuery = this.entityManager.createNativeQuery(queryString.toString());
        return ((Number)countQuery.getSingleResult()).intValue();
    }

    @Override
    public SyncopeUser save(SyncopeUser user) {
        SyncopeUser merged = (SyncopeUser)this.entityManager.merge((Object)user);
        for (AbstractVirAttr abstractVirAttr : merged.getVirtualAttributes()) {
            abstractVirAttr.setValues(((AbstractVirAttr)user.getVirtualAttribute(((AbstractVirSchema)abstractVirAttr.getVirtualSchema()).getName())).getValues());
        }
        return merged;
    }

    @Override
    public void delete(Long id) {
        SyncopeUser user = this.find(id);
        if (user == null) {
            return;
        }
        this.delete(user);
    }

    @Override
    public void delete(SyncopeUser user) {
        for (Membership membership : user.getMemberships()) {
            membership.setSyncopeUser(null);
            this.roleDAO.save(membership.getSyncopeRole());
            membership.setSyncopeRole(null);
            this.entityManager.remove((Object)membership);
        }
        user.getMemberships().clear();
        for (PropagationTask task : this.taskDAO.findAll(user)) {
            task.setSyncopeUser(null);
        }
        this.entityManager.remove((Object)user);
    }

    private Set<String> getWhereClause(String expression, String value) throws InvalidSearchConditionException {
        Token token;
        Parser parser = new Parser((Reader)new StringReader(expression));
        ArrayList<String> identifiers = new ArrayList<String>();
        ArrayList<String> literals = new ArrayList<String>();
        while ((token = parser.getNextToken()) != null && StringUtils.hasText((String)token.toString())) {
            if (token.kind == 62) {
                literals.add(token.toString().substring(1, token.toString().length() - 1));
            }
            if (token.kind != 56) continue;
            identifiers.add(token.toString());
        }
        Collections.sort(literals, new Comparator<String>(){

            @Override
            public int compare(String t, String t1) {
                if (t == null && t1 == null) {
                    return 0;
                }
                if (t != null && t1 == null) {
                    return -1;
                }
                if (t == null && t1 != null) {
                    return 1;
                }
                if (t.length() == t1.length()) {
                    return 0;
                }
                if (t.length() > t1.length()) {
                    return -1;
                }
                return 1;
            }
        });
        List<String> attrValues = this.split(value, literals);
        if (attrValues.size() != identifiers.size()) {
            LOG.error("Ambiguous jexl expression resolution.");
            throw new InvalidSearchConditionException("literals and values have different size");
        }
        HashSet<String> clauses = new HashSet<String>();
        StringBuilder bld = new StringBuilder();
        HashSet used = new HashSet();
        for (int i = 0; i < identifiers.size(); ++i) {
            if (used.contains(identifiers.get(i))) continue;
            USchema schema = this.schemaDAO.find((String)identifiers.get(i), USchema.class);
            if (schema == null) {
                LOG.error("Invalid schema name '{}'", identifiers.get(i));
                throw new InvalidSearchConditionException("Invalid schema name " + (String)identifiers.get(i));
            }
            bld.delete(0, bld.length());
            bld.append("(");
            bld.append("s.name = '").append((String)identifiers.get(i)).append("'");
            bld.append(" AND ");
            bld.append("s.name = a.schema_name").append(" AND ");
            bld.append("a.id = v.attribute_id");
            bld.append(" AND ");
            switch (schema.getType()) {
                case Boolean: {
                    bld.append("v.booleanValue = '").append(attrValues.get(i)).append("'");
                    break;
                }
                case Long: {
                    bld.append("v.longValue = ").append(attrValues.get(i));
                    break;
                }
                case Double: {
                    bld.append("v.doubleValue = ").append(attrValues.get(i));
                    break;
                }
                case Date: {
                    bld.append("v.dateValue = '").append(attrValues.get(i)).append("'");
                    break;
                }
                default: {
                    bld.append("v.stringValue = '").append(attrValues.get(i)).append("'");
                }
            }
            bld.append(")");
            used.add(identifiers.get(i));
            clauses.add(bld.toString());
        }
        LOG.debug("Generated where clauses {}", clauses);
        return clauses;
    }

    private List<String> split(String attrValue, List<String> literals) {
        ArrayList<String> attrValues = new ArrayList<String>();
        if (literals.isEmpty()) {
            attrValues.add(attrValue);
        } else {
            for (String token : attrValue.split(Pattern.quote(literals.get(0)))) {
                attrValues.addAll(this.split(token, literals.subList(1, literals.size())));
            }
        }
        return attrValues;
    }
}

