/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.dao.impl;

import java.util.List;
import javax.persistence.Query;
import org.apache.syncope.core.persistence.beans.SchedTask;
import org.apache.syncope.core.persistence.beans.SyncTask;
import org.apache.syncope.core.persistence.beans.Task;
import org.apache.syncope.core.persistence.beans.TaskExec;
import org.apache.syncope.core.persistence.dao.TaskDAO;
import org.apache.syncope.core.persistence.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.dao.impl.AbstractDAOImpl;
import org.apache.syncope.core.persistence.validation.entity.InvalidEntityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class TaskExecDAOImpl
extends AbstractDAOImpl
implements TaskExecDAO {
    @Autowired
    private TaskDAO taskDAO;

    @Override
    public TaskExec find(Long id) {
        return (TaskExec)this.entityManager.find(TaskExec.class, (Object)id);
    }

    private <T extends Task> TaskExec findLatest(T task, String field) {
        Query query = this.entityManager.createQuery("SELECT e FROM " + TaskExec.class.getSimpleName() + " e " + "WHERE e.task=:task " + "ORDER BY e." + field + " DESC");
        query.setParameter("task", task);
        query.setMaxResults(1);
        List result = query.getResultList();
        return result == null || result.isEmpty() ? null : (TaskExec)result.iterator().next();
    }

    @Override
    public <T extends Task> TaskExec findLatestStarted(T task) {
        return this.findLatest(task, "startDate");
    }

    @Override
    public <T extends Task> TaskExec findLatestEnded(T task) {
        return this.findLatest(task, "endDate");
    }

    @Override
    public <T extends Task> List<TaskExec> findAll(Class<T> reference) {
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(TaskExec.class.getSimpleName()).append(" e WHERE e.task IN (").append("SELECT t FROM ").append(reference.getSimpleName()).append(" t");
        if (SchedTask.class.equals(reference)) {
            queryString.append(" WHERE t.id NOT IN (SELECT t.id FROM ").append(SyncTask.class.getSimpleName()).append(" t) ");
        }
        queryString.append(')');
        Query query = this.entityManager.createQuery(queryString.toString());
        return query.getResultList();
    }

    @Override
    public TaskExec save(TaskExec execution) {
        return (TaskExec)this.entityManager.merge((Object)execution);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void saveAndAdd(Long taskId, TaskExec execution) throws InvalidEntityException {
        Object task = this.taskDAO.find(taskId);
        ((Task)task).addExec(execution);
        this.taskDAO.save(task);
    }

    @Override
    public void delete(Long id) {
        TaskExec execution = this.find(id);
        if (execution == null) {
            return;
        }
        this.delete(execution);
    }

    @Override
    public void delete(TaskExec execution) {
        if (execution.getTask() != null) {
            execution.getTask().removeExec(execution);
        }
        this.entityManager.remove((Object)execution);
    }
}

