/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.dao.impl;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.NotificationTask;
import org.apache.syncope.core.persistence.beans.PropagationTask;
import org.apache.syncope.core.persistence.beans.SchedTask;
import org.apache.syncope.core.persistence.beans.SyncTask;
import org.apache.syncope.core.persistence.beans.Task;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.dao.TaskDAO;
import org.apache.syncope.core.persistence.dao.impl.AbstractDAOImpl;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class TaskDAOImpl
extends AbstractDAOImpl
implements TaskDAO {
    @Override
    @Transactional(readOnly=true)
    public <T extends Task> T find(Long id) {
        return (T)((Task)this.entityManager.find(Task.class, (Object)id));
    }

    private <T extends Task> StringBuilder buildfindAllQuery(Class<T> reference) {
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(reference.getSimpleName()).append(" e ");
        if (SchedTask.class.equals(reference)) {
            queryString.append("WHERE e.id NOT IN (SELECT e.id FROM ").append(SyncTask.class.getSimpleName()).append(" e) ");
        }
        return queryString;
    }

    @Override
    public <T extends Task> List<T> findToExec(Class<T> reference) {
        StringBuilder queryString = this.buildfindAllQuery(reference);
        if (SchedTask.class.equals(reference)) {
            queryString.append("AND ");
        } else {
            queryString.append("WHERE ");
        }
        if (reference.equals(NotificationTask.class)) {
            queryString.append("e.executed = 0 ");
        } else {
            queryString.append("e.executions IS EMPTY ");
        }
        queryString.append("ORDER BY e.id DESC");
        Query query = this.entityManager.createQuery(queryString.toString());
        return query.getResultList();
    }

    @Override
    public <T extends Task> List<T> findAll(ExternalResource resource, Class<T> reference) {
        StringBuilder queryString = this.buildfindAllQuery(reference);
        if (SchedTask.class.equals(reference)) {
            queryString.append("AND ");
        } else {
            queryString.append("WHERE ");
        }
        queryString.append("e.resource=:resource ");
        queryString.append("ORDER BY e.id DESC");
        Query query = this.entityManager.createQuery(queryString.toString());
        query.setParameter("resource", (Object)resource);
        return query.getResultList();
    }

    @Override
    public <T extends Task> List<T> findAll(Class<T> reference) {
        return this.findAll(-1, -1, reference);
    }

    @Override
    public <T extends Task> List<T> findAll(int page, int itemsPerPage, Class<T> reference) {
        StringBuilder queryString = this.buildfindAllQuery(reference);
        queryString.append("ORDER BY e.id DESC");
        Query query = this.entityManager.createQuery(queryString.toString());
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage > 0) {
            query.setMaxResults(itemsPerPage);
        }
        return query.getResultList();
    }

    @Override
    public List<PropagationTask> findAll(SyncopeUser user) {
        StringBuilder queryString = this.buildfindAllQuery(PropagationTask.class);
        queryString.append("WHERE e.syncopeUser=:user ");
        queryString.append("ORDER BY e.id DESC");
        Query query = this.entityManager.createQuery(queryString.toString());
        query.setParameter("user", (Object)user);
        return query.getResultList();
    }

    @Override
    public List<PropagationTask> findAll(ExternalResource resource, SyncopeUser user) {
        StringBuilder queryString = this.buildfindAllQuery(PropagationTask.class);
        queryString.append("WHERE e.syncopeUser=:user ");
        queryString.append("AND e.resource=:resource ");
        queryString.append("ORDER BY e.id DESC");
        Query query = this.entityManager.createQuery(queryString.toString());
        query.setParameter("user", (Object)user);
        query.setParameter("resource", (Object)resource);
        return query.getResultList();
    }

    @Override
    public <T extends Task> int count(Class<T> reference) {
        Query countQuery = this.entityManager.createNativeQuery("SELECT COUNT(id) FROM Task WHERE DTYPE=?1");
        countQuery.setParameter(1, (Object)reference.getSimpleName());
        return ((Number)countQuery.getSingleResult()).intValue();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public <T extends Task> T save(T task) {
        return (T)((Task)this.entityManager.merge(task));
    }

    @Override
    public <T extends Task> void delete(Long id) {
        T task = this.find(id);
        if (task == null) {
            return;
        }
        this.delete(task);
    }

    @Override
    public <T extends Task> void delete(T task) {
        this.entityManager.remove(task);
    }

    @Override
    public <T extends Task> void deleteAll(ExternalResource resource, Class<T> reference) {
        List<T> tasks = this.findAll(resource, reference);
        if (tasks != null) {
            ArrayList<Long> taskIds = new ArrayList<Long>(tasks.size());
            for (Task task : tasks) {
                taskIds.add(task.getId());
            }
            for (Long taskId : taskIds) {
                this.delete(taskId);
            }
        }
    }
}

