/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.dao.impl;

import java.util.HashSet;
import java.util.List;
import javax.persistence.Query;
import org.apache.syncope.core.persistence.beans.AbstractAttr;
import org.apache.syncope.core.persistence.beans.AbstractSchema;
import org.apache.syncope.core.persistence.dao.AttrDAO;
import org.apache.syncope.core.persistence.dao.ResourceDAO;
import org.apache.syncope.core.persistence.dao.SchemaDAO;
import org.apache.syncope.core.persistence.dao.impl.AbstractDAOImpl;
import org.apache.syncope.core.util.AttributableUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SchemaDAOImpl
extends AbstractDAOImpl
implements SchemaDAO {
    @Autowired
    private AttrDAO attributeDAO;
    @Autowired
    private ResourceDAO resourceDAO;

    @Override
    public <T extends AbstractSchema> T find(String name, Class<T> reference) {
        return (T)((AbstractSchema)this.entityManager.find(reference, (Object)name));
    }

    @Override
    public <T extends AbstractSchema> List<T> findAll(Class<T> reference) {
        Query query = this.entityManager.createQuery("SELECT e FROM " + reference.getSimpleName() + " e");
        return query.getResultList();
    }

    @Override
    public <T extends AbstractAttr> List<T> getAttributes(AbstractSchema schema, Class<T> reference) {
        Query query = this.entityManager.createQuery("SELECT e FROM " + reference.getSimpleName() + " e" + " WHERE e.schema=:schema");
        query.setParameter("schema", (Object)schema);
        return query.getResultList();
    }

    @Override
    public <T extends AbstractSchema> T save(T schema) {
        return (T)((AbstractSchema)this.entityManager.merge(schema));
    }

    @Override
    public void delete(String name, AttributableUtil attributableUtil) {
        Object schema = this.find(name, attributableUtil.schemaClass());
        if (schema == null) {
            return;
        }
        List attributes = this.getAttributes((AbstractSchema)schema, attributableUtil.attributeClass());
        HashSet<Long> attributeIds = new HashSet<Long>(attributes.size());
        for (AbstractAttr attribute : attributes) {
            attributeIds.add(attribute.getId());
        }
        for (Long attributeId : attributeIds) {
            this.attributeDAO.delete(attributeId, attributableUtil.attributeClass());
        }
        this.resourceDAO.deleteMappings(name, attributableUtil.intMappingType());
        this.entityManager.remove(schema);
    }
}

