/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.dao.impl;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.beans.Entitlement;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.membership.Membership;
import org.apache.syncope.core.persistence.beans.role.SyncopeRole;
import org.apache.syncope.core.persistence.dao.EntitlementDAO;
import org.apache.syncope.core.persistence.dao.RoleDAO;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.apache.syncope.core.persistence.dao.impl.AbstractDAOImpl;
import org.apache.syncope.core.util.EntitlementUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class RoleDAOImpl
extends AbstractDAOImpl
implements RoleDAO {
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private EntitlementDAO entitlementDAO;

    @Override
    public SyncopeRole find(Long id) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM SyncopeRole e WHERE e.id = :id", SyncopeRole.class);
        query.setParameter("id", (Object)id);
        SyncopeRole result = null;
        try {
            result = (SyncopeRole)query.getSingleResult();
        }
        catch (NoResultException e) {
            // empty catch block
        }
        return result;
    }

    @Override
    public List<SyncopeRole> find(String name) {
        Query query = this.entityManager.createQuery("SELECT e FROM SyncopeRole e WHERE e.name = :name");
        query.setParameter("name", (Object)name);
        return query.getResultList();
    }

    @Override
    public SyncopeRole find(String name, Long parentId) {
        Query query;
        if (parentId != null) {
            query = this.entityManager.createQuery("SELECT r FROM SyncopeRole r WHERE r.name=:name AND r.parent.id=:parentId");
            query.setParameter("parentId", (Object)parentId);
        } else {
            query = this.entityManager.createQuery("SELECT r FROM SyncopeRole r WHERE r.name=:name AND r.parent IS NULL");
        }
        query.setParameter("name", (Object)name);
        List result = query.getResultList();
        return result.isEmpty() ? null : (SyncopeRole)result.get(0);
    }

    @Override
    public List<SyncopeRole> findByEntitlement(Entitlement entitlement) {
        Query query = this.entityManager.createQuery("SELECT e FROM " + SyncopeRole.class.getSimpleName() + " e " + "WHERE :entitlement MEMBER OF e.entitlements");
        query.setParameter("entitlement", (Object)entitlement);
        return query.getResultList();
    }

    @Override
    public List<SyncopeRole> findByResource(ExternalResource resource) {
        Query query = this.entityManager.createQuery("SELECT e FROM " + SyncopeRole.class.getSimpleName() + " e " + "WHERE :resource MEMBER OF e.resources");
        query.setParameter("resource", (Object)resource);
        return query.getResultList();
    }

    private void findAncestors(List<SyncopeRole> result, SyncopeRole role) {
        if (role.getParent() != null && !result.contains(role.getParent())) {
            result.add(role.getParent());
            this.findAncestors(result, role.getParent());
        }
    }

    @Override
    public List<SyncopeRole> findAncestors(SyncopeRole role) {
        ArrayList<SyncopeRole> result = new ArrayList<SyncopeRole>();
        this.findAncestors(result, role);
        return result;
    }

    @Override
    public List<SyncopeRole> findChildren(Long roleId) {
        Query query = this.entityManager.createQuery("SELECT r FROM SyncopeRole r WHERE r.parent.id=:roleId");
        query.setParameter("roleId", (Object)roleId);
        return query.getResultList();
    }

    private void findDescendants(List<SyncopeRole> result, SyncopeRole role) {
        List<SyncopeRole> children = this.findChildren(role.getId());
        if (children != null) {
            for (SyncopeRole child : children) {
                this.findDescendants(result, child);
            }
        }
        result.add(role);
    }

    @Override
    public List<SyncopeRole> findDescendants(SyncopeRole role) {
        ArrayList<SyncopeRole> result = new ArrayList<SyncopeRole>();
        this.findDescendants(result, role);
        return result;
    }

    @Override
    public List<SyncopeRole> findAll() {
        Query query = this.entityManager.createQuery("SELECT e FROM SyncopeRole e");
        return query.getResultList();
    }

    @Override
    public List<Membership> findMemberships(SyncopeRole role) {
        Query query = this.entityManager.createQuery("SELECT e FROM " + Membership.class.getSimpleName() + " e" + " WHERE e.syncopeRole=:role");
        query.setParameter("role", (Object)role);
        return query.getResultList();
    }

    @Override
    public SyncopeRole save(SyncopeRole role) {
        if (role.isInheritAccountPolicy()) {
            role.setAccountPolicy(null);
        }
        if (role.isInheritPasswordPolicy()) {
            role.setPasswordPolicy(null);
        }
        SyncopeRole savedRole = (SyncopeRole)this.entityManager.merge((Object)role);
        this.entitlementDAO.saveEntitlementRole(savedRole);
        return savedRole;
    }

    @Override
    public void delete(Long id) {
        SyncopeRole role = this.find(id);
        if (role == null) {
            return;
        }
        for (SyncopeRole roleToBeDeleted : this.findDescendants(role)) {
            for (Membership membership : this.findMemberships(roleToBeDeleted)) {
                membership.getSyncopeUser().removeMembership(membership);
                this.userDAO.save(membership.getSyncopeUser());
                this.entityManager.remove((Object)membership);
            }
            roleToBeDeleted.getEntitlements().clear();
            roleToBeDeleted.setParent(null);
            this.entityManager.remove((Object)roleToBeDeleted);
            this.entitlementDAO.delete(EntitlementUtil.getEntitlementNameFromRoleId(roleToBeDeleted.getId()));
        }
    }
}

