/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.dao.impl;

import java.util.List;
import javassist.NotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.init.ConnInstanceLoader;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.PropagationTask;
import org.apache.syncope.core.persistence.beans.SchemaMapping;
import org.apache.syncope.core.persistence.beans.SyncTask;
import org.apache.syncope.core.persistence.beans.role.SyncopeRole;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.dao.ResourceDAO;
import org.apache.syncope.core.persistence.dao.RoleDAO;
import org.apache.syncope.core.persistence.dao.TaskDAO;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.apache.syncope.core.persistence.dao.impl.AbstractDAOImpl;
import org.apache.syncope.types.IntMappingType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class ResourceDAOImpl
extends AbstractDAOImpl
implements ResourceDAO {
    @Autowired
    private TaskDAO taskDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private RoleDAO roleDAO;
    @Autowired
    private ConnInstanceLoader connInstanceLoader;

    @Override
    public ExternalResource find(String name) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + ExternalResource.class.getSimpleName() + " e " + "WHERE e.name = :name", ExternalResource.class);
        query.setParameter("name", (Object)name);
        ExternalResource result = null;
        try {
            result = (ExternalResource)query.getSingleResult();
        }
        catch (NoResultException e) {
            // empty catch block
        }
        return result;
    }

    @Override
    public List<ExternalResource> findAll() {
        Query query = this.entityManager.createQuery("SELECT e FROM  " + ExternalResource.class.getSimpleName() + " e");
        return query.getResultList();
    }

    @Override
    public List<ExternalResource> findAllByPriority() {
        Query query = this.entityManager.createQuery("SELECT e FROM  " + ExternalResource.class.getSimpleName() + " e " + "ORDER BY e.propagationPriority");
        return query.getResultList();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public ExternalResource save(ExternalResource resource) {
        ExternalResource merged = (ExternalResource)this.entityManager.merge((Object)resource);
        try {
            this.connInstanceLoader.registerConnector(merged);
        }
        catch (NotFoundException e) {
            LOG.error("While registering connector for resource", (Throwable)e);
        }
        return merged;
    }

    @Override
    public List<SchemaMapping> findAllMappings() {
        Query query = this.entityManager.createQuery("SELECT e FROM " + SchemaMapping.class.getSimpleName() + " e");
        return query.getResultList();
    }

    @Override
    public SchemaMapping getMappingForAccountId(String resourceName) {
        Query query = this.entityManager.createQuery("SELECT m FROM " + SchemaMapping.class.getSimpleName() + " m " + "WHERE m.resource.name=:resourceName " + "AND m.accountid = 1");
        query.setParameter("resourceName", (Object)resourceName);
        return (SchemaMapping)query.getSingleResult();
    }

    @Override
    public void deleteMappings(String intAttrName, IntMappingType intMappingType) {
        if (intMappingType == IntMappingType.SyncopeUserId || intMappingType == IntMappingType.Password || intMappingType == IntMappingType.Username) {
            return;
        }
        Query query = this.entityManager.createQuery("DELETE FROM " + SchemaMapping.class.getSimpleName() + " m WHERE m.intAttrName=:intAttrName " + "AND m.intMappingType=:intMappingType");
        query.setParameter("intAttrName", (Object)intAttrName);
        query.setParameter("intMappingType", (Object)intMappingType);
        int items = query.executeUpdate();
        LOG.debug("Removed {} schema mappings", (Object)items);
        this.entityManager.getEntityManagerFactory().getCache().evict(SchemaMapping.class);
    }

    @Override
    public void delete(String name) {
        ExternalResource resource = this.find(name);
        if (resource == null) {
            return;
        }
        this.taskDAO.deleteAll(resource, PropagationTask.class);
        this.taskDAO.deleteAll(resource, SyncTask.class);
        for (SyncopeUser user : this.userDAO.findByResource(resource)) {
            user.removeResource(resource);
        }
        for (SyncopeRole role : this.roleDAO.findByResource(resource)) {
            role.removeResource(resource);
        }
        if (resource.getConnector() != null && resource.getConnector().getResources() != null && !resource.getConnector().getResources().isEmpty()) {
            resource.getConnector().getResources().remove(resource);
        }
        resource.setConnector(null);
        this.entityManager.remove((Object)resource);
    }
}

