/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.dao.impl;

import java.util.List;
import javax.persistence.Query;
import org.apache.syncope.core.persistence.beans.Report;
import org.apache.syncope.core.persistence.beans.ReportExec;
import org.apache.syncope.core.persistence.dao.ReportExecDAO;
import org.apache.syncope.core.persistence.dao.impl.AbstractDAOImpl;
import org.apache.syncope.core.persistence.validation.entity.InvalidEntityException;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class ReportExecDAOImpl
extends AbstractDAOImpl
implements ReportExecDAO {
    @Override
    public ReportExec find(Long id) {
        return (ReportExec)this.entityManager.find(ReportExec.class, (Object)id);
    }

    private ReportExec findLatest(Report report, String field) {
        Query query = this.entityManager.createQuery("SELECT e FROM " + ReportExec.class.getSimpleName() + " e " + "WHERE e.report=:report " + "ORDER BY e." + field + " DESC");
        query.setParameter("report", (Object)report);
        query.setMaxResults(1);
        List result = query.getResultList();
        return result == null || result.isEmpty() ? null : (ReportExec)result.iterator().next();
    }

    @Override
    public ReportExec findLatestStarted(Report report) {
        return this.findLatest(report, "startDate");
    }

    @Override
    public ReportExec findLatestEnded(Report report) {
        return this.findLatest(report, "endDate");
    }

    @Override
    public List<ReportExec> findAll() {
        Query query = this.entityManager.createQuery("SELECT e FROM " + ReportExec.class.getSimpleName() + " e");
        return query.getResultList();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public ReportExec save(ReportExec execution) throws InvalidEntityException {
        return (ReportExec)this.entityManager.merge((Object)execution);
    }

    @Override
    public void delete(Long id) {
        ReportExec execution = this.find(id);
        if (execution == null) {
            return;
        }
        this.delete(execution);
    }

    @Override
    public void delete(ReportExec execution) {
        if (execution.getReport() != null) {
            execution.getReport().removeExec(execution);
        }
        this.entityManager.remove((Object)execution);
    }
}

