/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.dao.impl;

import java.util.List;
import javax.persistence.Query;
import org.apache.syncope.core.persistence.beans.AccountPolicy;
import org.apache.syncope.core.persistence.beans.PasswordPolicy;
import org.apache.syncope.core.persistence.beans.Policy;
import org.apache.syncope.core.persistence.beans.SyncPolicy;
import org.apache.syncope.core.persistence.dao.PolicyDAO;
import org.apache.syncope.core.persistence.dao.impl.AbstractDAOImpl;
import org.apache.syncope.types.PolicyType;
import org.springframework.stereotype.Repository;

@Repository
public class PolicyDAOImpl
extends AbstractDAOImpl
implements PolicyDAO {
    @Override
    public Policy find(Long id) {
        return (Policy)this.entityManager.find(Policy.class, (Object)id);
    }

    @Override
    public List<? extends Policy> find(PolicyType type) {
        Query query = this.entityManager.createQuery("SELECT e FROM Policy e WHERE e.type=:type");
        query.setParameter("type", (Object)type);
        return query.getResultList();
    }

    @Override
    public PasswordPolicy getGlobalPasswordPolicy() {
        List<? extends Policy> policies = this.find(PolicyType.GLOBAL_PASSWORD);
        return policies == null || policies.isEmpty() ? null : (PasswordPolicy)policies.get(0);
    }

    @Override
    public AccountPolicy getGlobalAccountPolicy() {
        List<? extends Policy> policies = this.find(PolicyType.GLOBAL_ACCOUNT);
        return policies == null || policies.isEmpty() ? null : (AccountPolicy)policies.get(0);
    }

    @Override
    public SyncPolicy getGlobalSyncPolicy() {
        List<? extends Policy> policies = this.find(PolicyType.GLOBAL_SYNC);
        return policies == null || policies.isEmpty() ? null : (SyncPolicy)policies.get(0);
    }

    @Override
    public List<Policy> findAll() {
        Query query = this.entityManager.createQuery("SELECT e FROM Policy e");
        return query.getResultList();
    }

    public Policy save(Policy policy) {
        return (Policy)this.entityManager.merge((Object)policy);
    }

    @Override
    public void delete(Long id) {
        this.entityManager.remove((Object)this.find(id));
    }
}

