/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.dao.impl;

import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.syncope.core.persistence.beans.membership.Membership;
import org.apache.syncope.core.persistence.beans.role.SyncopeRole;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.dao.MembershipDAO;
import org.apache.syncope.core.persistence.dao.RoleDAO;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.apache.syncope.core.persistence.dao.impl.AbstractDAOImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class MembershipDAOImpl
extends AbstractDAOImpl
implements MembershipDAO {
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private RoleDAO roleDAO;

    @Override
    public Membership find(Long id) {
        return (Membership)this.entityManager.find(Membership.class, (Object)id);
    }

    @Override
    public Membership find(SyncopeUser user, SyncopeRole role) {
        Membership result;
        block2: {
            Query query = this.entityManager.createQuery("SELECT e FROM Membership e WHERE e.syncopeUser = :user AND e.syncopeRole = :role");
            query.setParameter("user", (Object)user);
            query.setParameter("role", (Object)role);
            result = null;
            try {
                result = (Membership)query.getSingleResult();
            }
            catch (NoResultException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("No membership was found for user " + user + " and role " + role);
            }
        }
        return result;
    }

    @Override
    public List<Membership> findAll() {
        Query query = this.entityManager.createQuery("SELECT e FROM Membership e");
        return query.getResultList();
    }

    @Override
    public Membership save(Membership membership) {
        return (Membership)this.entityManager.merge((Object)membership);
    }

    @Override
    public void delete(Long id) {
        Membership membership = this.find(id);
        if (membership == null) {
            return;
        }
        membership.getSyncopeUser().removeMembership(membership);
        this.userDAO.save(membership.getSyncopeUser());
        this.entityManager.remove((Object)membership);
    }
}

