/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.dao.impl;

import java.util.List;
import javax.persistence.Query;
import org.apache.syncope.core.persistence.beans.Entitlement;
import org.apache.syncope.core.persistence.beans.role.SyncopeRole;
import org.apache.syncope.core.persistence.dao.EntitlementDAO;
import org.apache.syncope.core.persistence.dao.RoleDAO;
import org.apache.syncope.core.persistence.dao.impl.AbstractDAOImpl;
import org.apache.syncope.core.util.EntitlementUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class EntitlementDAOImpl
extends AbstractDAOImpl
implements EntitlementDAO {
    @Autowired
    private RoleDAO roleDAO;

    @Override
    public Entitlement find(String name) {
        return (Entitlement)this.entityManager.find(Entitlement.class, (Object)name);
    }

    @Override
    public List<Entitlement> findAll() {
        Query query = this.entityManager.createQuery("SELECT e FROM Entitlement e");
        return query.getResultList();
    }

    @Override
    public Entitlement save(Entitlement entitlement) {
        return (Entitlement)this.entityManager.merge((Object)entitlement);
    }

    @Override
    public Entitlement saveEntitlementRole(SyncopeRole role) {
        Entitlement roleEnt = new Entitlement();
        roleEnt.setName(EntitlementUtil.getEntitlementNameFromRoleId(role.getId()));
        roleEnt.setDescription("Entitlement for managing role " + role.getId());
        return this.save(roleEnt);
    }

    @Override
    public void delete(String name) {
        Entitlement entitlement = this.find(name);
        if (entitlement == null) {
            return;
        }
        this.delete(entitlement);
    }

    @Override
    public void delete(Entitlement entitlement) {
        if (entitlement == null) {
            return;
        }
        for (SyncopeRole role : this.roleDAO.findByEntitlement(entitlement)) {
            role.removeEntitlement(entitlement);
            this.roleDAO.save(role);
        }
        this.entityManager.remove((Object)entitlement);
    }
}

