/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.dao.impl;

import java.util.HashSet;
import java.util.List;
import javax.persistence.Query;
import org.apache.syncope.core.persistence.beans.AbstractDerAttr;
import org.apache.syncope.core.persistence.beans.AbstractDerSchema;
import org.apache.syncope.core.persistence.dao.DerAttrDAO;
import org.apache.syncope.core.persistence.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.dao.ResourceDAO;
import org.apache.syncope.core.persistence.dao.impl.AbstractDAOImpl;
import org.apache.syncope.core.util.AttributableUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DerSchemaDAOImpl
extends AbstractDAOImpl
implements DerSchemaDAO {
    @Autowired
    private DerAttrDAO derivedAttributeDAO;
    @Autowired
    private ResourceDAO resourceDAO;

    @Override
    public <T extends AbstractDerSchema> T find(String name, Class<T> reference) {
        return (T)((AbstractDerSchema)this.entityManager.find(reference, (Object)name));
    }

    @Override
    public <T extends AbstractDerSchema> List<T> findAll(Class<T> reference) {
        Query query = this.entityManager.createQuery("SELECT e FROM " + reference.getSimpleName() + " e");
        return query.getResultList();
    }

    @Override
    public <T extends AbstractDerSchema> T save(T derivedSchema) {
        return (T)((AbstractDerSchema)this.entityManager.merge(derivedSchema));
    }

    @Override
    public void delete(String name, AttributableUtil attributableUtil) {
        Object derivedSchema = this.find(name, attributableUtil.derivedSchemaClass());
        if (derivedSchema == null) {
            return;
        }
        List attributes = this.getAttributes((AbstractDerSchema)derivedSchema, attributableUtil.derivedAttributeClass());
        HashSet<Long> derivedAttributeIds = new HashSet<Long>(attributes.size());
        Class<?> attributeClass = null;
        for (AbstractDerAttr attribute : attributes) {
            derivedAttributeIds.add(attribute.getId());
            attributeClass = attribute.getClass();
        }
        for (Long derivedAttributeId : derivedAttributeIds) {
            this.derivedAttributeDAO.delete(derivedAttributeId, attributeClass);
        }
        this.resourceDAO.deleteMappings(name, attributableUtil.derivedIntMappingType());
        this.entityManager.remove(derivedSchema);
    }

    @Override
    public <T extends AbstractDerAttr> List<T> getAttributes(AbstractDerSchema derivedSchema, Class<T> reference) {
        Query query = this.entityManager.createQuery("SELECT e FROM " + reference.getSimpleName() + " e" + " WHERE e.derivedSchema=:schema");
        query.setParameter("schema", (Object)derivedSchema);
        return query.getResultList();
    }
}

