/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.dao.impl;

import java.util.HashSet;
import java.util.List;
import javassist.NotFoundException;
import javax.persistence.Query;
import org.apache.syncope.core.init.ConnInstanceLoader;
import org.apache.syncope.core.persistence.beans.ConnInstance;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.dao.ResourceDAO;
import org.apache.syncope.core.persistence.dao.impl.AbstractDAOImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ConnInstanceDAOImpl
extends AbstractDAOImpl
implements ConnInstanceDAO {
    @Autowired
    private ResourceDAO resourceDAO;
    @Autowired
    private ConnInstanceLoader connInstanceLoader;

    @Override
    public ConnInstance find(Long id) {
        return (ConnInstance)this.entityManager.find(ConnInstance.class, (Object)id);
    }

    @Override
    public List<ConnInstance> findAll() {
        Query query = this.entityManager.createQuery("SELECT e FROM " + ConnInstance.class.getSimpleName() + " e");
        return query.getResultList();
    }

    @Override
    public ConnInstance save(ConnInstance connector) {
        ConnInstance merged = (ConnInstance)this.entityManager.merge((Object)connector);
        for (ExternalResource resource : merged.getResources()) {
            try {
                this.connInstanceLoader.registerConnector(resource);
            }
            catch (NotFoundException e) {
                LOG.error("While registering connector for resource", (Throwable)e);
            }
        }
        return merged;
    }

    @Override
    public void delete(Long id) {
        ConnInstance connInstance = this.find(id);
        if (connInstance == null) {
            return;
        }
        HashSet<String> resourceNames = new HashSet<String>(connInstance.getResources().size());
        for (ExternalResource resource : connInstance.getResources()) {
            resourceNames.add(resource.getName());
        }
        for (String resourceName : resourceNames) {
            this.resourceDAO.delete(resourceName);
        }
        this.entityManager.remove((Object)connInstance);
        this.connInstanceLoader.unregisterConnector(id.toString());
    }
}

