/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.dao.impl;

import java.util.List;
import javax.persistence.Query;
import org.apache.syncope.core.persistence.beans.SyncopeConf;
import org.apache.syncope.core.persistence.dao.ConfDAO;
import org.apache.syncope.core.persistence.dao.MissingConfKeyException;
import org.apache.syncope.core.persistence.dao.impl.AbstractDAOImpl;
import org.springframework.stereotype.Repository;

@Repository
public class ConfDAOImpl
extends AbstractDAOImpl
implements ConfDAO {
    @Override
    public SyncopeConf find(String name) throws MissingConfKeyException {
        SyncopeConf result = this.find(name, null);
        if (result == null) {
            throw new MissingConfKeyException(name);
        }
        return result;
    }

    @Override
    public SyncopeConf find(String name, String defaultValue) {
        SyncopeConf syncopeConf = (SyncopeConf)this.entityManager.find(SyncopeConf.class, (Object)name);
        if (syncopeConf == null && defaultValue != null) {
            syncopeConf = new SyncopeConf();
            syncopeConf.setKey(name);
            syncopeConf.setValue(defaultValue);
        }
        return syncopeConf;
    }

    @Override
    public List<SyncopeConf> findAll() {
        Query query = this.entityManager.createQuery("SELECT e FROM SyncopeConf e");
        return query.getResultList();
    }

    @Override
    public SyncopeConf save(SyncopeConf syncopeConfiguration) {
        return (SyncopeConf)this.entityManager.merge((Object)syncopeConfiguration);
    }

    @Override
    public void delete(String name) {
        try {
            this.entityManager.remove((Object)this.find(name));
        }
        catch (MissingConfKeyException e) {
            LOG.error("Could not find configuration key '" + name + "'");
        }
    }
}

