/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.dao.impl;

import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.apache.syncope.core.persistence.beans.AbstractBaseBean;
import org.apache.syncope.core.persistence.dao.DAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.annotation.Value;

@Configurable
public abstract class AbstractDAOImpl
implements DAO {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractDAOImpl.class);
    private String CACHE_STORE_MODE = "javax.persistence.cache.storeMode";
    private String CACHE_RETRIEVE_MODE = "javax.persistence.cache.retrieveMode";
    @Value(value="#{entityManager}")
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager entityManager;

    protected CacheRetrieveMode getCacheRetrieveMode() {
        return this.entityManager.getProperties().containsKey(this.CACHE_RETRIEVE_MODE) ? (CacheRetrieveMode)this.entityManager.getProperties().get(this.CACHE_RETRIEVE_MODE) : CacheRetrieveMode.BYPASS;
    }

    protected void setCacheRetrieveMode(CacheRetrieveMode retrieveMode) {
        if (retrieveMode != null) {
            this.entityManager.getProperties().put(this.CACHE_RETRIEVE_MODE, retrieveMode);
        }
    }

    protected CacheStoreMode getCacheStoreMode() {
        return this.entityManager.getProperties().containsKey(this.CACHE_STORE_MODE) ? (CacheStoreMode)this.entityManager.getProperties().get(this.CACHE_STORE_MODE) : CacheStoreMode.BYPASS;
    }

    protected void setCacheStoreMode(CacheStoreMode storeMode) {
        if (storeMode != null) {
            this.entityManager.getProperties().put(this.CACHE_STORE_MODE, storeMode);
        }
    }

    @Override
    public <T extends AbstractBaseBean> void refresh(T entity) {
        this.entityManager.refresh(entity);
    }

    @Override
    public void detach(Object object) {
        this.entityManager.detach(object);
    }

    @Override
    public void flush() {
        this.entityManager.flush();
    }

    @Override
    public void clear() {
        this.entityManager.clear();
    }
}

