/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.beans.user;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.syncope.core.persistence.beans.AbstractAttr;
import org.apache.syncope.core.persistence.beans.AbstractAttributable;
import org.apache.syncope.core.persistence.beans.AbstractDerAttr;
import org.apache.syncope.core.persistence.beans.AbstractVirAttr;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.membership.Membership;
import org.apache.syncope.core.persistence.beans.role.SyncopeRole;
import org.apache.syncope.core.persistence.beans.user.UAttr;
import org.apache.syncope.core.persistence.beans.user.UDerAttr;
import org.apache.syncope.core.persistence.beans.user.UVirAttr;
import org.apache.syncope.core.persistence.validation.entity.SyncopeUserCheck;
import org.apache.syncope.types.CipherAlgorithm;
import org.springframework.security.crypto.codec.Base64;

@Entity
@Cacheable
@SyncopeUserCheck
public class SyncopeUser
extends AbstractAttributable
implements PersistenceCapable {
    private static final long serialVersionUID = -3905046855521446823L;
    private static SecretKeySpec keySpec;
    @Id
    private Long id;
    @NotNull
    private String password;
    @Transient
    private String clearPassword;
    @OneToMany(cascade={CascadeType.MERGE}, mappedBy="syncopeUser")
    @Valid
    private List<Membership> memberships = new ArrayList<Membership>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="owner")
    @Valid
    private List<UAttr> attributes = new ArrayList<UAttr>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="owner")
    @Valid
    private List<UDerAttr> derivedAttributes = new ArrayList<UDerAttr>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="owner")
    @Valid
    private List<UVirAttr> virtualAttributes = new ArrayList<UVirAttr>();
    private String workflowId;
    @Column(nullable=true)
    private String status;
    @Lob
    private String token;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date tokenExpireTime;
    @Column(nullable=true)
    @Enumerated(value=EnumType.STRING)
    private CipherAlgorithm cipherAlgorithm;
    @ElementCollection
    private List<String> passwordHistory = new ArrayList<String>();
    @Column(nullable=true)
    private Integer failedLogins = 0;
    @Column(unique=true)
    @NotNull
    private String username;
    @Column(nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastLoginDate;
    @NotNull
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationDate;
    @Column(nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date changePwdDate;
    @Basic
    @Min(value=0L)
    @Max(value=1L)
    private Integer suspended = this.getBooleanAsInteger(Boolean.FALSE);
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="resource_name")})
    private Set<ExternalResource> resources = new HashSet<ExternalResource>();
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Lorg$apache$syncope$types$CipherAlgorithm;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$beans$user$SyncopeUser;
    private transient Object pcDetachedState;

    @Override
    public Long getId() {
        return SyncopeUser.pcGetid(this);
    }

    @Override
    protected Set<ExternalResource> resources() {
        return SyncopeUser.pcGetresources(this);
    }

    public boolean addMembership(Membership membership) {
        return SyncopeUser.pcGetmemberships(this).contains(membership) || SyncopeUser.pcGetmemberships(this).add(membership);
    }

    public boolean removeMembership(Membership membership) {
        return SyncopeUser.pcGetmemberships(this).remove(membership);
    }

    public Membership getMembership(Long syncopeRoleId) {
        Membership result = null;
        Iterator<Membership> itor = this.getMemberships().iterator();
        while (result == null && itor.hasNext()) {
            Membership membership = itor.next();
            if (membership.getSyncopeRole() == null || !syncopeRoleId.equals(membership.getSyncopeRole().getId())) continue;
            result = membership;
        }
        return result;
    }

    public List<Membership> getMemberships() {
        return SyncopeUser.pcGetmemberships(this);
    }

    public void setMemberships(List<Membership> memberships) {
        SyncopeUser.pcGetmemberships(this).clear();
        if (memberships != null && !memberships.isEmpty()) {
            SyncopeUser.pcGetmemberships(this).addAll(memberships);
        }
    }

    public List<SyncopeRole> getRoles() {
        ArrayList<SyncopeRole> result = new ArrayList<SyncopeRole>();
        for (Membership membership : SyncopeUser.pcGetmemberships(this)) {
            if (membership.getSyncopeRole() == null) continue;
            result.add(membership.getSyncopeRole());
        }
        return result;
    }

    public Set<Long> getRoleIds() {
        List<SyncopeRole> roles = this.getRoles();
        HashSet<Long> result = new HashSet<Long>(roles.size());
        for (SyncopeRole role : roles) {
            result.add(role.getId());
        }
        return result;
    }

    @Override
    public Set<ExternalResource> getResources() {
        HashSet<ExternalResource> result = new HashSet<ExternalResource>();
        result.addAll(super.getResources());
        for (SyncopeRole role : this.getRoles()) {
            result.addAll(role.getResources());
        }
        return result;
    }

    public String getPassword() {
        return SyncopeUser.pcGetpassword(this);
    }

    public String getClearPassword() {
        return this.clearPassword;
    }

    public void removeClearPassword() {
        this.clearPassword = null;
    }

    public void setPassword(String password, CipherAlgorithm cipherAlgoritm, int historySize) {
        this.clearPassword = password;
        try {
            SyncopeUser.pcSetpassword(this, this.encodePassword(password, cipherAlgoritm));
            SyncopeUser.pcSetcipherAlgorithm(this, cipherAlgoritm);
        }
        catch (Exception e) {
            LOG.error("Could not encode password", (Throwable)e);
            SyncopeUser.pcSetpassword(this, null);
        }
    }

    @Override
    public <T extends AbstractAttr> boolean addAttribute(T attribute) {
        if (!(attribute instanceof UAttr)) {
            throw new ClassCastException("attribute is expected to be typed UAttr: " + attribute.getClass().getName());
        }
        return SyncopeUser.pcGetattributes(this).add((UAttr)attribute);
    }

    @Override
    public <T extends AbstractAttr> boolean removeAttribute(T attribute) {
        if (!(attribute instanceof UAttr)) {
            throw new ClassCastException("attribute is expected to be typed UAttr: " + attribute.getClass().getName());
        }
        return SyncopeUser.pcGetattributes(this).remove((UAttr)attribute);
    }

    @Override
    public List<? extends AbstractAttr> getAttributes() {
        return SyncopeUser.pcGetattributes(this);
    }

    @Override
    public void setAttributes(List<? extends AbstractAttr> attributes) {
        SyncopeUser.pcGetattributes(this).clear();
        if (attributes != null && !attributes.isEmpty()) {
            SyncopeUser.pcGetattributes(this).addAll(attributes);
        }
    }

    @Override
    public <T extends AbstractDerAttr> boolean addDerivedAttribute(T derivedAttribute) {
        if (!(derivedAttribute instanceof UDerAttr)) {
            throw new ClassCastException("attribute is expected to be typed UDerAttr: " + derivedAttribute.getClass().getName());
        }
        return SyncopeUser.pcGetderivedAttributes(this).add((UDerAttr)derivedAttribute);
    }

    @Override
    public <T extends AbstractDerAttr> boolean removeDerivedAttribute(T derivedAttribute) {
        if (!(derivedAttribute instanceof UDerAttr)) {
            throw new ClassCastException("attribute is expected to be typed UDerAttr: " + derivedAttribute.getClass().getName());
        }
        return SyncopeUser.pcGetderivedAttributes(this).remove((UDerAttr)derivedAttribute);
    }

    @Override
    public List<? extends AbstractDerAttr> getDerivedAttributes() {
        return SyncopeUser.pcGetderivedAttributes(this);
    }

    @Override
    public void setDerivedAttributes(List<? extends AbstractDerAttr> derivedAttributes) {
        SyncopeUser.pcGetderivedAttributes(this).clear();
        if (derivedAttributes != null && !derivedAttributes.isEmpty()) {
            SyncopeUser.pcGetderivedAttributes(this).addAll(derivedAttributes);
        }
    }

    @Override
    public <T extends AbstractVirAttr> boolean addVirtualAttribute(T virtualAttribute) {
        if (!(virtualAttribute instanceof UVirAttr)) {
            throw new ClassCastException("attribute is expected to be typed UVirAttr: " + virtualAttribute.getClass().getName());
        }
        return SyncopeUser.pcGetvirtualAttributes(this).add((UVirAttr)virtualAttribute);
    }

    @Override
    public <T extends AbstractVirAttr> boolean removeVirtualAttribute(T virtualAttribute) {
        if (!(virtualAttribute instanceof UVirAttr)) {
            throw new ClassCastException("attribute is expected to be typed UVirAttr: " + virtualAttribute.getClass().getName());
        }
        return SyncopeUser.pcGetvirtualAttributes(this).remove((UVirAttr)virtualAttribute);
    }

    @Override
    public List<? extends AbstractVirAttr> getVirtualAttributes() {
        return SyncopeUser.pcGetvirtualAttributes(this);
    }

    @Override
    public void setVirtualAttributes(List<? extends AbstractVirAttr> virtualAttributes) {
        SyncopeUser.pcGetvirtualAttributes(this).clear();
        if (virtualAttributes != null && !virtualAttributes.isEmpty()) {
            SyncopeUser.pcGetvirtualAttributes(this).addAll(virtualAttributes);
        }
    }

    public String getWorkflowId() {
        return SyncopeUser.pcGetworkflowId(this);
    }

    public void setWorkflowId(String workflowId) {
        SyncopeUser.pcSetworkflowId(this, workflowId);
    }

    public String getStatus() {
        return SyncopeUser.pcGetstatus(this);
    }

    public void setStatus(String status) {
        SyncopeUser.pcSetstatus(this, status);
    }

    public void generateToken(int tokenLength, int tokenExpireTime) {
        SyncopeUser.pcSettoken(this, RandomStringUtils.randomAlphanumeric((int)tokenLength));
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, tokenExpireTime);
        SyncopeUser.pcSettokenExpireTime(this, calendar.getTime());
    }

    public void removeToken() {
        SyncopeUser.pcSettoken(this, null);
        SyncopeUser.pcSettokenExpireTime(this, null);
    }

    public String getToken() {
        return SyncopeUser.pcGettoken(this);
    }

    public Date getTokenExpireTime() {
        return SyncopeUser.pcGettokenExpireTime(this) == null ? null : new Date(SyncopeUser.pcGettokenExpireTime(this).getTime());
    }

    public boolean checkToken(String token) {
        return SyncopeUser.pcGettoken(this) == null || SyncopeUser.pcGettoken(this).equals(token) && !this.hasTokenExpired();
    }

    public boolean hasTokenExpired() {
        return SyncopeUser.pcGettokenExpireTime(this).before(new Date());
    }

    public CipherAlgorithm getCipherAlgoritm() {
        return SyncopeUser.pcGetcipherAlgorithm(this);
    }

    public void setCipherAlgoritm(CipherAlgorithm cipherAlgoritm) {
        SyncopeUser.pcSetcipherAlgorithm(this, cipherAlgoritm);
    }

    public List<String> getPasswordHistory() {
        return SyncopeUser.pcGetpasswordHistory(this);
    }

    public Date getChangePwdDate() {
        return SyncopeUser.pcGetchangePwdDate(this) == null ? null : new Date(SyncopeUser.pcGetchangePwdDate(this).getTime());
    }

    public void setChangePwdDate(Date changePwdDate) {
        SyncopeUser.pcSetchangePwdDate(this, changePwdDate == null ? null : new Date(changePwdDate.getTime()));
    }

    public Date getCreationDate() {
        return SyncopeUser.pcGetcreationDate(this) == null ? null : new Date(SyncopeUser.pcGetcreationDate(this).getTime());
    }

    public void setCreationDate(Date creationDate) {
        SyncopeUser.pcSetcreationDate(this, creationDate == null ? null : new Date(creationDate.getTime()));
    }

    public Integer getFailedLogins() {
        return SyncopeUser.pcGetfailedLogins(this) != null ? SyncopeUser.pcGetfailedLogins(this) : 0;
    }

    public void setFailedLogins(Integer failedLogins) {
        SyncopeUser.pcSetfailedLogins(this, failedLogins);
    }

    public Date getLastLoginDate() {
        return SyncopeUser.pcGetlastLoginDate(this) == null ? null : new Date(SyncopeUser.pcGetlastLoginDate(this).getTime());
    }

    public void setLastLoginDate(Date lastLoginDate) {
        SyncopeUser.pcSetlastLoginDate(this, lastLoginDate == null ? null : new Date(lastLoginDate.getTime()));
    }

    public String getUsername() {
        return SyncopeUser.pcGetusername(this);
    }

    public void setUsername(String username) {
        SyncopeUser.pcSetusername(this, username);
    }

    public void setSuspended(Boolean suspended) {
        SyncopeUser.pcSetsuspended(this, this.getBooleanAsInteger(suspended));
    }

    public Boolean getSuspended() {
        return this.isBooleanAsInteger(SyncopeUser.pcGetsuspended(this));
    }

    private String encodePassword(String password, CipherAlgorithm cipherAlgoritm) throws UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String encodedPassword = null;
        if (password != null) {
            if (cipherAlgoritm == null || cipherAlgoritm == CipherAlgorithm.AES) {
                byte[] cleartext = password.getBytes("UTF8");
                Cipher cipher = Cipher.getInstance(CipherAlgorithm.AES.getAlgorithm());
                cipher.init(1, keySpec);
                byte[] encoded = cipher.doFinal(cleartext);
                encodedPassword = new String(Base64.encode((byte[])encoded));
            } else {
                MessageDigest algorithm = MessageDigest.getInstance(cipherAlgoritm.getAlgorithm());
                algorithm.reset();
                algorithm.update(password.getBytes());
                byte[] messageDigest = algorithm.digest();
                StringBuilder hexString = new StringBuilder();
                for (int i = 0; i < messageDigest.length; ++i) {
                    String hex = Integer.toHexString(0xFF & messageDigest[i]);
                    if (hex.length() == 1) {
                        hexString.append('0');
                    }
                    hexString.append(hex);
                }
                encodedPassword = hexString.toString();
            }
        }
        return encodedPassword;
    }

    public boolean verifyPasswordHistory(String password, int size) {
        boolean res = false;
        if (size > 0) {
            try {
                res = SyncopeUser.pcGetpasswordHistory(this).subList(size >= SyncopeUser.pcGetpasswordHistory(this).size() ? 0 : SyncopeUser.pcGetpasswordHistory(this).size() - size, SyncopeUser.pcGetpasswordHistory(this).size()).contains(SyncopeUser.pcGetcipherAlgorithm(this) != null ? this.encodePassword(password, SyncopeUser.pcGetcipherAlgorithm(this)) : password);
            }
            catch (Exception e) {
                LOG.error("Error evaluating password history", (Throwable)e);
            }
        }
        return res;
    }

    static {
        try {
            keySpec = new SecretKeySpec(ArrayUtils.subarray((byte[])"1abcdefghilmnopqrstuvz2!".getBytes("UTF8"), (int)0, (int)16), "AES");
        }
        catch (Exception e) {
            LOG.error("Error during key specification", (Throwable)e);
        }
        pcFieldNames = new String[]{"attributes", "changePwdDate", "cipherAlgorithm", "creationDate", "derivedAttributes", "failedLogins", "id", "lastLoginDate", "memberships", "password", "passwordHistory", "resources", "status", "suspended", "token", "tokenExpireTime", "username", "virtualAttributes", "workflowId"};
        Class[] classArray = new Class[19];
        Class clazz = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = SyncopeUser.class$("java.util.List"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = SyncopeUser.class$("java.util.Date"));
        classArray[1] = clazz2;
        Class clazz3 = class$Lorg$apache$syncope$types$CipherAlgorithm != null ? class$Lorg$apache$syncope$types$CipherAlgorithm : (class$Lorg$apache$syncope$types$CipherAlgorithm = SyncopeUser.class$("org.apache.syncope.types.CipherAlgorithm"));
        classArray[2] = clazz3;
        classArray[3] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = SyncopeUser.class$("java.util.Date"));
        classArray[4] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = SyncopeUser.class$("java.util.List"));
        Class clazz4 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = SyncopeUser.class$("java.lang.Integer"));
        classArray[5] = clazz4;
        Class clazz5 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = SyncopeUser.class$("java.lang.Long"));
        classArray[6] = clazz5;
        classArray[7] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = SyncopeUser.class$("java.util.Date"));
        classArray[8] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = SyncopeUser.class$("java.util.List"));
        Class clazz6 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SyncopeUser.class$("java.lang.String"));
        classArray[9] = clazz6;
        classArray[10] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = SyncopeUser.class$("java.util.List"));
        Class clazz7 = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = SyncopeUser.class$("java.util.Set"));
        classArray[11] = clazz7;
        classArray[12] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SyncopeUser.class$("java.lang.String"));
        classArray[13] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = SyncopeUser.class$("java.lang.Integer"));
        classArray[14] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SyncopeUser.class$("java.lang.String"));
        classArray[15] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = SyncopeUser.class$("java.util.Date"));
        classArray[16] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SyncopeUser.class$("java.lang.String"));
        classArray[17] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = SyncopeUser.class$("java.util.List"));
        classArray[18] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SyncopeUser.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{5, 26, 26, 26, 5, 26, 26, 26, 5, 26, 5, 10, 26, 26, 26, 26, 26, 5, 26};
        Class clazz8 = class$Lorg$apache$syncope$core$persistence$beans$user$SyncopeUser != null ? class$Lorg$apache$syncope$core$persistence$beans$user$SyncopeUser : (class$Lorg$apache$syncope$core$persistence$beans$user$SyncopeUser = SyncopeUser.class$("org.apache.syncope.core.persistence.beans.user.SyncopeUser"));
        PCRegistry.register((Class)clazz8, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"SyncopeUser", (PersistenceCapable)new SyncopeUser());
    }

    public int pcGetEnhancementContractVersion() {
        return 1241207;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.attributes = null;
        this.changePwdDate = null;
        this.cipherAlgorithm = null;
        this.creationDate = null;
        this.derivedAttributes = null;
        this.failedLogins = null;
        this.id = null;
        this.lastLoginDate = null;
        this.memberships = null;
        this.password = null;
        this.passwordHistory = null;
        this.resources = null;
        this.status = null;
        this.suspended = null;
        this.token = null;
        this.tokenExpireTime = null;
        this.username = null;
        this.virtualAttributes = null;
        this.workflowId = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        SyncopeUser syncopeUser = new SyncopeUser();
        if (bl) {
            syncopeUser.pcClearFields();
        }
        syncopeUser.pcStateManager = stateManager;
        syncopeUser.pcCopyKeyFieldsFromObjectId(object);
        return syncopeUser;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        SyncopeUser syncopeUser = new SyncopeUser();
        if (bl) {
            syncopeUser.pcClearFields();
        }
        syncopeUser.pcStateManager = stateManager;
        return syncopeUser;
    }

    protected static int pcGetManagedFieldCount() {
        return 19;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.attributes = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.changePwdDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.cipherAlgorithm = (CipherAlgorithm)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.creationDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.derivedAttributes = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.failedLogins = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.lastLoginDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.memberships = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.password = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.passwordHistory = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.resources = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.status = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.suspended = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.token = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.tokenExpireTime = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.username = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.virtualAttributes = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.workflowId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.attributes);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.changePwdDate);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.cipherAlgorithm);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.creationDate);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.derivedAttributes);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.failedLogins);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.id);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastLoginDate);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.memberships);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.password);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.passwordHistory);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.resources);
                return;
            }
            case 12: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.status);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.suspended);
                return;
            }
            case 14: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.token);
                return;
            }
            case 15: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.tokenExpireTime);
                return;
            }
            case 16: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.username);
                return;
            }
            case 17: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.virtualAttributes);
                return;
            }
            case 18: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.workflowId);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(SyncopeUser syncopeUser, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.attributes = syncopeUser.attributes;
                return;
            }
            case 1: {
                this.changePwdDate = syncopeUser.changePwdDate;
                return;
            }
            case 2: {
                this.cipherAlgorithm = syncopeUser.cipherAlgorithm;
                return;
            }
            case 3: {
                this.creationDate = syncopeUser.creationDate;
                return;
            }
            case 4: {
                this.derivedAttributes = syncopeUser.derivedAttributes;
                return;
            }
            case 5: {
                this.failedLogins = syncopeUser.failedLogins;
                return;
            }
            case 6: {
                this.id = syncopeUser.id;
                return;
            }
            case 7: {
                this.lastLoginDate = syncopeUser.lastLoginDate;
                return;
            }
            case 8: {
                this.memberships = syncopeUser.memberships;
                return;
            }
            case 9: {
                this.password = syncopeUser.password;
                return;
            }
            case 10: {
                this.passwordHistory = syncopeUser.passwordHistory;
                return;
            }
            case 11: {
                this.resources = syncopeUser.resources;
                return;
            }
            case 12: {
                this.status = syncopeUser.status;
                return;
            }
            case 13: {
                this.suspended = syncopeUser.suspended;
                return;
            }
            case 14: {
                this.token = syncopeUser.token;
                return;
            }
            case 15: {
                this.tokenExpireTime = syncopeUser.tokenExpireTime;
                return;
            }
            case 16: {
                this.username = syncopeUser.username;
                return;
            }
            case 17: {
                this.virtualAttributes = syncopeUser.virtualAttributes;
                return;
            }
            case 18: {
                this.workflowId = syncopeUser.workflowId;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        SyncopeUser syncopeUser = (SyncopeUser)object;
        if (syncopeUser.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(syncopeUser, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(6 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.id = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$syncope$core$persistence$beans$user$SyncopeUser != null ? class$Lorg$apache$syncope$core$persistence$beans$user$SyncopeUser : (class$Lorg$apache$syncope$core$persistence$beans$user$SyncopeUser = SyncopeUser.class$("org.apache.syncope.core.persistence.beans.user.SyncopeUser"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$beans$user$SyncopeUser != null ? class$Lorg$apache$syncope$core$persistence$beans$user$SyncopeUser : (class$Lorg$apache$syncope$core$persistence$beans$user$SyncopeUser = SyncopeUser.class$("org.apache.syncope.core.persistence.beans.user.SyncopeUser"));
        return new LongId(clazz, this.id);
    }

    private static final List pcGetattributes(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.attributes;
        }
        int n = pcInheritedFieldCount + 0;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.attributes;
    }

    private static final void pcSetattributes(SyncopeUser syncopeUser, List list) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.attributes = list;
            return;
        }
        syncopeUser.pcStateManager.settingObjectField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 0, syncopeUser.attributes, (Object)list, 0);
    }

    private static final Date pcGetchangePwdDate(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.changePwdDate;
        }
        int n = pcInheritedFieldCount + 1;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.changePwdDate;
    }

    private static final void pcSetchangePwdDate(SyncopeUser syncopeUser, Date date) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.changePwdDate = date;
            return;
        }
        syncopeUser.pcStateManager.settingObjectField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 1, (Object)syncopeUser.changePwdDate, (Object)date, 0);
    }

    private static final CipherAlgorithm pcGetcipherAlgorithm(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.cipherAlgorithm;
        }
        int n = pcInheritedFieldCount + 2;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.cipherAlgorithm;
    }

    private static final void pcSetcipherAlgorithm(SyncopeUser syncopeUser, CipherAlgorithm cipherAlgorithm) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.cipherAlgorithm = cipherAlgorithm;
            return;
        }
        syncopeUser.pcStateManager.settingObjectField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 2, (Object)syncopeUser.cipherAlgorithm, (Object)cipherAlgorithm, 0);
    }

    private static final Date pcGetcreationDate(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.creationDate;
        }
        int n = pcInheritedFieldCount + 3;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.creationDate;
    }

    private static final void pcSetcreationDate(SyncopeUser syncopeUser, Date date) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.creationDate = date;
            return;
        }
        syncopeUser.pcStateManager.settingObjectField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 3, (Object)syncopeUser.creationDate, (Object)date, 0);
    }

    private static final List pcGetderivedAttributes(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.derivedAttributes;
        }
        int n = pcInheritedFieldCount + 4;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.derivedAttributes;
    }

    private static final void pcSetderivedAttributes(SyncopeUser syncopeUser, List list) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.derivedAttributes = list;
            return;
        }
        syncopeUser.pcStateManager.settingObjectField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 4, syncopeUser.derivedAttributes, (Object)list, 0);
    }

    private static final Integer pcGetfailedLogins(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.failedLogins;
        }
        int n = pcInheritedFieldCount + 5;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.failedLogins;
    }

    private static final void pcSetfailedLogins(SyncopeUser syncopeUser, Integer n) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.failedLogins = n;
            return;
        }
        syncopeUser.pcStateManager.settingObjectField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 5, (Object)syncopeUser.failedLogins, (Object)n, 0);
    }

    private static final Long pcGetid(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.id;
        }
        int n = pcInheritedFieldCount + 6;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.id;
    }

    private static final void pcSetid(SyncopeUser syncopeUser, Long l) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.id = l;
            return;
        }
        syncopeUser.pcStateManager.settingObjectField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 6, (Object)syncopeUser.id, (Object)l, 0);
    }

    private static final Date pcGetlastLoginDate(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.lastLoginDate;
        }
        int n = pcInheritedFieldCount + 7;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.lastLoginDate;
    }

    private static final void pcSetlastLoginDate(SyncopeUser syncopeUser, Date date) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.lastLoginDate = date;
            return;
        }
        syncopeUser.pcStateManager.settingObjectField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 7, (Object)syncopeUser.lastLoginDate, (Object)date, 0);
    }

    private static final List pcGetmemberships(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.memberships;
        }
        int n = pcInheritedFieldCount + 8;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.memberships;
    }

    private static final void pcSetmemberships(SyncopeUser syncopeUser, List list) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.memberships = list;
            return;
        }
        syncopeUser.pcStateManager.settingObjectField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 8, syncopeUser.memberships, (Object)list, 0);
    }

    private static final String pcGetpassword(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.password;
        }
        int n = pcInheritedFieldCount + 9;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.password;
    }

    private static final void pcSetpassword(SyncopeUser syncopeUser, String string) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.password = string;
            return;
        }
        syncopeUser.pcStateManager.settingStringField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 9, syncopeUser.password, string, 0);
    }

    private static final List pcGetpasswordHistory(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.passwordHistory;
        }
        int n = pcInheritedFieldCount + 10;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.passwordHistory;
    }

    private static final void pcSetpasswordHistory(SyncopeUser syncopeUser, List list) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.passwordHistory = list;
            return;
        }
        syncopeUser.pcStateManager.settingObjectField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 10, syncopeUser.passwordHistory, (Object)list, 0);
    }

    private static final Set pcGetresources(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.resources;
        }
        int n = pcInheritedFieldCount + 11;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.resources;
    }

    private static final void pcSetresources(SyncopeUser syncopeUser, Set set) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.resources = set;
            return;
        }
        syncopeUser.pcStateManager.settingObjectField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 11, syncopeUser.resources, (Object)set, 0);
    }

    private static final String pcGetstatus(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.status;
        }
        int n = pcInheritedFieldCount + 12;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.status;
    }

    private static final void pcSetstatus(SyncopeUser syncopeUser, String string) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.status = string;
            return;
        }
        syncopeUser.pcStateManager.settingStringField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 12, syncopeUser.status, string, 0);
    }

    private static final Integer pcGetsuspended(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.suspended;
        }
        int n = pcInheritedFieldCount + 13;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.suspended;
    }

    private static final void pcSetsuspended(SyncopeUser syncopeUser, Integer n) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.suspended = n;
            return;
        }
        syncopeUser.pcStateManager.settingObjectField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 13, (Object)syncopeUser.suspended, (Object)n, 0);
    }

    private static final String pcGettoken(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.token;
        }
        int n = pcInheritedFieldCount + 14;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.token;
    }

    private static final void pcSettoken(SyncopeUser syncopeUser, String string) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.token = string;
            return;
        }
        syncopeUser.pcStateManager.settingStringField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 14, syncopeUser.token, string, 0);
    }

    private static final Date pcGettokenExpireTime(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.tokenExpireTime;
        }
        int n = pcInheritedFieldCount + 15;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.tokenExpireTime;
    }

    private static final void pcSettokenExpireTime(SyncopeUser syncopeUser, Date date) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.tokenExpireTime = date;
            return;
        }
        syncopeUser.pcStateManager.settingObjectField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 15, (Object)syncopeUser.tokenExpireTime, (Object)date, 0);
    }

    private static final String pcGetusername(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.username;
        }
        int n = pcInheritedFieldCount + 16;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.username;
    }

    private static final void pcSetusername(SyncopeUser syncopeUser, String string) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.username = string;
            return;
        }
        syncopeUser.pcStateManager.settingStringField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 16, syncopeUser.username, string, 0);
    }

    private static final List pcGetvirtualAttributes(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.virtualAttributes;
        }
        int n = pcInheritedFieldCount + 17;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.virtualAttributes;
    }

    private static final void pcSetvirtualAttributes(SyncopeUser syncopeUser, List list) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.virtualAttributes = list;
            return;
        }
        syncopeUser.pcStateManager.settingObjectField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 17, syncopeUser.virtualAttributes, (Object)list, 0);
    }

    private static final String pcGetworkflowId(SyncopeUser syncopeUser) {
        if (syncopeUser.pcStateManager == null) {
            return syncopeUser.workflowId;
        }
        int n = pcInheritedFieldCount + 18;
        syncopeUser.pcStateManager.accessingField(n);
        return syncopeUser.workflowId;
    }

    private static final void pcSetworkflowId(SyncopeUser syncopeUser, String string) {
        if (syncopeUser.pcStateManager == null) {
            syncopeUser.workflowId = string;
            return;
        }
        syncopeUser.pcStateManager.settingStringField((PersistenceCapable)syncopeUser, pcInheritedFieldCount + 18, syncopeUser.workflowId, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.id != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

