/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.beans.role;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.syncope.core.persistence.beans.AbstractAttr;
import org.apache.syncope.core.persistence.beans.AbstractAttributable;
import org.apache.syncope.core.persistence.beans.AbstractDerAttr;
import org.apache.syncope.core.persistence.beans.AbstractDerSchema;
import org.apache.syncope.core.persistence.beans.AbstractSchema;
import org.apache.syncope.core.persistence.beans.AbstractVirAttr;
import org.apache.syncope.core.persistence.beans.AbstractVirSchema;
import org.apache.syncope.core.persistence.beans.AccountPolicy;
import org.apache.syncope.core.persistence.beans.Entitlement;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.PasswordPolicy;
import org.apache.syncope.core.persistence.beans.role.RAttr;
import org.apache.syncope.core.persistence.beans.role.RDerAttr;
import org.apache.syncope.core.persistence.beans.role.RDerSchema;
import org.apache.syncope.core.persistence.beans.role.RSchema;
import org.apache.syncope.core.persistence.beans.role.RVirAttr;
import org.apache.syncope.core.persistence.beans.role.RVirSchema;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"name", "parent_id"})})
@Cacheable
public class SyncopeRole
extends AbstractAttributable
implements PersistenceCapable {
    private static final long serialVersionUID = -5281258853142421875L;
    @Id
    private Long id;
    @NotNull
    private String name;
    @ManyToOne(optional=true)
    private SyncopeRole parent;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="role_id")}, inverseJoinColumns={@JoinColumn(name="entitlement_name")})
    private Set<Entitlement> entitlements = new HashSet<Entitlement>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="owner")
    @Valid
    private List<RAttr> attributes = new ArrayList<RAttr>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="owner")
    @Valid
    private List<RDerAttr> derivedAttributes = new ArrayList<RDerAttr>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="owner")
    @Valid
    private List<RVirAttr> virtualAttributes = new ArrayList<RVirAttr>();
    @Basic(optional=true)
    @Min(value=0L)
    @Max(value=1L)
    private Integer inheritAttributes = this.getBooleanAsInteger(false);
    @Basic(optional=true)
    @Min(value=0L)
    @Max(value=1L)
    private Integer inheritDerivedAttributes = this.getBooleanAsInteger(false);
    @Basic(optional=true)
    @Min(value=0L)
    @Max(value=1L)
    private Integer inheritVirtualAttributes = this.getBooleanAsInteger(false);
    @Basic(optional=true)
    @Min(value=0L)
    @Max(value=1L)
    private Integer inheritPasswordPolicy = this.getBooleanAsInteger(false);
    @Basic(optional=true)
    @Min(value=0L)
    @Max(value=1L)
    private Integer inheritAccountPolicy = this.getBooleanAsInteger(false);
    @ManyToOne(fetch=FetchType.EAGER, optional=true)
    private PasswordPolicy passwordPolicy;
    @ManyToOne(fetch=FetchType.EAGER, optional=true)
    private AccountPolicy accountPolicy;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="role_id")}, inverseJoinColumns={@JoinColumn(name="resource_name")})
    @Valid
    private Set<ExternalResource> resources = new HashSet<ExternalResource>();
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$beans$AccountPolicy;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$beans$role$SyncopeRole;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$beans$PasswordPolicy;
    private transient Object pcDetachedState;

    @Override
    public Long getId() {
        return SyncopeRole.pcGetid(this);
    }

    @Override
    protected Set<ExternalResource> resources() {
        return SyncopeRole.pcGetresources(this);
    }

    public String getName() {
        return SyncopeRole.pcGetname(this);
    }

    public void setName(String name) {
        SyncopeRole.pcSetname(this, name);
    }

    public SyncopeRole getParent() {
        return SyncopeRole.pcGetparent(this);
    }

    public void setParent(SyncopeRole parent) {
        SyncopeRole.pcSetparent(this, parent);
    }

    public boolean addEntitlement(Entitlement entitlement) {
        return SyncopeRole.pcGetentitlements(this).add(entitlement);
    }

    public boolean removeEntitlement(Entitlement entitlement) {
        return SyncopeRole.pcGetentitlements(this).remove(entitlement);
    }

    public Set<Entitlement> getEntitlements() {
        return SyncopeRole.pcGetentitlements(this);
    }

    public void setEntitlements(List<Entitlement> entitlements) {
        SyncopeRole.pcGetentitlements(this).clear();
        if (entitlements != null && !entitlements.isEmpty()) {
            SyncopeRole.pcGetentitlements(this).addAll(entitlements);
        }
    }

    @Override
    public <T extends AbstractAttr> boolean addAttribute(T attribute) {
        if (!(attribute instanceof RAttr)) {
            throw new ClassCastException("attribute is expected to be typed RAttr: " + attribute.getClass().getName());
        }
        return SyncopeRole.pcGetattributes(this).add((RAttr)attribute);
    }

    @Override
    public <T extends AbstractAttr> boolean removeAttribute(T attribute) {
        if (!(attribute instanceof RAttr)) {
            throw new ClassCastException("attribute is expected to be typed RAttr: " + attribute.getClass().getName());
        }
        return SyncopeRole.pcGetattributes(this).remove((RAttr)attribute);
    }

    @Override
    public List<? extends AbstractAttr> getAttributes() {
        return SyncopeRole.pcGetattributes(this);
    }

    @Override
    public void setAttributes(List<? extends AbstractAttr> attributes) {
        SyncopeRole.pcSetattributes(this, attributes);
    }

    @Override
    public <T extends AbstractDerAttr> boolean addDerivedAttribute(T derivedAttribute) {
        if (!(derivedAttribute instanceof RDerAttr)) {
            throw new ClassCastException("attribute is expected to be typed RDerAttr: " + derivedAttribute.getClass().getName());
        }
        return SyncopeRole.pcGetderivedAttributes(this).add((RDerAttr)derivedAttribute);
    }

    @Override
    public <T extends AbstractDerAttr> boolean removeDerivedAttribute(T derivedAttribute) {
        if (!(derivedAttribute instanceof RDerAttr)) {
            throw new ClassCastException("attribute is expected to be typed RDerAttr: " + derivedAttribute.getClass().getName());
        }
        return SyncopeRole.pcGetderivedAttributes(this).remove((RDerAttr)derivedAttribute);
    }

    @Override
    public List<? extends AbstractDerAttr> getDerivedAttributes() {
        return SyncopeRole.pcGetderivedAttributes(this);
    }

    @Override
    public void setDerivedAttributes(List<? extends AbstractDerAttr> derivedAttributes) {
        SyncopeRole.pcSetderivedAttributes(this, derivedAttributes);
    }

    @Override
    public <T extends AbstractVirAttr> boolean addVirtualAttribute(T virtualAttribute) {
        if (!(virtualAttribute instanceof RVirAttr)) {
            throw new ClassCastException("attribute is expected to be typed RVirAttr: " + virtualAttribute.getClass().getName());
        }
        return SyncopeRole.pcGetvirtualAttributes(this).add((RVirAttr)virtualAttribute);
    }

    @Override
    public <T extends AbstractVirAttr> boolean removeVirtualAttribute(T virtualAttribute) {
        if (!(virtualAttribute instanceof RVirAttr)) {
            throw new ClassCastException("attribute is expected to be typed RVirAttr: " + virtualAttribute.getClass().getName());
        }
        return SyncopeRole.pcGetvirtualAttributes(this).remove((RVirAttr)virtualAttribute);
    }

    @Override
    public List<? extends AbstractVirAttr> getVirtualAttributes() {
        return SyncopeRole.pcGetvirtualAttributes(this);
    }

    @Override
    public void setVirtualAttributes(List<? extends AbstractVirAttr> virtualAttributes) {
        SyncopeRole.pcSetvirtualAttributes(this, virtualAttributes);
    }

    public boolean isInheritAttributes() {
        return this.isBooleanAsInteger(SyncopeRole.pcGetinheritAttributes(this));
    }

    public void setInheritAttributes(boolean inheritAttributes) {
        SyncopeRole.pcSetinheritAttributes(this, this.getBooleanAsInteger(inheritAttributes));
    }

    public List<RAttr> findInheritedAttributes() {
        HashMap<RSchema, RAttr> result = new HashMap<RSchema, RAttr>();
        if (this.isInheritAttributes() && this.getParent() != null) {
            Map<AbstractSchema, AbstractAttr> attrMap = this.getAttrMap();
            for (RAttr rAttr : this.getParent().getAttributes()) {
                if (attrMap.containsKey(rAttr.getSchema())) continue;
                result.put((RSchema)rAttr.getSchema(), rAttr);
            }
            for (RAttr rAttr : this.getParent().findInheritedAttributes()) {
                if (attrMap.containsKey(rAttr.getSchema()) || result.containsKey((RSchema)rAttr.getSchema())) continue;
                result.put((RSchema)rAttr.getSchema(), rAttr);
            }
        }
        return new ArrayList<RAttr>(result.values());
    }

    public boolean isInheritDerivedAttributes() {
        return this.isBooleanAsInteger(SyncopeRole.pcGetinheritDerivedAttributes(this));
    }

    public void setInheritDerivedAttributes(boolean inheritDerivedAttributes) {
        SyncopeRole.pcSetinheritDerivedAttributes(this, this.getBooleanAsInteger(inheritDerivedAttributes));
    }

    public List<RDerAttr> findInheritedDerivedAttributes() {
        HashMap<RDerSchema, RDerAttr> result = new HashMap<RDerSchema, RDerAttr>();
        if (this.isInheritDerivedAttributes() && this.getParent() != null) {
            Map<AbstractDerSchema, AbstractDerAttr> attrMap = this.getDerAttrMap();
            for (RDerAttr rDerAttr : this.getParent().getDerivedAttributes()) {
                if (attrMap.containsKey(rDerAttr.getDerivedSchema())) continue;
                result.put((RDerSchema)rDerAttr.getDerivedSchema(), rDerAttr);
            }
            for (RDerAttr rDerAttr : this.getParent().findInheritedDerivedAttributes()) {
                if (attrMap.containsKey(rDerAttr.getDerivedSchema()) || result.containsKey((RDerSchema)rDerAttr.getDerivedSchema())) continue;
                result.put((RDerSchema)rDerAttr.getDerivedSchema(), rDerAttr);
            }
        }
        return new ArrayList<RDerAttr>(result.values());
    }

    public boolean isInheritVirtualAttributes() {
        return this.isBooleanAsInteger(SyncopeRole.pcGetinheritVirtualAttributes(this));
    }

    public void setInheritVirtualAttributes(boolean inheritVirtualAttributes) {
        SyncopeRole.pcSetinheritVirtualAttributes(this, this.getBooleanAsInteger(inheritVirtualAttributes));
    }

    public List<RVirAttr> findInheritedVirtualAttributes() {
        HashMap<RVirSchema, RVirAttr> result = new HashMap<RVirSchema, RVirAttr>();
        if (this.isInheritVirtualAttributes() && this.getParent() != null) {
            Map<AbstractVirSchema, AbstractVirAttr> attrMap = this.getVirAttrMap();
            for (RVirAttr rVirAttr : this.getParent().getVirtualAttributes()) {
                if (attrMap.containsKey(rVirAttr.getVirtualSchema())) continue;
                result.put((RVirSchema)rVirAttr.getVirtualSchema(), rVirAttr);
            }
            for (RVirAttr rVirAttr : this.getParent().findInheritedVirtualAttributes()) {
                if (attrMap.containsKey(rVirAttr.getVirtualSchema()) || result.containsKey((RVirSchema)rVirAttr.getVirtualSchema())) continue;
                result.put((RVirSchema)rVirAttr.getVirtualSchema(), rVirAttr);
            }
        }
        return new ArrayList<RVirAttr>(result.values());
    }

    public PasswordPolicy getPasswordPolicy() {
        return this.isInheritPasswordPolicy() && this.getParent() != null ? this.getParent().getPasswordPolicy() : SyncopeRole.pcGetpasswordPolicy(this);
    }

    public void setPasswordPolicy(PasswordPolicy passwordPolicy) {
        SyncopeRole.pcSetpasswordPolicy(this, passwordPolicy);
    }

    public boolean isInheritPasswordPolicy() {
        return this.isBooleanAsInteger(SyncopeRole.pcGetinheritPasswordPolicy(this));
    }

    public void setInheritPasswordPolicy(boolean inheritPasswordPolicy) {
        SyncopeRole.pcSetinheritPasswordPolicy(this, this.getBooleanAsInteger(inheritPasswordPolicy));
    }

    public AccountPolicy getAccountPolicy() {
        return this.isInheritAccountPolicy() && this.getParent() != null ? this.getParent().getAccountPolicy() : SyncopeRole.pcGetaccountPolicy(this);
    }

    public void setAccountPolicy(AccountPolicy accountPolicy) {
        SyncopeRole.pcSetaccountPolicy(this, accountPolicy);
    }

    public boolean isInheritAccountPolicy() {
        return this.isBooleanAsInteger(SyncopeRole.pcGetinheritAccountPolicy(this));
    }

    public void setInheritAccountPolicy(boolean inheritAccountPolicy) {
        SyncopeRole.pcSetinheritAccountPolicy(this, this.getBooleanAsInteger(inheritAccountPolicy));
    }

    public int pcGetEnhancementContractVersion() {
        return 1241207;
    }

    static {
        pcFieldNames = new String[]{"accountPolicy", "attributes", "derivedAttributes", "entitlements", "id", "inheritAccountPolicy", "inheritAttributes", "inheritDerivedAttributes", "inheritPasswordPolicy", "inheritVirtualAttributes", "name", "parent", "passwordPolicy", "resources", "virtualAttributes"};
        Class[] classArray = new Class[15];
        Class clazz = class$Lorg$apache$syncope$core$persistence$beans$AccountPolicy != null ? class$Lorg$apache$syncope$core$persistence$beans$AccountPolicy : (class$Lorg$apache$syncope$core$persistence$beans$AccountPolicy = SyncopeRole.class$("org.apache.syncope.core.persistence.beans.AccountPolicy"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = SyncopeRole.class$("java.util.List"));
        classArray[1] = clazz2;
        classArray[2] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = SyncopeRole.class$("java.util.List"));
        Class clazz3 = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = SyncopeRole.class$("java.util.Set"));
        classArray[3] = clazz3;
        Class clazz4 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = SyncopeRole.class$("java.lang.Long"));
        classArray[4] = clazz4;
        Class clazz5 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = SyncopeRole.class$("java.lang.Integer"));
        classArray[5] = clazz5;
        classArray[6] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = SyncopeRole.class$("java.lang.Integer"));
        classArray[7] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = SyncopeRole.class$("java.lang.Integer"));
        classArray[8] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = SyncopeRole.class$("java.lang.Integer"));
        classArray[9] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = SyncopeRole.class$("java.lang.Integer"));
        Class clazz6 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SyncopeRole.class$("java.lang.String"));
        classArray[10] = clazz6;
        Class clazz7 = class$Lorg$apache$syncope$core$persistence$beans$role$SyncopeRole != null ? class$Lorg$apache$syncope$core$persistence$beans$role$SyncopeRole : (class$Lorg$apache$syncope$core$persistence$beans$role$SyncopeRole = SyncopeRole.class$("org.apache.syncope.core.persistence.beans.role.SyncopeRole"));
        classArray[11] = clazz7;
        Class clazz8 = class$Lorg$apache$syncope$core$persistence$beans$PasswordPolicy != null ? class$Lorg$apache$syncope$core$persistence$beans$PasswordPolicy : (class$Lorg$apache$syncope$core$persistence$beans$PasswordPolicy = SyncopeRole.class$("org.apache.syncope.core.persistence.beans.PasswordPolicy"));
        classArray[12] = clazz8;
        classArray[13] = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = SyncopeRole.class$("java.util.Set"));
        classArray[14] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = SyncopeRole.class$("java.util.List"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 5, 5, 10, 26, 26, 26, 26, 26, 26, 26, 26, 26, 10, 5};
        PCRegistry.register((Class)(class$Lorg$apache$syncope$core$persistence$beans$role$SyncopeRole != null ? class$Lorg$apache$syncope$core$persistence$beans$role$SyncopeRole : (class$Lorg$apache$syncope$core$persistence$beans$role$SyncopeRole = SyncopeRole.class$("org.apache.syncope.core.persistence.beans.role.SyncopeRole"))), (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"SyncopeRole", (PersistenceCapable)new SyncopeRole());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.accountPolicy = null;
        this.attributes = null;
        this.derivedAttributes = null;
        this.entitlements = null;
        this.id = null;
        this.inheritAccountPolicy = null;
        this.inheritAttributes = null;
        this.inheritDerivedAttributes = null;
        this.inheritPasswordPolicy = null;
        this.inheritVirtualAttributes = null;
        this.name = null;
        this.parent = null;
        this.passwordPolicy = null;
        this.resources = null;
        this.virtualAttributes = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        SyncopeRole syncopeRole = new SyncopeRole();
        if (bl) {
            syncopeRole.pcClearFields();
        }
        syncopeRole.pcStateManager = stateManager;
        syncopeRole.pcCopyKeyFieldsFromObjectId(object);
        return syncopeRole;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        SyncopeRole syncopeRole = new SyncopeRole();
        if (bl) {
            syncopeRole.pcClearFields();
        }
        syncopeRole.pcStateManager = stateManager;
        return syncopeRole;
    }

    protected static int pcGetManagedFieldCount() {
        return 15;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.accountPolicy = (AccountPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.attributes = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.derivedAttributes = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.entitlements = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.inheritAccountPolicy = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.inheritAttributes = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.inheritDerivedAttributes = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.inheritPasswordPolicy = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.inheritVirtualAttributes = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.parent = (SyncopeRole)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.passwordPolicy = (PasswordPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.resources = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.virtualAttributes = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.accountPolicy);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.attributes);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.derivedAttributes);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.entitlements);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.id);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.inheritAccountPolicy);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.inheritAttributes);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.inheritDerivedAttributes);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.inheritPasswordPolicy);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.inheritVirtualAttributes);
                return;
            }
            case 10: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.parent);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.passwordPolicy);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.resources);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.virtualAttributes);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(SyncopeRole syncopeRole, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.accountPolicy = syncopeRole.accountPolicy;
                return;
            }
            case 1: {
                this.attributes = syncopeRole.attributes;
                return;
            }
            case 2: {
                this.derivedAttributes = syncopeRole.derivedAttributes;
                return;
            }
            case 3: {
                this.entitlements = syncopeRole.entitlements;
                return;
            }
            case 4: {
                this.id = syncopeRole.id;
                return;
            }
            case 5: {
                this.inheritAccountPolicy = syncopeRole.inheritAccountPolicy;
                return;
            }
            case 6: {
                this.inheritAttributes = syncopeRole.inheritAttributes;
                return;
            }
            case 7: {
                this.inheritDerivedAttributes = syncopeRole.inheritDerivedAttributes;
                return;
            }
            case 8: {
                this.inheritPasswordPolicy = syncopeRole.inheritPasswordPolicy;
                return;
            }
            case 9: {
                this.inheritVirtualAttributes = syncopeRole.inheritVirtualAttributes;
                return;
            }
            case 10: {
                this.name = syncopeRole.name;
                return;
            }
            case 11: {
                this.parent = syncopeRole.parent;
                return;
            }
            case 12: {
                this.passwordPolicy = syncopeRole.passwordPolicy;
                return;
            }
            case 13: {
                this.resources = syncopeRole.resources;
                return;
            }
            case 14: {
                this.virtualAttributes = syncopeRole.virtualAttributes;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        SyncopeRole syncopeRole = (SyncopeRole)object;
        if (syncopeRole.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(syncopeRole, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(4 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.id = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$syncope$core$persistence$beans$role$SyncopeRole != null ? class$Lorg$apache$syncope$core$persistence$beans$role$SyncopeRole : (class$Lorg$apache$syncope$core$persistence$beans$role$SyncopeRole = SyncopeRole.class$("org.apache.syncope.core.persistence.beans.role.SyncopeRole"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$beans$role$SyncopeRole != null ? class$Lorg$apache$syncope$core$persistence$beans$role$SyncopeRole : (class$Lorg$apache$syncope$core$persistence$beans$role$SyncopeRole = SyncopeRole.class$("org.apache.syncope.core.persistence.beans.role.SyncopeRole"));
        return new LongId(clazz, this.id);
    }

    private static final AccountPolicy pcGetaccountPolicy(SyncopeRole syncopeRole) {
        if (syncopeRole.pcStateManager == null) {
            return syncopeRole.accountPolicy;
        }
        int n = pcInheritedFieldCount + 0;
        syncopeRole.pcStateManager.accessingField(n);
        return syncopeRole.accountPolicy;
    }

    private static final void pcSetaccountPolicy(SyncopeRole syncopeRole, AccountPolicy accountPolicy) {
        if (syncopeRole.pcStateManager == null) {
            syncopeRole.accountPolicy = accountPolicy;
            return;
        }
        syncopeRole.pcStateManager.settingObjectField((PersistenceCapable)syncopeRole, pcInheritedFieldCount + 0, (Object)syncopeRole.accountPolicy, (Object)accountPolicy, 0);
    }

    private static final List pcGetattributes(SyncopeRole syncopeRole) {
        if (syncopeRole.pcStateManager == null) {
            return syncopeRole.attributes;
        }
        int n = pcInheritedFieldCount + 1;
        syncopeRole.pcStateManager.accessingField(n);
        return syncopeRole.attributes;
    }

    private static final void pcSetattributes(SyncopeRole syncopeRole, List list) {
        if (syncopeRole.pcStateManager == null) {
            syncopeRole.attributes = list;
            return;
        }
        syncopeRole.pcStateManager.settingObjectField((PersistenceCapable)syncopeRole, pcInheritedFieldCount + 1, syncopeRole.attributes, (Object)list, 0);
    }

    private static final List pcGetderivedAttributes(SyncopeRole syncopeRole) {
        if (syncopeRole.pcStateManager == null) {
            return syncopeRole.derivedAttributes;
        }
        int n = pcInheritedFieldCount + 2;
        syncopeRole.pcStateManager.accessingField(n);
        return syncopeRole.derivedAttributes;
    }

    private static final void pcSetderivedAttributes(SyncopeRole syncopeRole, List list) {
        if (syncopeRole.pcStateManager == null) {
            syncopeRole.derivedAttributes = list;
            return;
        }
        syncopeRole.pcStateManager.settingObjectField((PersistenceCapable)syncopeRole, pcInheritedFieldCount + 2, syncopeRole.derivedAttributes, (Object)list, 0);
    }

    private static final Set pcGetentitlements(SyncopeRole syncopeRole) {
        if (syncopeRole.pcStateManager == null) {
            return syncopeRole.entitlements;
        }
        int n = pcInheritedFieldCount + 3;
        syncopeRole.pcStateManager.accessingField(n);
        return syncopeRole.entitlements;
    }

    private static final void pcSetentitlements(SyncopeRole syncopeRole, Set set) {
        if (syncopeRole.pcStateManager == null) {
            syncopeRole.entitlements = set;
            return;
        }
        syncopeRole.pcStateManager.settingObjectField((PersistenceCapable)syncopeRole, pcInheritedFieldCount + 3, syncopeRole.entitlements, (Object)set, 0);
    }

    private static final Long pcGetid(SyncopeRole syncopeRole) {
        if (syncopeRole.pcStateManager == null) {
            return syncopeRole.id;
        }
        int n = pcInheritedFieldCount + 4;
        syncopeRole.pcStateManager.accessingField(n);
        return syncopeRole.id;
    }

    private static final void pcSetid(SyncopeRole syncopeRole, Long l) {
        if (syncopeRole.pcStateManager == null) {
            syncopeRole.id = l;
            return;
        }
        syncopeRole.pcStateManager.settingObjectField((PersistenceCapable)syncopeRole, pcInheritedFieldCount + 4, (Object)syncopeRole.id, (Object)l, 0);
    }

    private static final Integer pcGetinheritAccountPolicy(SyncopeRole syncopeRole) {
        if (syncopeRole.pcStateManager == null) {
            return syncopeRole.inheritAccountPolicy;
        }
        int n = pcInheritedFieldCount + 5;
        syncopeRole.pcStateManager.accessingField(n);
        return syncopeRole.inheritAccountPolicy;
    }

    private static final void pcSetinheritAccountPolicy(SyncopeRole syncopeRole, Integer n) {
        if (syncopeRole.pcStateManager == null) {
            syncopeRole.inheritAccountPolicy = n;
            return;
        }
        syncopeRole.pcStateManager.settingObjectField((PersistenceCapable)syncopeRole, pcInheritedFieldCount + 5, (Object)syncopeRole.inheritAccountPolicy, (Object)n, 0);
    }

    private static final Integer pcGetinheritAttributes(SyncopeRole syncopeRole) {
        if (syncopeRole.pcStateManager == null) {
            return syncopeRole.inheritAttributes;
        }
        int n = pcInheritedFieldCount + 6;
        syncopeRole.pcStateManager.accessingField(n);
        return syncopeRole.inheritAttributes;
    }

    private static final void pcSetinheritAttributes(SyncopeRole syncopeRole, Integer n) {
        if (syncopeRole.pcStateManager == null) {
            syncopeRole.inheritAttributes = n;
            return;
        }
        syncopeRole.pcStateManager.settingObjectField((PersistenceCapable)syncopeRole, pcInheritedFieldCount + 6, (Object)syncopeRole.inheritAttributes, (Object)n, 0);
    }

    private static final Integer pcGetinheritDerivedAttributes(SyncopeRole syncopeRole) {
        if (syncopeRole.pcStateManager == null) {
            return syncopeRole.inheritDerivedAttributes;
        }
        int n = pcInheritedFieldCount + 7;
        syncopeRole.pcStateManager.accessingField(n);
        return syncopeRole.inheritDerivedAttributes;
    }

    private static final void pcSetinheritDerivedAttributes(SyncopeRole syncopeRole, Integer n) {
        if (syncopeRole.pcStateManager == null) {
            syncopeRole.inheritDerivedAttributes = n;
            return;
        }
        syncopeRole.pcStateManager.settingObjectField((PersistenceCapable)syncopeRole, pcInheritedFieldCount + 7, (Object)syncopeRole.inheritDerivedAttributes, (Object)n, 0);
    }

    private static final Integer pcGetinheritPasswordPolicy(SyncopeRole syncopeRole) {
        if (syncopeRole.pcStateManager == null) {
            return syncopeRole.inheritPasswordPolicy;
        }
        int n = pcInheritedFieldCount + 8;
        syncopeRole.pcStateManager.accessingField(n);
        return syncopeRole.inheritPasswordPolicy;
    }

    private static final void pcSetinheritPasswordPolicy(SyncopeRole syncopeRole, Integer n) {
        if (syncopeRole.pcStateManager == null) {
            syncopeRole.inheritPasswordPolicy = n;
            return;
        }
        syncopeRole.pcStateManager.settingObjectField((PersistenceCapable)syncopeRole, pcInheritedFieldCount + 8, (Object)syncopeRole.inheritPasswordPolicy, (Object)n, 0);
    }

    private static final Integer pcGetinheritVirtualAttributes(SyncopeRole syncopeRole) {
        if (syncopeRole.pcStateManager == null) {
            return syncopeRole.inheritVirtualAttributes;
        }
        int n = pcInheritedFieldCount + 9;
        syncopeRole.pcStateManager.accessingField(n);
        return syncopeRole.inheritVirtualAttributes;
    }

    private static final void pcSetinheritVirtualAttributes(SyncopeRole syncopeRole, Integer n) {
        if (syncopeRole.pcStateManager == null) {
            syncopeRole.inheritVirtualAttributes = n;
            return;
        }
        syncopeRole.pcStateManager.settingObjectField((PersistenceCapable)syncopeRole, pcInheritedFieldCount + 9, (Object)syncopeRole.inheritVirtualAttributes, (Object)n, 0);
    }

    private static final String pcGetname(SyncopeRole syncopeRole) {
        if (syncopeRole.pcStateManager == null) {
            return syncopeRole.name;
        }
        int n = pcInheritedFieldCount + 10;
        syncopeRole.pcStateManager.accessingField(n);
        return syncopeRole.name;
    }

    private static final void pcSetname(SyncopeRole syncopeRole, String string) {
        if (syncopeRole.pcStateManager == null) {
            syncopeRole.name = string;
            return;
        }
        syncopeRole.pcStateManager.settingStringField((PersistenceCapable)syncopeRole, pcInheritedFieldCount + 10, syncopeRole.name, string, 0);
    }

    private static final SyncopeRole pcGetparent(SyncopeRole syncopeRole) {
        if (syncopeRole.pcStateManager == null) {
            return syncopeRole.parent;
        }
        int n = pcInheritedFieldCount + 11;
        syncopeRole.pcStateManager.accessingField(n);
        return syncopeRole.parent;
    }

    private static final void pcSetparent(SyncopeRole syncopeRole, SyncopeRole syncopeRole2) {
        if (syncopeRole.pcStateManager == null) {
            syncopeRole.parent = syncopeRole2;
            return;
        }
        syncopeRole.pcStateManager.settingObjectField((PersistenceCapable)syncopeRole, pcInheritedFieldCount + 11, (Object)syncopeRole.parent, (Object)syncopeRole2, 0);
    }

    private static final PasswordPolicy pcGetpasswordPolicy(SyncopeRole syncopeRole) {
        if (syncopeRole.pcStateManager == null) {
            return syncopeRole.passwordPolicy;
        }
        int n = pcInheritedFieldCount + 12;
        syncopeRole.pcStateManager.accessingField(n);
        return syncopeRole.passwordPolicy;
    }

    private static final void pcSetpasswordPolicy(SyncopeRole syncopeRole, PasswordPolicy passwordPolicy) {
        if (syncopeRole.pcStateManager == null) {
            syncopeRole.passwordPolicy = passwordPolicy;
            return;
        }
        syncopeRole.pcStateManager.settingObjectField((PersistenceCapable)syncopeRole, pcInheritedFieldCount + 12, (Object)syncopeRole.passwordPolicy, (Object)passwordPolicy, 0);
    }

    private static final Set pcGetresources(SyncopeRole syncopeRole) {
        if (syncopeRole.pcStateManager == null) {
            return syncopeRole.resources;
        }
        int n = pcInheritedFieldCount + 13;
        syncopeRole.pcStateManager.accessingField(n);
        return syncopeRole.resources;
    }

    private static final void pcSetresources(SyncopeRole syncopeRole, Set set) {
        if (syncopeRole.pcStateManager == null) {
            syncopeRole.resources = set;
            return;
        }
        syncopeRole.pcStateManager.settingObjectField((PersistenceCapable)syncopeRole, pcInheritedFieldCount + 13, syncopeRole.resources, (Object)set, 0);
    }

    private static final List pcGetvirtualAttributes(SyncopeRole syncopeRole) {
        if (syncopeRole.pcStateManager == null) {
            return syncopeRole.virtualAttributes;
        }
        int n = pcInheritedFieldCount + 14;
        syncopeRole.pcStateManager.accessingField(n);
        return syncopeRole.virtualAttributes;
    }

    private static final void pcSetvirtualAttributes(SyncopeRole syncopeRole, List list) {
        if (syncopeRole.pcStateManager == null) {
            syncopeRole.virtualAttributes = list;
            return;
        }
        syncopeRole.pcStateManager.settingObjectField((PersistenceCapable)syncopeRole, pcInheritedFieldCount + 14, syncopeRole.virtualAttributes, (Object)list, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.id != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

