/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.beans;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;
import org.apache.syncope.client.util.XMLSerializer;
import org.apache.syncope.core.persistence.beans.AbstractBaseBean;
import org.apache.syncope.core.persistence.beans.AccountPolicy;
import org.apache.syncope.core.persistence.beans.ConnInstance;
import org.apache.syncope.core.persistence.beans.PasswordPolicy;
import org.apache.syncope.core.persistence.beans.SchemaMapping;
import org.apache.syncope.core.persistence.beans.SyncPolicy;
import org.apache.syncope.core.persistence.validation.entity.ExternalResourceCheck;
import org.apache.syncope.types.ConnConfProperty;
import org.apache.syncope.types.IntMappingType;
import org.apache.syncope.types.PropagationMode;
import org.apache.syncope.types.TraceLevel;
import org.identityconnectors.framework.common.objects.SyncToken;

@Entity
@Cacheable
@ExternalResourceCheck
public class ExternalResource
extends AbstractBaseBean
implements PersistenceCapable {
    private static final long serialVersionUID = -6937712883512073278L;
    @Id
    private String name;
    @Column(nullable=false)
    @Basic
    @Min(value=0L)
    @Max(value=1L)
    private Integer forceMandatoryConstraint = this.getBooleanAsInteger(false);
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.MERGE})
    @NotNull
    private ConnInstance connector;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER, mappedBy="resource")
    @Valid
    private Set<SchemaMapping> mappings = new HashSet<SchemaMapping>();
    private String accountLink;
    @Column(nullable=false)
    @Basic
    @Min(value=0L)
    @Max(value=1L)
    private Integer propagationPrimary = 0;
    @Column(nullable=false)
    private Integer propagationPriority = 0;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private PropagationMode propagationMode = PropagationMode.TWO_PHASES;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private TraceLevel createTraceLevel = TraceLevel.FAILURES;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private TraceLevel updateTraceLevel = TraceLevel.FAILURES;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private TraceLevel deleteTraceLevel = TraceLevel.FAILURES;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private TraceLevel syncTraceLevel = TraceLevel.FAILURES;
    @ManyToOne(fetch=FetchType.EAGER, optional=true)
    private PasswordPolicy passwordPolicy;
    @ManyToOne(fetch=FetchType.EAGER, optional=true)
    private AccountPolicy accountPolicy;
    @ManyToOne(fetch=FetchType.EAGER, optional=true)
    private SyncPolicy syncPolicy;
    @Lob
    private String xmlConfiguration;
    @Lob
    private String serializedSyncToken;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$beans$AccountPolicy;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$beans$ConnInstance;
    static /* synthetic */ Class class$Lorg$apache$syncope$types$TraceLevel;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$beans$PasswordPolicy;
    static /* synthetic */ Class class$Lorg$apache$syncope$types$PropagationMode;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$beans$SyncPolicy;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$beans$ExternalResource;
    private transient Object pcDetachedState;

    public boolean isForceMandatoryConstraint() {
        return this.isBooleanAsInteger(ExternalResource.pcGetforceMandatoryConstraint(this));
    }

    public void setForceMandatoryConstraint(boolean forceMandatoryConstraint) {
        ExternalResource.pcSetforceMandatoryConstraint(this, this.getBooleanAsInteger(forceMandatoryConstraint));
    }

    public ConnInstance getConnector() {
        return ExternalResource.pcGetconnector(this);
    }

    public void setConnector(ConnInstance connector) {
        ExternalResource.pcSetconnector(this, connector);
    }

    public boolean isPropagationPrimary() {
        return this.isBooleanAsInteger(ExternalResource.pcGetpropagationPrimary(this));
    }

    public void setPropagationPrimary(boolean propagationPrimary) {
        ExternalResource.pcSetpropagationPrimary(this, this.getBooleanAsInteger(propagationPrimary));
    }

    public Integer getPropagationPriority() {
        return ExternalResource.pcGetpropagationPriority(this);
    }

    public void setPropagationPriority(Integer propagationPriority) {
        if (propagationPriority != null) {
            ExternalResource.pcSetpropagationPriority(this, propagationPriority);
        }
    }

    public PropagationMode getPropagationMode() {
        return ExternalResource.pcGetpropagationMode(this);
    }

    public void setPropagationMode(PropagationMode propagationMode) {
        ExternalResource.pcSetpropagationMode(this, propagationMode);
    }

    public Set<SchemaMapping> getMappings() {
        return ExternalResource.pcGetmappings(this);
    }

    public Set<SchemaMapping> getMappings(String intAttrName, IntMappingType intMappingType) {
        HashSet<SchemaMapping> result = new HashSet<SchemaMapping>();
        for (SchemaMapping mapping : ExternalResource.pcGetmappings(this)) {
            if (!intAttrName.equals(mapping.getIntAttrName()) || mapping.getIntMappingType() != intMappingType) continue;
            result.add(mapping);
        }
        return result;
    }

    public boolean removeMapping(SchemaMapping mapping) {
        return ExternalResource.pcGetmappings(this).remove(mapping);
    }

    public boolean addMapping(SchemaMapping mapping) {
        return ExternalResource.pcGetmappings(this).contains(mapping) || ExternalResource.pcGetmappings(this).add(mapping);
    }

    public void setMappings(Set<SchemaMapping> mappings) {
        for (SchemaMapping mapping : ExternalResource.pcGetmappings(this)) {
            mapping.setResource(null);
        }
        ExternalResource.pcGetmappings(this).clear();
        if (mappings != null) {
            ExternalResource.pcGetmappings(this).addAll(mappings);
        }
    }

    public String getAccountLink() {
        return ExternalResource.pcGetaccountLink(this);
    }

    public void setAccountLink(String accountLink) {
        ExternalResource.pcSetaccountLink(this, accountLink);
    }

    public String getName() {
        return ExternalResource.pcGetname(this);
    }

    public void setName(String name) {
        ExternalResource.pcSetname(this, name);
    }

    public TraceLevel getCreateTraceLevel() {
        return ExternalResource.pcGetcreateTraceLevel(this);
    }

    public void setCreateTraceLevel(TraceLevel createTraceLevel) {
        ExternalResource.pcSetcreateTraceLevel(this, createTraceLevel);
    }

    public TraceLevel getDeleteTraceLevel() {
        return ExternalResource.pcGetdeleteTraceLevel(this);
    }

    public void setDeleteTraceLevel(TraceLevel deleteTraceLevel) {
        ExternalResource.pcSetdeleteTraceLevel(this, deleteTraceLevel);
    }

    public TraceLevel getUpdateTraceLevel() {
        return ExternalResource.pcGetupdateTraceLevel(this);
    }

    public void setUpdateTraceLevel(TraceLevel updateTraceLevel) {
        ExternalResource.pcSetupdateTraceLevel(this, updateTraceLevel);
    }

    public TraceLevel getSyncTraceLevel() {
        return ExternalResource.pcGetsyncTraceLevel(this);
    }

    public void setSyncTraceLevel(TraceLevel syncTraceLevel) {
        ExternalResource.pcSetsyncTraceLevel(this, syncTraceLevel);
    }

    public AccountPolicy getAccountPolicy() {
        return ExternalResource.pcGetaccountPolicy(this);
    }

    public void setAccountPolicy(AccountPolicy accountPolicy) {
        ExternalResource.pcSetaccountPolicy(this, accountPolicy);
    }

    public PasswordPolicy getPasswordPolicy() {
        return ExternalResource.pcGetpasswordPolicy(this);
    }

    public void setPasswordPolicy(PasswordPolicy passwordPolicy) {
        ExternalResource.pcSetpasswordPolicy(this, passwordPolicy);
    }

    public SyncPolicy getSyncPolicy() {
        return ExternalResource.pcGetsyncPolicy(this);
    }

    public void setSyncPolicy(SyncPolicy syncPolicy) {
        ExternalResource.pcSetsyncPolicy(this, syncPolicy);
    }

    public void setConnectorConfigurationProperties(Set<ConnConfProperty> properties) {
        ExternalResource.pcSetxmlConfiguration(this, XMLSerializer.serialize(new HashSet<ConnConfProperty>(properties)));
    }

    public Set<ConnConfProperty> getConfiguration() {
        Set deserializedSet;
        Set result = Collections.emptySet();
        if (StringUtils.isNotBlank((String)ExternalResource.pcGetxmlConfiguration(this)) && (deserializedSet = (Set)XMLSerializer.deserialize((String)ExternalResource.pcGetxmlConfiguration(this))) != null) {
            result = deserializedSet;
        }
        return result;
    }

    public String getSerializedSyncToken() {
        return ExternalResource.pcGetserializedSyncToken(this);
    }

    public SyncToken getSyncToken() {
        return ExternalResource.pcGetserializedSyncToken(this) == null ? null : (SyncToken)XMLSerializer.deserialize((String)ExternalResource.pcGetserializedSyncToken(this));
    }

    public void setSerializedSyncToken(String serializedSyncToken) {
        ExternalResource.pcSetserializedSyncToken(this, serializedSyncToken);
    }

    public void setSyncToken(SyncToken syncToken) {
        ExternalResource.pcSetserializedSyncToken(this, XMLSerializer.serialize((Object)syncToken));
    }

    public int pcGetEnhancementContractVersion() {
        return 1241207;
    }

    static {
        pcFieldNames = new String[]{"accountLink", "accountPolicy", "connector", "createTraceLevel", "deleteTraceLevel", "forceMandatoryConstraint", "mappings", "name", "passwordPolicy", "propagationMode", "propagationPrimary", "propagationPriority", "serializedSyncToken", "syncPolicy", "syncTraceLevel", "updateTraceLevel", "xmlConfiguration"};
        Class[] classArray = new Class[17];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ExternalResource.class$("java.lang.String"));
        classArray[0] = clazz;
        Class clazz2 = class$Lorg$apache$syncope$core$persistence$beans$AccountPolicy != null ? class$Lorg$apache$syncope$core$persistence$beans$AccountPolicy : (class$Lorg$apache$syncope$core$persistence$beans$AccountPolicy = ExternalResource.class$("org.apache.syncope.core.persistence.beans.AccountPolicy"));
        classArray[1] = clazz2;
        Class clazz3 = class$Lorg$apache$syncope$core$persistence$beans$ConnInstance != null ? class$Lorg$apache$syncope$core$persistence$beans$ConnInstance : (class$Lorg$apache$syncope$core$persistence$beans$ConnInstance = ExternalResource.class$("org.apache.syncope.core.persistence.beans.ConnInstance"));
        classArray[2] = clazz3;
        Class clazz4 = class$Lorg$apache$syncope$types$TraceLevel != null ? class$Lorg$apache$syncope$types$TraceLevel : (class$Lorg$apache$syncope$types$TraceLevel = ExternalResource.class$("org.apache.syncope.types.TraceLevel"));
        classArray[3] = clazz4;
        classArray[4] = class$Lorg$apache$syncope$types$TraceLevel != null ? class$Lorg$apache$syncope$types$TraceLevel : (class$Lorg$apache$syncope$types$TraceLevel = ExternalResource.class$("org.apache.syncope.types.TraceLevel"));
        Class clazz5 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = ExternalResource.class$("java.lang.Integer"));
        classArray[5] = clazz5;
        Class clazz6 = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = ExternalResource.class$("java.util.Set"));
        classArray[6] = clazz6;
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ExternalResource.class$("java.lang.String"));
        Class clazz7 = class$Lorg$apache$syncope$core$persistence$beans$PasswordPolicy != null ? class$Lorg$apache$syncope$core$persistence$beans$PasswordPolicy : (class$Lorg$apache$syncope$core$persistence$beans$PasswordPolicy = ExternalResource.class$("org.apache.syncope.core.persistence.beans.PasswordPolicy"));
        classArray[8] = clazz7;
        Class clazz8 = class$Lorg$apache$syncope$types$PropagationMode != null ? class$Lorg$apache$syncope$types$PropagationMode : (class$Lorg$apache$syncope$types$PropagationMode = ExternalResource.class$("org.apache.syncope.types.PropagationMode"));
        classArray[9] = clazz8;
        classArray[10] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = ExternalResource.class$("java.lang.Integer"));
        classArray[11] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = ExternalResource.class$("java.lang.Integer"));
        classArray[12] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ExternalResource.class$("java.lang.String"));
        Class clazz9 = class$Lorg$apache$syncope$core$persistence$beans$SyncPolicy != null ? class$Lorg$apache$syncope$core$persistence$beans$SyncPolicy : (class$Lorg$apache$syncope$core$persistence$beans$SyncPolicy = ExternalResource.class$("org.apache.syncope.core.persistence.beans.SyncPolicy"));
        classArray[13] = clazz9;
        classArray[14] = class$Lorg$apache$syncope$types$TraceLevel != null ? class$Lorg$apache$syncope$types$TraceLevel : (class$Lorg$apache$syncope$types$TraceLevel = ExternalResource.class$("org.apache.syncope.types.TraceLevel"));
        classArray[15] = class$Lorg$apache$syncope$types$TraceLevel != null ? class$Lorg$apache$syncope$types$TraceLevel : (class$Lorg$apache$syncope$types$TraceLevel = ExternalResource.class$("org.apache.syncope.types.TraceLevel"));
        classArray[16] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ExternalResource.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 10, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz10 = class$Lorg$apache$syncope$core$persistence$beans$ExternalResource != null ? class$Lorg$apache$syncope$core$persistence$beans$ExternalResource : (class$Lorg$apache$syncope$core$persistence$beans$ExternalResource = ExternalResource.class$("org.apache.syncope.core.persistence.beans.ExternalResource"));
        PCRegistry.register((Class)clazz10, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"ExternalResource", (PersistenceCapable)new ExternalResource());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.accountLink = null;
        this.accountPolicy = null;
        this.connector = null;
        this.createTraceLevel = null;
        this.deleteTraceLevel = null;
        this.forceMandatoryConstraint = null;
        this.mappings = null;
        this.name = null;
        this.passwordPolicy = null;
        this.propagationMode = null;
        this.propagationPrimary = null;
        this.propagationPriority = null;
        this.serializedSyncToken = null;
        this.syncPolicy = null;
        this.syncTraceLevel = null;
        this.updateTraceLevel = null;
        this.xmlConfiguration = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        ExternalResource externalResource = new ExternalResource();
        if (bl) {
            externalResource.pcClearFields();
        }
        externalResource.pcStateManager = stateManager;
        externalResource.pcCopyKeyFieldsFromObjectId(object);
        return externalResource;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        ExternalResource externalResource = new ExternalResource();
        if (bl) {
            externalResource.pcClearFields();
        }
        externalResource.pcStateManager = stateManager;
        return externalResource;
    }

    protected static int pcGetManagedFieldCount() {
        return 17;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.accountLink = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.accountPolicy = (AccountPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.connector = (ConnInstance)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.createTraceLevel = (TraceLevel)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.deleteTraceLevel = (TraceLevel)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.forceMandatoryConstraint = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.mappings = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.passwordPolicy = (PasswordPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.propagationMode = (PropagationMode)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.propagationPrimary = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.propagationPriority = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.serializedSyncToken = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.syncPolicy = (SyncPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.syncTraceLevel = (TraceLevel)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.updateTraceLevel = (TraceLevel)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.xmlConfiguration = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.accountLink);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.accountPolicy);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.connector);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.createTraceLevel);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.deleteTraceLevel);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.forceMandatoryConstraint);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.mappings);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.passwordPolicy);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.propagationMode);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.propagationPrimary);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.propagationPriority);
                return;
            }
            case 12: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.serializedSyncToken);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.syncPolicy);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.syncTraceLevel);
                return;
            }
            case 15: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.updateTraceLevel);
                return;
            }
            case 16: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.xmlConfiguration);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(ExternalResource externalResource, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.accountLink = externalResource.accountLink;
                return;
            }
            case 1: {
                this.accountPolicy = externalResource.accountPolicy;
                return;
            }
            case 2: {
                this.connector = externalResource.connector;
                return;
            }
            case 3: {
                this.createTraceLevel = externalResource.createTraceLevel;
                return;
            }
            case 4: {
                this.deleteTraceLevel = externalResource.deleteTraceLevel;
                return;
            }
            case 5: {
                this.forceMandatoryConstraint = externalResource.forceMandatoryConstraint;
                return;
            }
            case 6: {
                this.mappings = externalResource.mappings;
                return;
            }
            case 7: {
                this.name = externalResource.name;
                return;
            }
            case 8: {
                this.passwordPolicy = externalResource.passwordPolicy;
                return;
            }
            case 9: {
                this.propagationMode = externalResource.propagationMode;
                return;
            }
            case 10: {
                this.propagationPrimary = externalResource.propagationPrimary;
                return;
            }
            case 11: {
                this.propagationPriority = externalResource.propagationPriority;
                return;
            }
            case 12: {
                this.serializedSyncToken = externalResource.serializedSyncToken;
                return;
            }
            case 13: {
                this.syncPolicy = externalResource.syncPolicy;
                return;
            }
            case 14: {
                this.syncTraceLevel = externalResource.syncTraceLevel;
                return;
            }
            case 15: {
                this.updateTraceLevel = externalResource.updateTraceLevel;
                return;
            }
            case 16: {
                this.xmlConfiguration = externalResource.xmlConfiguration;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        ExternalResource externalResource = (ExternalResource)object;
        if (externalResource.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(externalResource, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(7 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.name = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$syncope$core$persistence$beans$ExternalResource != null ? class$Lorg$apache$syncope$core$persistence$beans$ExternalResource : (class$Lorg$apache$syncope$core$persistence$beans$ExternalResource = ExternalResource.class$("org.apache.syncope.core.persistence.beans.ExternalResource"));
        return new StringId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$beans$ExternalResource != null ? class$Lorg$apache$syncope$core$persistence$beans$ExternalResource : (class$Lorg$apache$syncope$core$persistence$beans$ExternalResource = ExternalResource.class$("org.apache.syncope.core.persistence.beans.ExternalResource"));
        return new StringId(clazz, this.name);
    }

    private static final String pcGetaccountLink(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.accountLink;
        }
        int n = pcInheritedFieldCount + 0;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.accountLink;
    }

    private static final void pcSetaccountLink(ExternalResource externalResource, String string) {
        if (externalResource.pcStateManager == null) {
            externalResource.accountLink = string;
            return;
        }
        externalResource.pcStateManager.settingStringField((PersistenceCapable)externalResource, pcInheritedFieldCount + 0, externalResource.accountLink, string, 0);
    }

    private static final AccountPolicy pcGetaccountPolicy(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.accountPolicy;
        }
        int n = pcInheritedFieldCount + 1;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.accountPolicy;
    }

    private static final void pcSetaccountPolicy(ExternalResource externalResource, AccountPolicy accountPolicy) {
        if (externalResource.pcStateManager == null) {
            externalResource.accountPolicy = accountPolicy;
            return;
        }
        externalResource.pcStateManager.settingObjectField((PersistenceCapable)externalResource, pcInheritedFieldCount + 1, (Object)externalResource.accountPolicy, (Object)accountPolicy, 0);
    }

    private static final ConnInstance pcGetconnector(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.connector;
        }
        int n = pcInheritedFieldCount + 2;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.connector;
    }

    private static final void pcSetconnector(ExternalResource externalResource, ConnInstance connInstance) {
        if (externalResource.pcStateManager == null) {
            externalResource.connector = connInstance;
            return;
        }
        externalResource.pcStateManager.settingObjectField((PersistenceCapable)externalResource, pcInheritedFieldCount + 2, (Object)externalResource.connector, (Object)connInstance, 0);
    }

    private static final TraceLevel pcGetcreateTraceLevel(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.createTraceLevel;
        }
        int n = pcInheritedFieldCount + 3;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.createTraceLevel;
    }

    private static final void pcSetcreateTraceLevel(ExternalResource externalResource, TraceLevel traceLevel) {
        if (externalResource.pcStateManager == null) {
            externalResource.createTraceLevel = traceLevel;
            return;
        }
        externalResource.pcStateManager.settingObjectField((PersistenceCapable)externalResource, pcInheritedFieldCount + 3, (Object)externalResource.createTraceLevel, (Object)traceLevel, 0);
    }

    private static final TraceLevel pcGetdeleteTraceLevel(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.deleteTraceLevel;
        }
        int n = pcInheritedFieldCount + 4;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.deleteTraceLevel;
    }

    private static final void pcSetdeleteTraceLevel(ExternalResource externalResource, TraceLevel traceLevel) {
        if (externalResource.pcStateManager == null) {
            externalResource.deleteTraceLevel = traceLevel;
            return;
        }
        externalResource.pcStateManager.settingObjectField((PersistenceCapable)externalResource, pcInheritedFieldCount + 4, (Object)externalResource.deleteTraceLevel, (Object)traceLevel, 0);
    }

    private static final Integer pcGetforceMandatoryConstraint(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.forceMandatoryConstraint;
        }
        int n = pcInheritedFieldCount + 5;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.forceMandatoryConstraint;
    }

    private static final void pcSetforceMandatoryConstraint(ExternalResource externalResource, Integer n) {
        if (externalResource.pcStateManager == null) {
            externalResource.forceMandatoryConstraint = n;
            return;
        }
        externalResource.pcStateManager.settingObjectField((PersistenceCapable)externalResource, pcInheritedFieldCount + 5, (Object)externalResource.forceMandatoryConstraint, (Object)n, 0);
    }

    private static final Set pcGetmappings(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.mappings;
        }
        int n = pcInheritedFieldCount + 6;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.mappings;
    }

    private static final void pcSetmappings(ExternalResource externalResource, Set set) {
        if (externalResource.pcStateManager == null) {
            externalResource.mappings = set;
            return;
        }
        externalResource.pcStateManager.settingObjectField((PersistenceCapable)externalResource, pcInheritedFieldCount + 6, externalResource.mappings, (Object)set, 0);
    }

    private static final String pcGetname(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.name;
        }
        int n = pcInheritedFieldCount + 7;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.name;
    }

    private static final void pcSetname(ExternalResource externalResource, String string) {
        if (externalResource.pcStateManager == null) {
            externalResource.name = string;
            return;
        }
        externalResource.pcStateManager.settingStringField((PersistenceCapable)externalResource, pcInheritedFieldCount + 7, externalResource.name, string, 0);
    }

    private static final PasswordPolicy pcGetpasswordPolicy(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.passwordPolicy;
        }
        int n = pcInheritedFieldCount + 8;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.passwordPolicy;
    }

    private static final void pcSetpasswordPolicy(ExternalResource externalResource, PasswordPolicy passwordPolicy) {
        if (externalResource.pcStateManager == null) {
            externalResource.passwordPolicy = passwordPolicy;
            return;
        }
        externalResource.pcStateManager.settingObjectField((PersistenceCapable)externalResource, pcInheritedFieldCount + 8, (Object)externalResource.passwordPolicy, (Object)passwordPolicy, 0);
    }

    private static final PropagationMode pcGetpropagationMode(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.propagationMode;
        }
        int n = pcInheritedFieldCount + 9;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.propagationMode;
    }

    private static final void pcSetpropagationMode(ExternalResource externalResource, PropagationMode propagationMode) {
        if (externalResource.pcStateManager == null) {
            externalResource.propagationMode = propagationMode;
            return;
        }
        externalResource.pcStateManager.settingObjectField((PersistenceCapable)externalResource, pcInheritedFieldCount + 9, (Object)externalResource.propagationMode, (Object)propagationMode, 0);
    }

    private static final Integer pcGetpropagationPrimary(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.propagationPrimary;
        }
        int n = pcInheritedFieldCount + 10;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.propagationPrimary;
    }

    private static final void pcSetpropagationPrimary(ExternalResource externalResource, Integer n) {
        if (externalResource.pcStateManager == null) {
            externalResource.propagationPrimary = n;
            return;
        }
        externalResource.pcStateManager.settingObjectField((PersistenceCapable)externalResource, pcInheritedFieldCount + 10, (Object)externalResource.propagationPrimary, (Object)n, 0);
    }

    private static final Integer pcGetpropagationPriority(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.propagationPriority;
        }
        int n = pcInheritedFieldCount + 11;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.propagationPriority;
    }

    private static final void pcSetpropagationPriority(ExternalResource externalResource, Integer n) {
        if (externalResource.pcStateManager == null) {
            externalResource.propagationPriority = n;
            return;
        }
        externalResource.pcStateManager.settingObjectField((PersistenceCapable)externalResource, pcInheritedFieldCount + 11, (Object)externalResource.propagationPriority, (Object)n, 0);
    }

    private static final String pcGetserializedSyncToken(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.serializedSyncToken;
        }
        int n = pcInheritedFieldCount + 12;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.serializedSyncToken;
    }

    private static final void pcSetserializedSyncToken(ExternalResource externalResource, String string) {
        if (externalResource.pcStateManager == null) {
            externalResource.serializedSyncToken = string;
            return;
        }
        externalResource.pcStateManager.settingStringField((PersistenceCapable)externalResource, pcInheritedFieldCount + 12, externalResource.serializedSyncToken, string, 0);
    }

    private static final SyncPolicy pcGetsyncPolicy(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.syncPolicy;
        }
        int n = pcInheritedFieldCount + 13;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.syncPolicy;
    }

    private static final void pcSetsyncPolicy(ExternalResource externalResource, SyncPolicy syncPolicy) {
        if (externalResource.pcStateManager == null) {
            externalResource.syncPolicy = syncPolicy;
            return;
        }
        externalResource.pcStateManager.settingObjectField((PersistenceCapable)externalResource, pcInheritedFieldCount + 13, (Object)externalResource.syncPolicy, (Object)syncPolicy, 0);
    }

    private static final TraceLevel pcGetsyncTraceLevel(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.syncTraceLevel;
        }
        int n = pcInheritedFieldCount + 14;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.syncTraceLevel;
    }

    private static final void pcSetsyncTraceLevel(ExternalResource externalResource, TraceLevel traceLevel) {
        if (externalResource.pcStateManager == null) {
            externalResource.syncTraceLevel = traceLevel;
            return;
        }
        externalResource.pcStateManager.settingObjectField((PersistenceCapable)externalResource, pcInheritedFieldCount + 14, (Object)externalResource.syncTraceLevel, (Object)traceLevel, 0);
    }

    private static final TraceLevel pcGetupdateTraceLevel(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.updateTraceLevel;
        }
        int n = pcInheritedFieldCount + 15;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.updateTraceLevel;
    }

    private static final void pcSetupdateTraceLevel(ExternalResource externalResource, TraceLevel traceLevel) {
        if (externalResource.pcStateManager == null) {
            externalResource.updateTraceLevel = traceLevel;
            return;
        }
        externalResource.pcStateManager.settingObjectField((PersistenceCapable)externalResource, pcInheritedFieldCount + 15, (Object)externalResource.updateTraceLevel, (Object)traceLevel, 0);
    }

    private static final String pcGetxmlConfiguration(ExternalResource externalResource) {
        if (externalResource.pcStateManager == null) {
            return externalResource.xmlConfiguration;
        }
        int n = pcInheritedFieldCount + 16;
        externalResource.pcStateManager.accessingField(n);
        return externalResource.xmlConfiguration;
    }

    private static final void pcSetxmlConfiguration(ExternalResource externalResource, String string) {
        if (externalResource.pcStateManager == null) {
            externalResource.xmlConfiguration = string;
            return;
        }
        externalResource.pcStateManager.settingStringField((PersistenceCapable)externalResource, pcInheritedFieldCount + 16, externalResource.xmlConfiguration, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

