/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.beans;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.syncope.client.util.XMLSerializer;
import org.apache.syncope.core.persistence.beans.AbstractBaseBean;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.types.ConnConfProperty;
import org.apache.syncope.types.ConnectorCapability;

@Entity
public class ConnInstance
extends AbstractBaseBean
implements PersistenceCapable {
    private static final long serialVersionUID = -2294708794497208872L;
    @Id
    private Long id;
    @Column(nullable=false)
    private String connectorName;
    @Column(nullable=false)
    private String bundleName;
    @Column(nullable=false)
    private String version;
    @ElementCollection(fetch=FetchType.EAGER)
    @Enumerated(value=EnumType.STRING)
    @Column(name="capabilities")
    private Set<ConnectorCapability> capabilities = new HashSet<ConnectorCapability>();
    @Lob
    private String xmlConfiguration;
    @Column(unique=true)
    private String displayName;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="connector")
    private List<ExternalResource> resources = new ArrayList<ExternalResource>();
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$beans$ConnInstance;
    private transient Object pcDetachedState;

    public String getVersion() {
        return ConnInstance.pcGetversion(this);
    }

    public void setVersion(String majorVersion) {
        ConnInstance.pcSetversion(this, majorVersion);
    }

    public String getBundleName() {
        return ConnInstance.pcGetbundleName(this);
    }

    public void setBundleName(String bundleName) {
        ConnInstance.pcSetbundleName(this, bundleName);
    }

    public String getConnectorName() {
        return ConnInstance.pcGetconnectorName(this);
    }

    public void setConnectorName(String connectorName) {
        ConnInstance.pcSetconnectorName(this, connectorName);
    }

    public Set<ConnConfProperty> getConfiguration() {
        Set<ConnConfProperty> result = (Set<ConnConfProperty>)XMLSerializer.deserialize((String)ConnInstance.pcGetxmlConfiguration(this));
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    public void setConfiguration(Set<ConnConfProperty> configuration) {
        ConnInstance.pcSetxmlConfiguration(this, XMLSerializer.serialize(new HashSet<ConnConfProperty>(configuration)));
    }

    public Long getId() {
        return ConnInstance.pcGetid(this);
    }

    public String getDisplayName() {
        return ConnInstance.pcGetdisplayName(this);
    }

    public void setDisplayName(String displayName) {
        ConnInstance.pcSetdisplayName(this, displayName);
    }

    public List<ExternalResource> getResources() {
        return ConnInstance.pcGetresources(this);
    }

    public void setResources(List<ExternalResource> resources) {
        ConnInstance.pcGetresources(this).clear();
        if (resources != null && !resources.isEmpty()) {
            ConnInstance.pcGetresources(this).addAll(resources);
        }
    }

    public boolean addResource(ExternalResource resource) {
        return !ConnInstance.pcGetresources(this).contains(resource) && ConnInstance.pcGetresources(this).add(resource);
    }

    public boolean removeResource(ExternalResource resource) {
        return ConnInstance.pcGetresources(this).remove(resource);
    }

    public boolean addCapability(ConnectorCapability capabitily) {
        return ConnInstance.pcGetcapabilities(this).add(capabitily);
    }

    public boolean removeCapability(ConnectorCapability capabitily) {
        return ConnInstance.pcGetcapabilities(this).remove(capabitily);
    }

    public Set<ConnectorCapability> getCapabilities() {
        return ConnInstance.pcGetcapabilities(this);
    }

    public void setCapabilities(Set<ConnectorCapability> capabilities) {
        ConnInstance.pcGetcapabilities(this).clear();
        if (capabilities != null && !capabilities.isEmpty()) {
            ConnInstance.pcGetcapabilities(this).addAll(capabilities);
        }
    }

    public int pcGetEnhancementContractVersion() {
        return 1241207;
    }

    static {
        pcFieldNames = new String[]{"bundleName", "capabilities", "connectorName", "displayName", "id", "resources", "version", "xmlConfiguration"};
        Class[] classArray = new Class[8];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ConnInstance.class$("java.lang.String"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = ConnInstance.class$("java.util.Set"));
        classArray[1] = clazz2;
        classArray[2] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ConnInstance.class$("java.lang.String"));
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ConnInstance.class$("java.lang.String"));
        Class clazz3 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = ConnInstance.class$("java.lang.Long"));
        classArray[4] = clazz3;
        Class clazz4 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = ConnInstance.class$("java.util.List"));
        classArray[5] = clazz4;
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ConnInstance.class$("java.lang.String"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ConnInstance.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 10, 26, 26, 26, 5, 26, 26};
        Class clazz5 = class$Lorg$apache$syncope$core$persistence$beans$ConnInstance != null ? class$Lorg$apache$syncope$core$persistence$beans$ConnInstance : (class$Lorg$apache$syncope$core$persistence$beans$ConnInstance = ConnInstance.class$("org.apache.syncope.core.persistence.beans.ConnInstance"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"ConnInstance", (PersistenceCapable)new ConnInstance());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.bundleName = null;
        this.capabilities = null;
        this.connectorName = null;
        this.displayName = null;
        this.id = null;
        this.resources = null;
        this.version = null;
        this.xmlConfiguration = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        ConnInstance connInstance = new ConnInstance();
        if (bl) {
            connInstance.pcClearFields();
        }
        connInstance.pcStateManager = stateManager;
        connInstance.pcCopyKeyFieldsFromObjectId(object);
        return connInstance;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        ConnInstance connInstance = new ConnInstance();
        if (bl) {
            connInstance.pcClearFields();
        }
        connInstance.pcStateManager = stateManager;
        return connInstance;
    }

    protected static int pcGetManagedFieldCount() {
        return 8;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.bundleName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.capabilities = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.connectorName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.displayName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.resources = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.version = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.xmlConfiguration = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.bundleName);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.capabilities);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.connectorName);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.displayName);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.id);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.resources);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.version);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.xmlConfiguration);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(ConnInstance connInstance, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.bundleName = connInstance.bundleName;
                return;
            }
            case 1: {
                this.capabilities = connInstance.capabilities;
                return;
            }
            case 2: {
                this.connectorName = connInstance.connectorName;
                return;
            }
            case 3: {
                this.displayName = connInstance.displayName;
                return;
            }
            case 4: {
                this.id = connInstance.id;
                return;
            }
            case 5: {
                this.resources = connInstance.resources;
                return;
            }
            case 6: {
                this.version = connInstance.version;
                return;
            }
            case 7: {
                this.xmlConfiguration = connInstance.xmlConfiguration;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        ConnInstance connInstance = (ConnInstance)object;
        if (connInstance.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(connInstance, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(4 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.id = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$syncope$core$persistence$beans$ConnInstance != null ? class$Lorg$apache$syncope$core$persistence$beans$ConnInstance : (class$Lorg$apache$syncope$core$persistence$beans$ConnInstance = ConnInstance.class$("org.apache.syncope.core.persistence.beans.ConnInstance"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$beans$ConnInstance != null ? class$Lorg$apache$syncope$core$persistence$beans$ConnInstance : (class$Lorg$apache$syncope$core$persistence$beans$ConnInstance = ConnInstance.class$("org.apache.syncope.core.persistence.beans.ConnInstance"));
        return new LongId(clazz, this.id);
    }

    private static final String pcGetbundleName(ConnInstance connInstance) {
        if (connInstance.pcStateManager == null) {
            return connInstance.bundleName;
        }
        int n = pcInheritedFieldCount + 0;
        connInstance.pcStateManager.accessingField(n);
        return connInstance.bundleName;
    }

    private static final void pcSetbundleName(ConnInstance connInstance, String string) {
        if (connInstance.pcStateManager == null) {
            connInstance.bundleName = string;
            return;
        }
        connInstance.pcStateManager.settingStringField((PersistenceCapable)connInstance, pcInheritedFieldCount + 0, connInstance.bundleName, string, 0);
    }

    private static final Set pcGetcapabilities(ConnInstance connInstance) {
        if (connInstance.pcStateManager == null) {
            return connInstance.capabilities;
        }
        int n = pcInheritedFieldCount + 1;
        connInstance.pcStateManager.accessingField(n);
        return connInstance.capabilities;
    }

    private static final void pcSetcapabilities(ConnInstance connInstance, Set set) {
        if (connInstance.pcStateManager == null) {
            connInstance.capabilities = set;
            return;
        }
        connInstance.pcStateManager.settingObjectField((PersistenceCapable)connInstance, pcInheritedFieldCount + 1, connInstance.capabilities, (Object)set, 0);
    }

    private static final String pcGetconnectorName(ConnInstance connInstance) {
        if (connInstance.pcStateManager == null) {
            return connInstance.connectorName;
        }
        int n = pcInheritedFieldCount + 2;
        connInstance.pcStateManager.accessingField(n);
        return connInstance.connectorName;
    }

    private static final void pcSetconnectorName(ConnInstance connInstance, String string) {
        if (connInstance.pcStateManager == null) {
            connInstance.connectorName = string;
            return;
        }
        connInstance.pcStateManager.settingStringField((PersistenceCapable)connInstance, pcInheritedFieldCount + 2, connInstance.connectorName, string, 0);
    }

    private static final String pcGetdisplayName(ConnInstance connInstance) {
        if (connInstance.pcStateManager == null) {
            return connInstance.displayName;
        }
        int n = pcInheritedFieldCount + 3;
        connInstance.pcStateManager.accessingField(n);
        return connInstance.displayName;
    }

    private static final void pcSetdisplayName(ConnInstance connInstance, String string) {
        if (connInstance.pcStateManager == null) {
            connInstance.displayName = string;
            return;
        }
        connInstance.pcStateManager.settingStringField((PersistenceCapable)connInstance, pcInheritedFieldCount + 3, connInstance.displayName, string, 0);
    }

    private static final Long pcGetid(ConnInstance connInstance) {
        if (connInstance.pcStateManager == null) {
            return connInstance.id;
        }
        int n = pcInheritedFieldCount + 4;
        connInstance.pcStateManager.accessingField(n);
        return connInstance.id;
    }

    private static final void pcSetid(ConnInstance connInstance, Long l) {
        if (connInstance.pcStateManager == null) {
            connInstance.id = l;
            return;
        }
        connInstance.pcStateManager.settingObjectField((PersistenceCapable)connInstance, pcInheritedFieldCount + 4, (Object)connInstance.id, (Object)l, 0);
    }

    private static final List pcGetresources(ConnInstance connInstance) {
        if (connInstance.pcStateManager == null) {
            return connInstance.resources;
        }
        int n = pcInheritedFieldCount + 5;
        connInstance.pcStateManager.accessingField(n);
        return connInstance.resources;
    }

    private static final void pcSetresources(ConnInstance connInstance, List list) {
        if (connInstance.pcStateManager == null) {
            connInstance.resources = list;
            return;
        }
        connInstance.pcStateManager.settingObjectField((PersistenceCapable)connInstance, pcInheritedFieldCount + 5, connInstance.resources, (Object)list, 0);
    }

    private static final String pcGetversion(ConnInstance connInstance) {
        if (connInstance.pcStateManager == null) {
            return connInstance.version;
        }
        int n = pcInheritedFieldCount + 6;
        connInstance.pcStateManager.accessingField(n);
        return connInstance.version;
    }

    private static final void pcSetversion(ConnInstance connInstance, String string) {
        if (connInstance.pcStateManager == null) {
            connInstance.version = string;
            return;
        }
        connInstance.pcStateManager.settingStringField((PersistenceCapable)connInstance, pcInheritedFieldCount + 6, connInstance.version, string, 0);
    }

    private static final String pcGetxmlConfiguration(ConnInstance connInstance) {
        if (connInstance.pcStateManager == null) {
            return connInstance.xmlConfiguration;
        }
        int n = pcInheritedFieldCount + 7;
        connInstance.pcStateManager.accessingField(n);
        return connInstance.xmlConfiguration;
    }

    private static final void pcSetxmlConfiguration(ConnInstance connInstance, String string) {
        if (connInstance.pcStateManager == null) {
            connInstance.xmlConfiguration = string;
            return;
        }
        connInstance.pcStateManager.settingStringField((PersistenceCapable)connInstance, pcInheritedFieldCount + 7, connInstance.xmlConfiguration, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.id != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

