/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.beans;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;
import org.apache.openjpa.util.UserException;
import org.apache.syncope.core.persistence.beans.AbstractBaseBean;
import org.apache.syncope.core.persistence.validation.attrvalue.AbstractValidator;
import org.apache.syncope.core.persistence.validation.attrvalue.BasicValidator;
import org.apache.syncope.core.persistence.validation.entity.SchemaCheck;
import org.apache.syncope.types.SchemaType;

@MappedSuperclass
@SchemaCheck
public abstract class AbstractSchema
extends AbstractBaseBean
implements PersistenceCapable {
    public static String enumValuesSeparator = ";";
    private static final long serialVersionUID = -8621028596062054739L;
    @Id
    private String name;
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    private SchemaType type = SchemaType.String;
    @Column(nullable=false)
    private String mandatoryCondition = Boolean.FALSE.toString();
    @Basic
    @Min(value=0L)
    @Max(value=1L)
    private Integer multivalue = this.getBooleanAsInteger(false);
    @Basic
    @Min(value=0L)
    @Max(value=1L)
    private Integer uniqueConstraint = this.getBooleanAsInteger(false);
    @Basic
    @Min(value=0L)
    @Max(value=1L)
    private Integer readonly = this.getBooleanAsInteger(false);
    @Column(nullable=true)
    private String conversionPattern;
    @Column(nullable=true)
    private String validatorClass;
    @Column(nullable=true)
    private String enumerationValues;
    @Column(nullable=true)
    private String enumerationKeys;
    @Transient
    private AbstractValidator validator;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Lorg$apache$syncope$types$SchemaType;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$beans$AbstractSchema;
    private transient Object pcDetachedState;

    public String getName() {
        return AbstractSchema.pcGetname(this);
    }

    public void setName(String name) {
        AbstractSchema.pcSetname(this, name);
    }

    public SchemaType getType() {
        return AbstractSchema.pcGettype(this);
    }

    public void setType(SchemaType type) {
        AbstractSchema.pcSettype(this, type);
    }

    public String getMandatoryCondition() {
        return AbstractSchema.pcGetmandatoryCondition(this);
    }

    public void setMandatoryCondition(String mandatoryCondition) {
        AbstractSchema.pcSetmandatoryCondition(this, mandatoryCondition);
    }

    public boolean isMultivalue() {
        return this.isBooleanAsInteger(AbstractSchema.pcGetmultivalue(this));
    }

    public void setMultivalue(boolean multivalue) {
        AbstractSchema.pcSetmultivalue(this, this.getBooleanAsInteger(multivalue));
    }

    public boolean isUniqueConstraint() {
        return this.isBooleanAsInteger(AbstractSchema.pcGetuniqueConstraint(this));
    }

    public void setUniqueConstraint(boolean uniquevalue) {
        AbstractSchema.pcSetuniqueConstraint(this, this.getBooleanAsInteger(uniquevalue));
    }

    public boolean isReadonly() {
        return this.isBooleanAsInteger(AbstractSchema.pcGetreadonly(this));
    }

    public void setReadonly(boolean readonly) {
        AbstractSchema.pcSetreadonly(this, this.getBooleanAsInteger(readonly));
    }

    public AbstractValidator getValidator() {
        if (this.validator != null) {
            return this.validator;
        }
        if (this.getValidatorClass() != null && this.getValidatorClass().length() > 0) {
            try {
                Constructor<?> validatorConstructor = Class.forName(this.getValidatorClass()).getConstructor(this.getClass().getSuperclass());
                this.validator = (AbstractValidator)validatorConstructor.newInstance(this);
            }
            catch (Exception e) {
                LOG.error("Could not instantiate validator of type " + this.getValidatorClass() + ", reverting to AttributeBasicValidator", (Throwable)e);
            }
        }
        if (this.validator == null) {
            this.validator = new BasicValidator(this);
        }
        return this.validator;
    }

    public String getValidatorClass() {
        return AbstractSchema.pcGetvalidatorClass(this);
    }

    public void setValidatorClass(String validatorClass) {
        AbstractSchema.pcSetvalidatorClass(this, validatorClass);
    }

    public String getEnumerationValues() {
        return AbstractSchema.pcGetenumerationValues(this);
    }

    public void setEnumerationValues(String enumerationValues) {
        AbstractSchema.pcSetenumerationValues(this, enumerationValues);
    }

    public String getEnumerationKeys() {
        return AbstractSchema.pcGetenumerationKeys(this);
    }

    public void setEnumerationKeys(String enumerationKeys) {
        AbstractSchema.pcSetenumerationKeys(this, enumerationKeys);
    }

    public String getConversionPattern() {
        if (!this.getType().isConversionPatternNeeded()) {
            LOG.debug("Conversion pattern is not needed: {}'s type is {}", (Object)this, (Object)this.getType());
        }
        return AbstractSchema.pcGetconversionPattern(this);
    }

    public void setConversionPattern(String conversionPattern) {
        if (!this.getType().isConversionPatternNeeded()) {
            LOG.warn("Conversion pattern will be ignored: this attribute type is " + this.getType());
        }
        AbstractSchema.pcSetconversionPattern(this, conversionPattern);
    }

    public <T extends Format> T getFormatter() {
        Format result = null;
        if (this.getConversionPattern() != null) {
            switch (this.getType()) {
                case Long: {
                    DecimalFormat longFormatter = (DecimalFormat)DECIMAL_FORMAT.get();
                    longFormatter.applyPattern(this.getConversionPattern());
                    result = longFormatter;
                    break;
                }
                case Double: {
                    DecimalFormat doubleFormatter = (DecimalFormat)DECIMAL_FORMAT.get();
                    doubleFormatter.applyPattern(this.getConversionPattern());
                    result = doubleFormatter;
                    break;
                }
                case Date: {
                    SimpleDateFormat dateFormatter = (SimpleDateFormat)DATE_FORMAT.get();
                    dateFormatter.applyPattern(this.getConversionPattern());
                    dateFormatter.setLenient(false);
                    result = dateFormatter;
                    break;
                }
            }
        }
        return (T)result;
    }

    static {
        pcFieldNames = new String[]{"conversionPattern", "enumerationKeys", "enumerationValues", "mandatoryCondition", "multivalue", "name", "readonly", "type", "uniqueConstraint", "validatorClass"};
        Class[] classArray = new Class[10];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AbstractSchema.class$("java.lang.String"));
        classArray[0] = clazz;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AbstractSchema.class$("java.lang.String"));
        classArray[2] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AbstractSchema.class$("java.lang.String"));
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AbstractSchema.class$("java.lang.String"));
        Class clazz2 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = AbstractSchema.class$("java.lang.Integer"));
        classArray[4] = clazz2;
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AbstractSchema.class$("java.lang.String"));
        classArray[6] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = AbstractSchema.class$("java.lang.Integer"));
        Class clazz3 = class$Lorg$apache$syncope$types$SchemaType != null ? class$Lorg$apache$syncope$types$SchemaType : (class$Lorg$apache$syncope$types$SchemaType = AbstractSchema.class$("org.apache.syncope.types.SchemaType"));
        classArray[7] = clazz3;
        classArray[8] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = AbstractSchema.class$("java.lang.Integer"));
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AbstractSchema.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz4 = class$Lorg$apache$syncope$core$persistence$beans$AbstractSchema != null ? class$Lorg$apache$syncope$core$persistence$beans$AbstractSchema : (class$Lorg$apache$syncope$core$persistence$beans$AbstractSchema = AbstractSchema.class$("org.apache.syncope.core.persistence.beans.AbstractSchema"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"AbstractSchema", null);
    }

    public int pcGetEnhancementContractVersion() {
        return 1241207;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.conversionPattern = null;
        this.enumerationKeys = null;
        this.enumerationValues = null;
        this.mandatoryCondition = null;
        this.multivalue = null;
        this.name = null;
        this.readonly = null;
        this.type = null;
        this.uniqueConstraint = null;
        this.validatorClass = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        throw new UserException();
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        throw new UserException();
    }

    protected static int pcGetManagedFieldCount() {
        return 10;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.conversionPattern = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.enumerationKeys = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.enumerationValues = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.mandatoryCondition = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.multivalue = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.readonly = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.type = (SchemaType)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.uniqueConstraint = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.validatorClass = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.conversionPattern);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.enumerationKeys);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.enumerationValues);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.mandatoryCondition);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.multivalue);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.readonly);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.type);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.uniqueConstraint);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.validatorClass);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(AbstractSchema abstractSchema, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.conversionPattern = abstractSchema.conversionPattern;
                return;
            }
            case 1: {
                this.enumerationKeys = abstractSchema.enumerationKeys;
                return;
            }
            case 2: {
                this.enumerationValues = abstractSchema.enumerationValues;
                return;
            }
            case 3: {
                this.mandatoryCondition = abstractSchema.mandatoryCondition;
                return;
            }
            case 4: {
                this.multivalue = abstractSchema.multivalue;
                return;
            }
            case 5: {
                this.name = abstractSchema.name;
                return;
            }
            case 6: {
                this.readonly = abstractSchema.readonly;
                return;
            }
            case 7: {
                this.type = abstractSchema.type;
                return;
            }
            case 8: {
                this.uniqueConstraint = abstractSchema.uniqueConstraint;
                return;
            }
            case 9: {
                this.validatorClass = abstractSchema.validatorClass;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        AbstractSchema abstractSchema = (AbstractSchema)object;
        if (abstractSchema.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(abstractSchema, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(5 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.name = stringId.getId();
    }

    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$beans$AbstractSchema != null ? class$Lorg$apache$syncope$core$persistence$beans$AbstractSchema : (class$Lorg$apache$syncope$core$persistence$beans$AbstractSchema = AbstractSchema.class$("org.apache.syncope.core.persistence.beans.AbstractSchema"));
        return clazz;
    }

    public Object pcNewObjectIdInstance(Object object) {
        return new StringId(this.pcGetIDOwningClass(), (String)object);
    }

    public Object pcNewObjectIdInstance() {
        return new StringId(this.pcGetIDOwningClass(), this.name);
    }

    private static final String pcGetconversionPattern(AbstractSchema abstractSchema) {
        if (abstractSchema.pcStateManager == null) {
            return abstractSchema.conversionPattern;
        }
        int n = pcInheritedFieldCount + 0;
        abstractSchema.pcStateManager.accessingField(n);
        return abstractSchema.conversionPattern;
    }

    private static final void pcSetconversionPattern(AbstractSchema abstractSchema, String string) {
        if (abstractSchema.pcStateManager == null) {
            abstractSchema.conversionPattern = string;
            return;
        }
        abstractSchema.pcStateManager.settingStringField((PersistenceCapable)abstractSchema, pcInheritedFieldCount + 0, abstractSchema.conversionPattern, string, 0);
    }

    private static final String pcGetenumerationKeys(AbstractSchema abstractSchema) {
        if (abstractSchema.pcStateManager == null) {
            return abstractSchema.enumerationKeys;
        }
        int n = pcInheritedFieldCount + 1;
        abstractSchema.pcStateManager.accessingField(n);
        return abstractSchema.enumerationKeys;
    }

    private static final void pcSetenumerationKeys(AbstractSchema abstractSchema, String string) {
        if (abstractSchema.pcStateManager == null) {
            abstractSchema.enumerationKeys = string;
            return;
        }
        abstractSchema.pcStateManager.settingStringField((PersistenceCapable)abstractSchema, pcInheritedFieldCount + 1, abstractSchema.enumerationKeys, string, 0);
    }

    private static final String pcGetenumerationValues(AbstractSchema abstractSchema) {
        if (abstractSchema.pcStateManager == null) {
            return abstractSchema.enumerationValues;
        }
        int n = pcInheritedFieldCount + 2;
        abstractSchema.pcStateManager.accessingField(n);
        return abstractSchema.enumerationValues;
    }

    private static final void pcSetenumerationValues(AbstractSchema abstractSchema, String string) {
        if (abstractSchema.pcStateManager == null) {
            abstractSchema.enumerationValues = string;
            return;
        }
        abstractSchema.pcStateManager.settingStringField((PersistenceCapable)abstractSchema, pcInheritedFieldCount + 2, abstractSchema.enumerationValues, string, 0);
    }

    private static final String pcGetmandatoryCondition(AbstractSchema abstractSchema) {
        if (abstractSchema.pcStateManager == null) {
            return abstractSchema.mandatoryCondition;
        }
        int n = pcInheritedFieldCount + 3;
        abstractSchema.pcStateManager.accessingField(n);
        return abstractSchema.mandatoryCondition;
    }

    private static final void pcSetmandatoryCondition(AbstractSchema abstractSchema, String string) {
        if (abstractSchema.pcStateManager == null) {
            abstractSchema.mandatoryCondition = string;
            return;
        }
        abstractSchema.pcStateManager.settingStringField((PersistenceCapable)abstractSchema, pcInheritedFieldCount + 3, abstractSchema.mandatoryCondition, string, 0);
    }

    private static final Integer pcGetmultivalue(AbstractSchema abstractSchema) {
        if (abstractSchema.pcStateManager == null) {
            return abstractSchema.multivalue;
        }
        int n = pcInheritedFieldCount + 4;
        abstractSchema.pcStateManager.accessingField(n);
        return abstractSchema.multivalue;
    }

    private static final void pcSetmultivalue(AbstractSchema abstractSchema, Integer n) {
        if (abstractSchema.pcStateManager == null) {
            abstractSchema.multivalue = n;
            return;
        }
        abstractSchema.pcStateManager.settingObjectField((PersistenceCapable)abstractSchema, pcInheritedFieldCount + 4, (Object)abstractSchema.multivalue, (Object)n, 0);
    }

    private static final String pcGetname(AbstractSchema abstractSchema) {
        if (abstractSchema.pcStateManager == null) {
            return abstractSchema.name;
        }
        int n = pcInheritedFieldCount + 5;
        abstractSchema.pcStateManager.accessingField(n);
        return abstractSchema.name;
    }

    private static final void pcSetname(AbstractSchema abstractSchema, String string) {
        if (abstractSchema.pcStateManager == null) {
            abstractSchema.name = string;
            return;
        }
        abstractSchema.pcStateManager.settingStringField((PersistenceCapable)abstractSchema, pcInheritedFieldCount + 5, abstractSchema.name, string, 0);
    }

    private static final Integer pcGetreadonly(AbstractSchema abstractSchema) {
        if (abstractSchema.pcStateManager == null) {
            return abstractSchema.readonly;
        }
        int n = pcInheritedFieldCount + 6;
        abstractSchema.pcStateManager.accessingField(n);
        return abstractSchema.readonly;
    }

    private static final void pcSetreadonly(AbstractSchema abstractSchema, Integer n) {
        if (abstractSchema.pcStateManager == null) {
            abstractSchema.readonly = n;
            return;
        }
        abstractSchema.pcStateManager.settingObjectField((PersistenceCapable)abstractSchema, pcInheritedFieldCount + 6, (Object)abstractSchema.readonly, (Object)n, 0);
    }

    private static final SchemaType pcGettype(AbstractSchema abstractSchema) {
        if (abstractSchema.pcStateManager == null) {
            return abstractSchema.type;
        }
        int n = pcInheritedFieldCount + 7;
        abstractSchema.pcStateManager.accessingField(n);
        return abstractSchema.type;
    }

    private static final void pcSettype(AbstractSchema abstractSchema, SchemaType schemaType) {
        if (abstractSchema.pcStateManager == null) {
            abstractSchema.type = schemaType;
            return;
        }
        abstractSchema.pcStateManager.settingObjectField((PersistenceCapable)abstractSchema, pcInheritedFieldCount + 7, (Object)abstractSchema.type, (Object)schemaType, 0);
    }

    private static final Integer pcGetuniqueConstraint(AbstractSchema abstractSchema) {
        if (abstractSchema.pcStateManager == null) {
            return abstractSchema.uniqueConstraint;
        }
        int n = pcInheritedFieldCount + 8;
        abstractSchema.pcStateManager.accessingField(n);
        return abstractSchema.uniqueConstraint;
    }

    private static final void pcSetuniqueConstraint(AbstractSchema abstractSchema, Integer n) {
        if (abstractSchema.pcStateManager == null) {
            abstractSchema.uniqueConstraint = n;
            return;
        }
        abstractSchema.pcStateManager.settingObjectField((PersistenceCapable)abstractSchema, pcInheritedFieldCount + 8, (Object)abstractSchema.uniqueConstraint, (Object)n, 0);
    }

    private static final String pcGetvalidatorClass(AbstractSchema abstractSchema) {
        if (abstractSchema.pcStateManager == null) {
            return abstractSchema.validatorClass;
        }
        int n = pcInheritedFieldCount + 9;
        abstractSchema.pcStateManager.accessingField(n);
        return abstractSchema.validatorClass;
    }

    private static final void pcSetvalidatorClass(AbstractSchema abstractSchema, String string) {
        if (abstractSchema.pcStateManager == null) {
            abstractSchema.validatorClass = string;
            return;
        }
        abstractSchema.pcStateManager.settingStringField((PersistenceCapable)abstractSchema, pcInheritedFieldCount + 9, abstractSchema.validatorClass, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

