/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.beans;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.syncope.client.SyncopeConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public abstract class AbstractBaseBean
implements Serializable {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractBaseBean.class);
    protected static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(SyncopeConstants.DEFAULT_DATE_PATTERN);
        }
    };
    protected static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat();
        }
    };
    private static final long serialVersionUID = -9017214159540857901L;

    public final SimpleDateFormat getDateFormatter() {
        SimpleDateFormat dateFormatter = DATE_FORMAT.get();
        dateFormatter.setLenient(false);
        return dateFormatter;
    }

    public final Boolean isBooleanAsInteger(Integer property) {
        return property != null && property == 1;
    }

    public final Integer getBooleanAsInteger(Boolean value) {
        return Boolean.TRUE.equals(value) ? 1 : 0;
    }

    private String[] getExcludeFields() {
        HashSet<String> excludeFields = new HashSet<String>();
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(this.getClass());
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            if (!propertyDescriptors[i].getPropertyType().isInstance(Collections.emptySet()) && !propertyDescriptors[i].getPropertyType().isInstance(Collections.emptyList())) continue;
            excludeFields.add(propertyDescriptors[i].getName());
        }
        return excludeFields.toArray(new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])this.getExcludeFields());
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])this.getExcludeFields());
    }

    public String toString() {
        StringBuffer result;
        block4: {
            Method method = BeanUtils.findMethod(this.getClass(), (String)"getId", (Class[])new Class[0]);
            if (method == null) {
                method = BeanUtils.findMethod(this.getClass(), (String)"getName", (Class[])new Class[0]);
            }
            result = new StringBuffer().append(this.getClass().getSimpleName()).append("[");
            if (method != null) {
                try {
                    result.append(method.invoke((Object)this, new Object[0]));
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.error("While serializing to string", (Throwable)e);
                }
            }
        }
        result.append("]");
        return result.toString();
    }
}

