/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.beans;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.core.persistence.beans.AbstractAttr;
import org.apache.syncope.core.persistence.beans.AbstractBaseBean;
import org.apache.syncope.core.persistence.beans.AbstractDerAttr;
import org.apache.syncope.core.persistence.beans.AbstractDerSchema;
import org.apache.syncope.core.persistence.beans.AbstractSchema;
import org.apache.syncope.core.persistence.beans.AbstractVirAttr;
import org.apache.syncope.core.persistence.beans.AbstractVirSchema;
import org.apache.syncope.core.persistence.beans.ExternalResource;

public abstract class AbstractAttributable
extends AbstractBaseBean {
    private static final long serialVersionUID = -4801685541488201119L;

    public <T extends AbstractAttr> T getAttribute(String schemaName) {
        AbstractAttr result = null;
        Iterator<? extends AbstractAttr> itor = this.getAttributes().iterator();
        while (result == null && itor.hasNext()) {
            AbstractAttr attribute = itor.next();
            if (attribute.getSchema() == null || !schemaName.equals(((AbstractSchema)attribute.getSchema()).getName())) continue;
            result = attribute;
        }
        return (T)result;
    }

    public <T extends AbstractDerAttr> T getDerivedAttribute(String derivedSchemaName) {
        AbstractDerAttr result = null;
        Iterator<? extends AbstractDerAttr> itor = this.getDerivedAttributes().iterator();
        while (result == null && itor.hasNext()) {
            AbstractDerAttr derivedAttribute = itor.next();
            if (derivedAttribute.getDerivedSchema() == null || !derivedSchemaName.equals(((AbstractDerSchema)derivedAttribute.getDerivedSchema()).getName())) continue;
            result = derivedAttribute;
        }
        return (T)result;
    }

    public <T extends AbstractVirAttr> T getVirtualAttribute(String virtualSchemaName) {
        AbstractVirAttr result = null;
        Iterator<? extends AbstractVirAttr> itor = this.getVirtualAttributes().iterator();
        while (result == null && itor.hasNext()) {
            AbstractVirAttr virtualAttribute = itor.next();
            if (virtualAttribute.getVirtualSchema() == null || !virtualSchemaName.equals(((AbstractVirSchema)virtualAttribute.getVirtualSchema()).getName())) continue;
            result = virtualAttribute;
        }
        return (T)result;
    }

    protected Map<AbstractSchema, AbstractAttr> getAttrMap() {
        HashMap<AbstractSchema, AbstractAttr> map = new HashMap<AbstractSchema, AbstractAttr>();
        for (AbstractAttr abstractAttr : this.getAttributes()) {
            map.put((AbstractSchema)abstractAttr.getSchema(), abstractAttr);
        }
        return map;
    }

    protected Map<AbstractDerSchema, AbstractDerAttr> getDerAttrMap() {
        HashMap<AbstractDerSchema, AbstractDerAttr> map = new HashMap<AbstractDerSchema, AbstractDerAttr>();
        for (AbstractDerAttr abstractDerAttr : this.getDerivedAttributes()) {
            map.put((AbstractDerSchema)abstractDerAttr.getDerivedSchema(), abstractDerAttr);
        }
        return map;
    }

    protected Map<AbstractVirSchema, AbstractVirAttr> getVirAttrMap() {
        HashMap<AbstractVirSchema, AbstractVirAttr> map = new HashMap<AbstractVirSchema, AbstractVirAttr>();
        for (AbstractVirAttr abstractVirAttr : this.getVirtualAttributes()) {
            map.put((AbstractVirSchema)abstractVirAttr.getVirtualSchema(), abstractVirAttr);
        }
        return map;
    }

    public abstract Long getId();

    public abstract <T extends AbstractAttr> boolean addAttribute(T var1);

    public abstract <T extends AbstractAttr> boolean removeAttribute(T var1);

    public abstract List<? extends AbstractAttr> getAttributes();

    public abstract void setAttributes(List<? extends AbstractAttr> var1);

    public abstract <T extends AbstractDerAttr> boolean addDerivedAttribute(T var1);

    public abstract <T extends AbstractDerAttr> boolean removeDerivedAttribute(T var1);

    public abstract List<? extends AbstractDerAttr> getDerivedAttributes();

    public abstract void setDerivedAttributes(List<? extends AbstractDerAttr> var1);

    public abstract <T extends AbstractVirAttr> boolean addVirtualAttribute(T var1);

    public abstract <T extends AbstractVirAttr> boolean removeVirtualAttribute(T var1);

    public abstract List<? extends AbstractVirAttr> getVirtualAttributes();

    public abstract void setVirtualAttributes(List<? extends AbstractVirAttr> var1);

    protected abstract Set<ExternalResource> resources();

    public boolean addResource(ExternalResource resource) {
        return this.resources().add(resource);
    }

    public boolean removeResource(ExternalResource resource) {
        return this.resources().remove(resource);
    }

    public Set<ExternalResource> getResources() {
        return this.resources();
    }

    public Set<String> getResourceNames() {
        Set<ExternalResource> ownResources = this.getResources();
        HashSet<String> result = new HashSet<String>(ownResources.size());
        for (ExternalResource resource : ownResources) {
            result.add(resource.getName());
        }
        return result;
    }

    public void setResources(Set<ExternalResource> resources) {
        this.resources().clear();
        if (resources != null) {
            this.resources().addAll(resources);
        }
    }
}

