/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.notification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javassist.NotFoundException;
import org.apache.syncope.core.persistence.beans.Notification;
import org.apache.syncope.core.persistence.beans.NotificationTask;
import org.apache.syncope.core.persistence.beans.SyncopeConf;
import org.apache.syncope.core.persistence.beans.TaskExec;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.beans.user.UAttr;
import org.apache.syncope.core.persistence.beans.user.UDerAttr;
import org.apache.syncope.core.persistence.beans.user.UVirAttr;
import org.apache.syncope.core.persistence.dao.ConfDAO;
import org.apache.syncope.core.persistence.dao.EntitlementDAO;
import org.apache.syncope.core.persistence.dao.NotificationDAO;
import org.apache.syncope.core.persistence.dao.TaskDAO;
import org.apache.syncope.core.persistence.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.apache.syncope.core.persistence.dao.UserSearchDAO;
import org.apache.syncope.core.rest.data.UserDataBinder;
import org.apache.syncope.core.scheduling.NotificationJob;
import org.apache.syncope.core.util.ConnObjectUtil;
import org.apache.syncope.core.util.EntitlementUtil;
import org.apache.syncope.core.workflow.WorkflowResult;
import org.apache.syncope.types.IntMappingType;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.velocity.VelocityEngineUtils;

@Transactional(rollbackFor={Throwable.class})
public class NotificationManager {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationManager.class);
    @Autowired
    private NotificationDAO notificationDAO;
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private UserDataBinder userDataBinder;
    @Autowired
    private UserSearchDAO searchDAO;
    @Autowired
    private TaskDAO taskDAO;
    @Autowired
    private TaskExecDAO taskExecDAO;
    @Autowired
    private VelocityEngine velocityEngine;
    @Autowired
    private NotificationJob notificationJob;
    @Autowired
    private EntitlementDAO entitlementDAO;
    @Autowired
    private ConnObjectUtil connObjectUtil;

    private NotificationTask getNotificationTask(Notification notification, SyncopeUser user) {
        String textBody;
        String htmlBody;
        this.connObjectUtil.retrieveVirAttrValues(user);
        ArrayList<SyncopeUser> recipients = new ArrayList<SyncopeUser>();
        if (notification.getRecipients() != null) {
            recipients.addAll(this.searchDAO.search(EntitlementUtil.getRoleIds(this.entitlementDAO.findAll()), notification.getRecipients()));
        }
        if (notification.isSelfAsRecipient()) {
            recipients.add(user);
        }
        HashSet<String> recipientEmails = new HashSet<String>();
        for (SyncopeUser recipient : recipients) {
            this.connObjectUtil.retrieveVirAttrValues(recipient);
            String email = this.getRecipientEmail(notification.getRecipientAttrType(), notification.getRecipientAttrName(), recipient);
            if (email == null) {
                LOG.warn("{} cannot be notified: {} not found", (Object)recipient, (Object)notification.getRecipientAttrName());
                continue;
            }
            recipientEmails.add(email);
        }
        NotificationTask task = new NotificationTask();
        task.setTraceLevel(notification.getTraceLevel());
        task.setRecipients(recipientEmails);
        task.setSender(notification.getSender());
        task.setSubject(notification.getSubject());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("user", this.userDataBinder.getUserTO(user));
        model.put("syncopeConf", this.findAllSyncopeConfs());
        try {
            htmlBody = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)("mailTemplates/" + notification.getTemplate() + ".html.vm"), (String)"UTF-8", model);
            textBody = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)("mailTemplates/" + notification.getTemplate() + ".txt.vm"), (String)"UTF-8", model);
        }
        catch (VelocityException e) {
            LOG.error("Could not get mail body", (Throwable)e);
            htmlBody = "";
            textBody = "";
        }
        task.setTextBody(textBody);
        task.setHtmlBody(htmlBody);
        return task;
    }

    public void createTasks(WorkflowResult<Long> wfResult) throws NotFoundException {
        SyncopeUser user = this.userDAO.find(wfResult.getResult());
        if (user == null) {
            throw new NotFoundException("User " + wfResult.getResult());
        }
        for (Notification notification : this.notificationDAO.findAll()) {
            if (!this.searchDAO.matches(user, notification.getAbout())) continue;
            HashSet<String> events = new HashSet<String>(notification.getEvents());
            events.retainAll(wfResult.getPerformedTasks());
            if (!events.isEmpty()) {
                LOG.debug("Creating notification task for events {} about {}", events, (Object)user);
                this.taskDAO.save(this.getNotificationTask(notification, user));
                continue;
            }
            LOG.debug("No events found about {}", (Object)user);
        }
    }

    public TaskExec execute(NotificationTask task) {
        return this.notificationJob.executeSingle(task);
    }

    private String getRecipientEmail(IntMappingType recipientAttrType, String recipientAttrName, SyncopeUser user) {
        String email;
        switch (recipientAttrType) {
            case Username: {
                email = user.getUsername();
                break;
            }
            case UserSchema: {
                UAttr attr = (UAttr)user.getAttribute(recipientAttrName);
                email = attr == null || attr.getValuesAsStrings().isEmpty() ? null : attr.getValuesAsStrings().get(0);
                break;
            }
            case UserVirtualSchema: {
                UVirAttr virAttr = (UVirAttr)user.getVirtualAttribute(recipientAttrName);
                email = virAttr == null || virAttr.getValues().isEmpty() ? null : virAttr.getValues().get(0);
                break;
            }
            case UserDerivedSchema: {
                UDerAttr derAttr = (UDerAttr)user.getDerivedAttribute(recipientAttrName);
                email = derAttr == null ? null : derAttr.getValue(user.getAttributes());
                break;
            }
            default: {
                email = null;
            }
        }
        return email;
    }

    public TaskExec storeExec(TaskExec execution) {
        NotificationTask task = (NotificationTask)this.taskDAO.find(execution.getTask().getId());
        task.addExec(execution);
        task.setExecuted(true);
        task = this.taskDAO.save(task);
        return task.getExecs().get(0);
    }

    public void setTaskExecuted(Long taskId) {
        NotificationTask task = (NotificationTask)this.taskDAO.find(taskId);
        task.setExecuted(true);
        this.taskDAO.save(task);
    }

    public Map<String, String> findAllSyncopeConfs() {
        HashMap<String, String> syncopeConfMap = new HashMap<String, String>();
        for (SyncopeConf conf : this.confDAO.findAll()) {
            syncopeConfMap.put(conf.getKey(), conf.getValue());
        }
        return syncopeConfMap;
    }
}

