/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.init;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.util.HashMap;
import org.apache.syncope.core.persistence.beans.SyncopeLogger;
import org.apache.syncope.core.persistence.dao.LoggerDAO;
import org.apache.syncope.types.SyncopeLoggerLevel;
import org.apache.syncope.types.SyncopeLoggerType;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LoggerLoader {
    @Autowired
    private LoggerDAO loggerDAO;

    @Transactional
    public void load() {
        HashMap<String, SyncopeLogger> loggerLogs = new HashMap<String, SyncopeLogger>();
        for (SyncopeLogger syncopeLogger : this.loggerDAO.findAll(SyncopeLoggerType.LOG)) {
            loggerLogs.put(syncopeLogger.getName(), syncopeLogger);
        }
        for (SyncopeLogger syncopeLogger : this.loggerDAO.findAll(SyncopeLoggerType.AUDIT)) {
            loggerLogs.put(syncopeLogger.getName(), syncopeLogger);
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (Logger logger : lc.getLoggerList()) {
            if (logger.getLevel() == null) continue;
            if (loggerLogs.containsKey(logger.getName())) {
                logger.setLevel(((SyncopeLogger)loggerLogs.get(logger.getName())).getLevel().getLevel());
                loggerLogs.remove(logger.getName());
                continue;
            }
            if (logger.getName().equals(SyncopeLoggerType.AUDIT.getPrefix())) continue;
            SyncopeLogger syncopeLogger = new SyncopeLogger();
            syncopeLogger.setName(logger.getName());
            syncopeLogger.setLevel(SyncopeLoggerLevel.fromLevel((Level)logger.getLevel()));
            syncopeLogger.setType(logger.getName().startsWith(SyncopeLoggerType.AUDIT.getPrefix()) ? SyncopeLoggerType.AUDIT : SyncopeLoggerType.LOG);
            this.loggerDAO.save(syncopeLogger);
        }
        for (SyncopeLogger syncopeLogger : loggerLogs.values()) {
            Logger logger = lc.getLogger(syncopeLogger.getName());
            logger.setLevel(syncopeLogger.getLevel().getLevel());
        }
    }
}

