/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.init;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.syncope.core.persistence.beans.Report;
import org.apache.syncope.core.persistence.beans.SchedTask;
import org.apache.syncope.core.persistence.beans.SyncTask;
import org.apache.syncope.core.persistence.beans.Task;
import org.apache.syncope.core.persistence.dao.ReportDAO;
import org.apache.syncope.core.persistence.dao.TaskDAO;
import org.apache.syncope.core.scheduling.AbstractTaskJob;
import org.apache.syncope.core.scheduling.DefaultSyncJobActions;
import org.apache.syncope.core.scheduling.NotificationJob;
import org.apache.syncope.core.scheduling.ReportJob;
import org.apache.syncope.core.scheduling.SyncJob;
import org.apache.syncope.core.scheduling.SyncJobActions;
import org.apache.syncope.core.util.ApplicationContextProvider;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.scheduling.quartz.CronTriggerBean;
import org.springframework.scheduling.quartz.JobDetailBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class JobInstanceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JobInstanceLoader.class);
    @Autowired
    private SchedulerFactoryBean scheduler;
    @Autowired
    private TaskDAO taskDAO;
    @Autowired
    private ReportDAO reportDAO;

    private DefaultListableBeanFactory getBeanFactory() {
        ConfigurableApplicationContext context = ApplicationContextProvider.getApplicationContext();
        return (DefaultListableBeanFactory)context.getBeanFactory();
    }

    private static Long getIdFromJobName(String name, String pattern, int prefixLength) {
        Long result = null;
        Matcher jobMatcher = Pattern.compile(pattern).matcher(name);
        if (jobMatcher.matches()) {
            try {
                result = Long.valueOf(name.substring(prefixLength));
            }
            catch (NumberFormatException e) {
                LOG.error("Unparsable id: {}", (Object)name.substring(prefixLength), (Object)e);
            }
        }
        return result;
    }

    public static Long getTaskIdFromJobName(String name) {
        return JobInstanceLoader.getIdFromJobName("taskJob[0-9]+", name, 7);
    }

    public static Long getReportIdFromJobName(String name) {
        return JobInstanceLoader.getIdFromJobName("reportJob[0-9]+", name, 9);
    }

    public static String getJobName(Task task) {
        return task == null ? "taskNotificationJob" : "taskJob" + task.getId();
    }

    public static String getJobName(Report report) {
        return "reportJob" + report.getId();
    }

    public static String getTriggerName(String jobName) {
        return "Trigger_" + jobName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerJob(String jobName, Job jobInstance, String cronExpression) throws Exception {
        Scheduler scheduler = this.scheduler.getScheduler();
        synchronized (scheduler) {
            boolean jobAlreadyRunning = false;
            for (JobExecutionContext jobCtx : this.scheduler.getScheduler().getCurrentlyExecutingJobs()) {
                if (!jobName.equals(jobCtx.getJobDetail().getName()) || !"DEFAULT".equals(jobCtx.getJobDetail().getGroup())) continue;
                jobAlreadyRunning = true;
                LOG.debug("Job {} already running, cancel", (Object)jobCtx.getJobDetail().getFullName());
            }
            if (jobAlreadyRunning) {
                return;
            }
        }
        this.unregisterJob(jobName);
        this.getBeanFactory().registerSingleton(jobName, (Object)jobInstance);
        JobDetailBean jobDetail = new JobDetailBean();
        jobDetail.setName(jobName);
        jobDetail.setGroup("DEFAULT");
        jobDetail.setJobClass(jobInstance.getClass());
        if (cronExpression == null) {
            this.scheduler.getScheduler().addJob((JobDetail)jobDetail, true);
        } else {
            CronTriggerBean cronTrigger = new CronTriggerBean();
            cronTrigger.setName(JobInstanceLoader.getTriggerName(jobName));
            cronTrigger.setCronExpression(cronExpression);
            this.scheduler.getScheduler().scheduleJob((JobDetail)jobDetail, (Trigger)cronTrigger);
        }
    }

    public void registerJob(Task task, String jobClassName, String cronExpression) throws Exception {
        Class<?> jobClass = Class.forName(jobClassName);
        Job jobInstance = (Job)this.getBeanFactory().createBean(jobClass, 2, false);
        if (jobInstance instanceof AbstractTaskJob) {
            ((AbstractTaskJob)jobInstance).setTaskId(task.getId());
        }
        if (jobInstance instanceof SyncJob && task instanceof SyncTask) {
            String jobActionsClassName = ((SyncTask)task).getJobActionsClassName();
            Class syncJobActionsClass = DefaultSyncJobActions.class;
            if (StringUtils.isNotBlank((String)jobActionsClassName)) {
                try {
                    syncJobActionsClass = Class.forName(jobActionsClassName);
                }
                catch (Exception e) {
                    LOG.error("Class {} not found, reverting to {}", new Object[]{jobActionsClassName, syncJobActionsClass.getName(), e});
                }
            }
            SyncJobActions syncJobActions = (SyncJobActions)this.getBeanFactory().createBean(syncJobActionsClass, 2, true);
            ((SyncJob)jobInstance).setActions(syncJobActions);
        }
        this.registerJob(JobInstanceLoader.getJobName(task), jobInstance, cronExpression);
    }

    public void registerJob(Report report) throws Exception {
        Job jobInstance = (Job)this.getBeanFactory().createBean(ReportJob.class, 2, false);
        ((ReportJob)jobInstance).setReportId(report.getId());
        this.registerJob(JobInstanceLoader.getJobName(report), jobInstance, report.getCronExpression());
    }

    private void unregisterJob(String jobName) {
        try {
            this.scheduler.getScheduler().unscheduleJob(jobName, "DEFAULT");
            this.scheduler.getScheduler().deleteJob(jobName, "DEFAULT");
        }
        catch (SchedulerException e) {
            LOG.error("Could not remove job " + jobName, (Throwable)e);
        }
        if (this.getBeanFactory().containsSingleton(jobName)) {
            this.getBeanFactory().destroySingleton(jobName);
        }
    }

    public void unregisterJob(Task task) {
        this.unregisterJob(JobInstanceLoader.getJobName(task));
    }

    public void unregisterJob(Report report) {
        this.unregisterJob(JobInstanceLoader.getJobName(report));
    }

    @Transactional(readOnly=true)
    public void load() {
        HashSet<SchedTask> tasks = new HashSet<SchedTask>(this.taskDAO.findAll(SchedTask.class));
        tasks.addAll(this.taskDAO.findAll(SyncTask.class));
        for (SchedTask task : tasks) {
            try {
                this.registerJob(task, task.getJobClassName(), task.getCronExpression());
            }
            catch (Exception e) {
                LOG.error("While loading job instance for task " + task.getId(), (Throwable)e);
            }
        }
        try {
            this.registerJob(null, NotificationJob.class.getName(), "0 0/2 * * * ?");
        }
        catch (Exception e) {
            LOG.error("While loading NotificationJob instance", (Throwable)e);
        }
        for (Report report : this.reportDAO.findAll()) {
            try {
                this.registerJob(report);
            }
            catch (Exception e) {
                LOG.error("While loading job instance for report " + report.getName(), (Throwable)e);
            }
        }
    }
}

