/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.init;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.core.persistence.validation.attrvalue.Validator;
import org.apache.syncope.core.report.Reportlet;
import org.apache.syncope.core.scheduling.NotificationJob;
import org.apache.syncope.core.scheduling.ReportJob;
import org.apache.syncope.core.scheduling.SyncJob;
import org.apache.syncope.core.scheduling.SyncJobActions;
import org.quartz.Job;
import org.quartz.StatefulJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class ImplementationClassNamesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ImplementationClassNamesLoader.class);
    @Autowired
    private ResourcePatternResolver resResolver;
    private Map<Type, Set<String>> classNames;

    public void load() {
        CachingMetadataReaderFactory factory = new CachingMetadataReaderFactory();
        this.classNames = new EnumMap<Type, Set<String>>(Type.class);
        for (Type type : Type.values()) {
            this.classNames.put(type, new HashSet());
        }
        try {
            for (Type type : this.resResolver.getResources("classpath*:**/*.class")) {
                ClassMetadata metadata = factory.getMetadataReader((Resource)type).getClassMetadata();
                try {
                    Class clazz = ClassUtils.forName((String)metadata.getClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
                    Set interfaces = ClassUtils.getAllInterfacesForClassAsSet((Class)clazz);
                    if (interfaces.contains(Reportlet.class) && !metadata.isAbstract()) {
                        this.classNames.get((Object)Type.REPORTLET).add(clazz.getName());
                    }
                    if (!(!interfaces.contains(Job.class) && !interfaces.contains(StatefulJob.class) || metadata.isAbstract() || SyncJob.class.getName().equals(metadata.getClassName()) || ReportJob.class.getName().equals(metadata.getClassName()) || NotificationJob.class.getName().equals(metadata.getClassName()))) {
                        this.classNames.get((Object)Type.JOB).add(metadata.getClassName());
                    }
                    if (interfaces.contains(SyncJobActions.class) && !metadata.isAbstract()) {
                        this.classNames.get((Object)Type.JOB_ACTIONS).add(metadata.getClassName());
                    }
                    if (!interfaces.contains(Validator.class) || metadata.isAbstract()) continue;
                    this.classNames.get((Object)Type.VALIDATOR).add(metadata.getClassName());
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("Could not load class {}", (Object)metadata.getClassName());
                }
                catch (LinkageError e) {
                    LOG.warn("Could not link class {}", (Object)metadata.getClassName());
                }
            }
        }
        catch (IOException e) {
            LOG.error("While searching for class implementing {}", (Object)Reportlet.class.getName(), (Object)e);
        }
        this.classNames = Collections.unmodifiableMap(this.classNames);
        LOG.debug("Implementation classes found: {}", this.classNames);
    }

    public Set<String> getClassNames(Type type) {
        return this.classNames.get((Object)type);
    }

    public static enum Type {
        REPORTLET,
        JOB,
        JOB_ACTIONS,
        VALIDATOR;

    }
}

