/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.init;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.syncope.core.persistence.beans.SyncopeConf;
import org.apache.syncope.core.util.ImportExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.xml.sax.helpers.DefaultHandler;

@Component
public class ContentLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ContentLoader.class);
    @Autowired
    private DataSource dataSource;
    @Autowired
    private ImportExport importExport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void load() {
        Connection conn = DataSourceUtils.getConnection((DataSource)this.dataSource);
        Statement statement = null;
        ResultSet resultSet = null;
        boolean existingData = false;
        try {
            String queryContent = "SELECT * FROM " + SyncopeConf.class.getSimpleName();
            statement = conn.prepareStatement(queryContent, 1005, 1007);
            resultSet = statement.executeQuery();
            resultSet.last();
            existingData = resultSet.getRow() > 0;
        }
        catch (SQLException e) {
            LOG.error("Could not access to table " + SyncopeConf.class.getSimpleName(), (Throwable)e);
            existingData = true;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                LOG.error("While closing SQL result set", (Throwable)e);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                LOG.error("While closing SQL statement", (Throwable)e);
            }
        }
        if (existingData) {
            LOG.info("Data found in the database, leaving untouched");
            return;
        }
        LOG.info("Empty database found, loading default content");
        LOG.debug("Creating views");
        try {
            InputStream viewsStream = this.getClass().getResourceAsStream("/views.xml");
            Properties views = new Properties();
            views.loadFromXML(viewsStream);
            for (String idx : views.stringPropertyNames()) {
                LOG.debug("Creating view {}", (Object)views.get(idx).toString());
                try {
                    String updateViews = views.get(idx).toString().replaceAll("\\n", " ");
                    statement = conn.prepareStatement(updateViews);
                    statement.executeUpdate();
                }
                catch (SQLException e) {
                    LOG.error("Could not create view ", (Throwable)e);
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
            LOG.debug("Views created, go for indexes");
        }
        catch (Exception e) {
            LOG.error("While creating views", (Throwable)e);
        }
        LOG.debug("Creating indexes");
        try {
            InputStream indexesStream = this.getClass().getResourceAsStream("/indexes.xml");
            Properties indexes = new Properties();
            indexes.loadFromXML(indexesStream);
            for (String idx : indexes.stringPropertyNames()) {
                LOG.debug("Creating index {}", (Object)indexes.get(idx).toString());
                try {
                    String updateIndexed = indexes.get(idx).toString();
                    statement = conn.prepareStatement(updateIndexed);
                    statement.executeUpdate();
                }
                catch (SQLException e) {
                    LOG.error("Could not create index ", (Throwable)e);
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
            LOG.debug("Indexes created, go for default content");
        }
        catch (Exception e) {
            LOG.error("While creating indexes", (Throwable)e);
        }
        try {
            statement = conn.prepareStatement("DELETE FROM ACT_GE_PROPERTY");
            statement.executeUpdate();
        }
        catch (SQLException e) {
            LOG.error("Error during ACT_GE_PROPERTY delete rows", (Throwable)e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.error("Error closing statement of ACT_GE_PROPERTY delete rows", (Throwable)e);
                }
            }
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            LOG.error("While closing SQL connection", (Throwable)e);
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)conn, (DataSource)this.dataSource);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(this.getClass().getResourceAsStream("/content.xml"), (DefaultHandler)this.importExport);
            LOG.debug("Default content successfully loaded");
        }
        catch (Exception e) {
            LOG.error("While loading default content", (Throwable)e);
        }
    }
}

