/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.init;

import java.io.Serializable;
import java.util.Locale;
import java.util.Set;
import javassist.NotFoundException;
import org.apache.commons.lang.SerializationUtils;
import org.apache.syncope.core.persistence.beans.ConnInstance;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.dao.ResourceDAO;
import org.apache.syncope.core.propagation.ConnectorFacadeProxy;
import org.apache.syncope.core.rest.data.ResourceDataBinder;
import org.apache.syncope.core.util.ApplicationContextProvider;
import org.apache.syncope.core.util.ConnBundleManager;
import org.apache.syncope.types.ConnConfProperty;
import org.identityconnectors.common.l10n.CurrentLocale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ConnInstanceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ConnInstanceLoader.class);
    @Autowired
    private ResourceDAO resourceDAO;
    @Autowired
    private ConnBundleManager connBundleManager;
    @Autowired
    private ResourceDataBinder resourceDataBinder;

    private DefaultListableBeanFactory getBeanFactory() {
        ConfigurableApplicationContext context = ApplicationContextProvider.getApplicationContext();
        return (DefaultListableBeanFactory)context.getBeanFactory();
    }

    private String getBeanName(ExternalResource resource) {
        return String.format("connInstance-%d-%s", resource.getConnector().getId(), resource.getName());
    }

    public ConnectorFacadeProxy getConnector(ExternalResource resource) throws BeansException, NotFoundException {
        if (!this.getBeanFactory().containsBean(this.getBeanName(resource))) {
            this.registerConnector(resource);
        }
        return (ConnectorFacadeProxy)this.getBeanFactory().getBean(this.getBeanName(resource));
    }

    public ConnectorFacadeProxy createConnectorBean(ExternalResource resource) throws NotFoundException {
        ConnInstance connInstanceClone = this.resourceDataBinder.getConnInstance(resource);
        return this.createConnectorBean(resource.getConnector(), connInstanceClone.getConfiguration());
    }

    public ConnectorFacadeProxy createConnectorBean(ConnInstance connInstance, Set<ConnConfProperty> configuration) throws NotFoundException {
        ConnInstance connInstanceClone = (ConnInstance)SerializationUtils.clone((Serializable)connInstance);
        connInstanceClone.setConfiguration(configuration);
        return new ConnectorFacadeProxy(connInstanceClone, this.connBundleManager);
    }

    public void registerConnector(ExternalResource resource) throws NotFoundException {
        ConnectorFacadeProxy connector = this.createConnectorBean(resource);
        LOG.debug("Connector to be registered: {}", (Object)connector);
        String beanName = this.getBeanName(resource);
        if (this.getBeanFactory().containsSingleton(beanName)) {
            this.unregisterConnector(beanName);
        }
        this.getBeanFactory().registerSingleton(beanName, (Object)connector);
        LOG.debug("Successfully registered bean {}", (Object)beanName);
    }

    public void unregisterConnector(String id) {
        this.getBeanFactory().destroySingleton(id);
    }

    @Transactional(readOnly=true)
    public void load() {
        CurrentLocale.set((Locale)Locale.ENGLISH);
        for (ExternalResource resource : this.resourceDAO.findAll()) {
            try {
                LOG.info("Registering resource-connector pair {}-{}", (Object)resource, (Object)resource.getConnector());
                this.registerConnector(resource);
            }
            catch (Exception e) {
                LOG.error("While registering resource-connector pair {}-{}", new Object[]{resource, resource.getConnector(), e});
            }
        }
        LOG.info("Done loading {} connectors.", (Object)this.getBeanFactory().getBeansOfType(ConnectorFacadeProxy.class).size());
    }
}

