/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.init;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.activiti.engine.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivitiWorkflowLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ActivitiWorkflowLoader.class);
    @Autowired
    private RepositoryService repositoryService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        List processes = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("userWorkflow").list();
        LOG.debug("userWorkflow Activiti processes in repository: {}", (Object)processes);
        if (processes.isEmpty()) {
            InputStream wfDefinitionStream = null;
            try {
                wfDefinitionStream = this.getClass().getResourceAsStream("/userWorkflow.bpmn20.xml");
                this.repositoryService.createDeployment().addInputStream("userWorkflow.bpmn20.xml", wfDefinitionStream).deploy();
            }
            finally {
                if (wfDefinitionStream != null) {
                    try {
                        wfDefinitionStream.close();
                    }
                    catch (IOException e) {
                        LOG.error("While closing input stream for {}", (Object)"userWorkflow.bpmn20.xml", (Object)e);
                    }
                }
            }
        }
    }
}

