/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.connid;

import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.logging.LogSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JLogger
implements LogSpi {
    private static final Logger LOG = LoggerFactory.getLogger(SLF4JLogger.class);

    public final void log(Class<?> clazz, String method, Log.Level level, String message, Throwable ex) {
        StringBuilder logMessage = new StringBuilder();
        logMessage.append(clazz.getName());
        logMessage.append('.');
        logMessage.append(method);
        logMessage.append(' ');
        logMessage.append(message);
        switch (level) {
            case ERROR: {
                if (ex != null) {
                    LOG.error(logMessage.toString(), ex);
                    break;
                }
                LOG.error(logMessage.toString());
                break;
            }
            case INFO: {
                if (ex != null) {
                    LOG.info(logMessage.toString(), ex);
                    break;
                }
                LOG.info(logMessage.toString());
                break;
            }
            case OK: {
                if (ex != null) {
                    LOG.debug(logMessage.toString(), ex);
                    break;
                }
                LOG.debug(logMessage.toString());
                break;
            }
            case WARN: {
                if (ex != null) {
                    LOG.warn(logMessage.toString(), ex);
                    break;
                }
                LOG.warn(logMessage.toString());
                break;
            }
        }
    }

    public final boolean isLoggable(Class<?> clazz, Log.Level level) {
        boolean loggable;
        switch (level) {
            case ERROR: {
                loggable = LOG.isErrorEnabled();
                break;
            }
            case INFO: {
                loggable = LOG.isInfoEnabled();
                break;
            }
            case OK: {
                loggable = LOG.isDebugEnabled();
                break;
            }
            case WARN: {
                loggable = LOG.isWarnEnabled();
                break;
            }
            default: {
                loggable = false;
            }
        }
        return loggable;
    }
}

