/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.audit;

import ch.qos.logback.core.db.ConnectionSource;
import ch.qos.logback.core.db.ConnectionSourceBase;
import ch.qos.logback.core.db.DataSourceConnectionSource;
import ch.qos.logback.core.db.JNDIConnectionSource;
import ch.qos.logback.core.db.dialect.SQLDialectCode;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.sql.DataSource;

public class JNDIFallbackConnectionSource
extends ContextAwareBase
implements ConnectionSource {
    private String jndiLocation;
    private DataSource dataSource;
    private ConnectionSourceBase delegate;

    public String getJndiLocation() {
        return this.jndiLocation;
    }

    public void setJndiLocation(String jndiLocation) {
        this.jndiLocation = jndiLocation;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void chooseDelegate() {
        if (this.delegate != null) {
            return;
        }
        JNDIConnectionSource jndiCS = new JNDIConnectionSource();
        jndiCS.setJndiLocation(this.jndiLocation);
        try {
            InitialContext ctx = new InitialContext();
            Object obj = ctx.lookup(jndiCS.getJndiLocation());
            PortableRemoteObject.narrow((Object)obj, DataSource.class);
            this.delegate = jndiCS;
            this.addInfo("DataSource obtained from " + this.jndiLocation);
        }
        catch (NamingException e) {
            this.addError("During lookup of " + this.jndiLocation);
        }
        catch (ClassCastException e) {
            this.addError("Object at " + this.jndiLocation + " does not seem to be a DataSource instance", e);
        }
        if (this.delegate == null) {
            this.addInfo("Could not obtain DataSource via JNDI");
            DataSourceConnectionSource dataSourceCS = new DataSourceConnectionSource();
            dataSourceCS.setDataSource(this.dataSource);
            Connection conn = null;
            try {
                conn = dataSourceCS.getConnection();
                this.delegate = dataSourceCS;
                this.addInfo("Provided DataSource successfully reported");
            }
            catch (SQLException e) {
                this.addError("While trying to get connection from DataSource " + this.dataSource, e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sqle) {
                        this.addError("Could not close connection", sqle);
                    }
                }
            }
        }
        if (this.delegate != null) {
            this.delegate.setContext(this.context);
        }
    }

    public boolean isStarted() {
        this.chooseDelegate();
        return this.delegate.isStarted();
    }

    public void start() {
        this.chooseDelegate();
        this.delegate.start();
    }

    public void stop() {
        this.chooseDelegate();
        this.delegate.stop();
    }

    public Connection getConnection() throws SQLException {
        this.chooseDelegate();
        return this.delegate.getConnection();
    }

    public SQLDialectCode getSQLDialectCode() {
        this.chooseDelegate();
        return this.delegate.getSQLDialectCode();
    }

    public boolean supportsGetGeneratedKeys() {
        this.chooseDelegate();
        return this.delegate.supportsGetGeneratedKeys();
    }

    public boolean supportsBatchUpdates() {
        this.chooseDelegate();
        return this.delegate.supportsBatchUpdates();
    }
}

