/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.audit;

import org.apache.syncope.types.AuditElements;
import org.apache.syncope.types.AuditLoggerName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuditManager {
    private static final Logger LOG = LoggerFactory.getLogger(AuditManager.class);

    public void audit(AuditElements.Category category, Enum<?> subcategory, AuditElements.Result result, String message) {
        this.audit(category, subcategory, result, message, null);
    }

    public void audit(AuditElements.Category category, Enum<?> subcategory, AuditElements.Result result, String message, Throwable throwable) {
        AuditLoggerName auditLoggerName = null;
        try {
            auditLoggerName = new AuditLoggerName(category, subcategory, result);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Invalid audit parameters, aborting...", (Throwable)e);
        }
        if (auditLoggerName != null) {
            StringBuilder auditMessage = new StringBuilder();
            SecurityContext ctx = SecurityContextHolder.getContext();
            if (ctx != null && ctx.getAuthentication() != null) {
                auditMessage.append('[').append(ctx.getAuthentication().getName()).append(']').append(' ');
            }
            auditMessage.append(message);
            Logger logger = LoggerFactory.getLogger((String)auditLoggerName.toLoggerName());
            if (throwable == null) {
                logger.debug(auditMessage.toString());
            } else {
                logger.debug(auditMessage.toString(), throwable);
            }
        }
    }
}

