/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.securevault.secret.repository;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.securevault.BaseCipher;
import org.apache.synapse.securevault.CipherFactory;
import org.apache.synapse.securevault.CipherOperationMode;
import org.apache.synapse.securevault.EncodingType;
import org.apache.synapse.securevault.commons.MiscellaneousUtil;
import org.apache.synapse.securevault.definition.CipherInformation;
import org.apache.synapse.securevault.keystore.IdentityKeyStoreWrapper;
import org.apache.synapse.securevault.keystore.KeyStoreWrapper;
import org.apache.synapse.securevault.keystore.TrustKeyStoreWrapper;
import org.apache.synapse.securevault.secret.SecretRepository;

public class FileBaseSecretRepository
implements SecretRepository {
    private static Log log = LogFactory.getLog(FileBaseSecretRepository.class);
    private static final String LOCATION = "location";
    private static final String KEY_STORE = "keyStore";
    private static final String DOT = ".";
    private static final String SECRET = "secret";
    private static final String ALIAS = "alias";
    private static final String ALIASES = "aliases";
    private static final String ALGORITHM = "algorithm";
    private static final String DEFAULT_ALGORITHM = "RSA";
    private static final String TRUSTED = "trusted";
    private static final String DEFAULT_CONF_LOCATION = "cipher-text.properties";
    private SecretRepository parentRepository;
    private final Map<String, String> secrets = new HashMap<String, String>();
    private final Map<String, String> encryptedData = new HashMap<String, String>();
    private IdentityKeyStoreWrapper identity;
    private TrustKeyStoreWrapper trust;
    private boolean initialize = false;

    public FileBaseSecretRepository(IdentityKeyStoreWrapper identity, TrustKeyStoreWrapper trust) {
        this.identity = identity;
        this.trust = trust;
    }

    @Override
    public void init(Properties properties, String id) {
        StringBuffer sb = new StringBuffer();
        sb.append(id);
        sb.append(DOT);
        sb.append(LOCATION);
        String filePath = MiscellaneousUtil.getProperty(properties, sb.toString(), DEFAULT_CONF_LOCATION);
        Properties cipherProperties = MiscellaneousUtil.loadProperties(filePath);
        if (cipherProperties.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cipher texts cannot be loaded form : " + filePath));
            }
            return;
        }
        StringBuffer sbTwo = new StringBuffer();
        sbTwo.append(id);
        sbTwo.append(DOT);
        sbTwo.append(ALGORITHM);
        String algorithm = MiscellaneousUtil.getProperty(properties, sbTwo.toString(), DEFAULT_ALGORITHM);
        StringBuffer buffer = new StringBuffer();
        buffer.append(DOT);
        buffer.append(KEY_STORE);
        String keyStore = MiscellaneousUtil.getProperty(properties, buffer.toString(), null);
        KeyStoreWrapper keyStoreWrapper = TRUSTED.equals(keyStore) ? this.trust : this.identity;
        CipherInformation cipherInformation = new CipherInformation();
        cipherInformation.setAlgorithm(algorithm);
        cipherInformation.setCipherOperationMode(CipherOperationMode.DECRYPT);
        cipherInformation.setInType(EncodingType.BASE64);
        BaseCipher baseCipher = CipherFactory.createCipher(cipherInformation, keyStoreWrapper);
        for (Object alias : cipherProperties.keySet()) {
            String key = String.valueOf(alias);
            String encryptedText = cipherProperties.getProperty(key);
            this.encryptedData.put(key, encryptedText);
            if (encryptedText == null || "".equals(encryptedText.trim())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("There is no secret for the alias : " + alias));
                continue;
            }
            String decryptedText = new String(baseCipher.decrypt(encryptedText.trim().getBytes()));
            this.secrets.put(key, decryptedText);
        }
        this.initialize = true;
    }

    @Override
    public String getSecret(String alias) {
        if (alias == null || "".equals(alias)) {
            return alias;
        }
        if (!this.initialize || this.secrets.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no secret found for alias '" + alias + "' returning itself"));
            }
            return alias;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(alias);
        String secret = this.secrets.get(sb.toString());
        if (secret == null || "".equals(secret)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no secret found for alias '" + alias + "' returning itself"));
            }
            return alias;
        }
        return secret;
    }

    @Override
    public String getEncryptedData(String alias) {
        if (alias == null || "".equals(alias)) {
            return alias;
        }
        if (!this.initialize || this.encryptedData.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no secret found for alias '" + alias + "' returning itself"));
            }
            return alias;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(alias);
        String encryptedValue = this.encryptedData.get(sb.toString());
        if (encryptedValue == null || "".equals(encryptedValue)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no secret found for alias '" + alias + "' returning itself"));
            }
            return alias;
        }
        return encryptedValue;
    }

    @Override
    public void setParent(SecretRepository parent) {
        this.parentRepository = parent;
    }

    @Override
    public SecretRepository getParent() {
        return this.parentRepository;
    }
}

