/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.securevault.commons;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.securevault.SecureVaultException;

public class MiscellaneousUtil {
    private static Log log = LogFactory.getLog(MiscellaneousUtil.class);
    private static String CONF_LOCATION = "conf.location";

    private MiscellaneousUtil() {
    }

    public static String getProperty(Properties properties, String name, String defaultValue) {
        String result = properties.getProperty(name);
        if ((result == null || result.length() == 0) && defaultValue != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The name with ' " + name + " ' cannot be found. Using default value " + defaultValue));
            }
            result = defaultValue;
        }
        if (result != null) {
            return result.trim();
        }
        return defaultValue;
    }

    public static <T> T getProperty(Properties properties, String name, T defaultValue, Class<? extends T> type) {
        String result = properties.getProperty(name);
        if (result == null && defaultValue != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The name with ' " + name + " ' cannot be found. Using default value " + defaultValue));
            }
            return defaultValue;
        }
        if (result == null || type == null) {
            return null;
        }
        if (String.class.equals(type)) {
            return (T)result;
        }
        if (Boolean.class.equals(type)) {
            return (T)Boolean.valueOf(Boolean.parseBoolean(result));
        }
        if (Integer.class.equals(type)) {
            return (T)Integer.valueOf(Integer.parseInt(result));
        }
        if (Long.class.equals(type)) {
            return (T)Long.valueOf(Long.parseLong(result));
        }
        MiscellaneousUtil.handleException("Unsupported type: " + type);
        return null;
    }

    public static Properties loadProperties(String filePath) {
        String msg;
        Properties properties = new Properties();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading a file ' " + filePath + " ' from classpath"));
        }
        InputStream in = null;
        if (System.getProperty(CONF_LOCATION) != null) {
            try {
                in = new FileInputStream(System.getProperty(CONF_LOCATION) + File.separator + filePath);
            }
            catch (FileNotFoundException e) {
                msg = "Error loading properties from file: " + filePath;
                log.warn((Object)msg);
            }
        }
        if (in == null) {
            in = cl.getResourceAsStream(filePath);
        }
        if (in == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to load file  ' " + filePath + " '"));
            }
            filePath = "conf" + File.separatorChar + filePath;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading a file ' " + filePath + " ' from classpath"));
            }
            if ((in = cl.getResourceAsStream(filePath)) == null && log.isDebugEnabled()) {
                log.debug((Object)("Unable to load file  ' " + filePath + " '"));
            }
        }
        if (in != null) {
            try {
                properties.load(in);
            }
            catch (IOException e) {
                msg = "Error loading properties from a file at :" + filePath;
                log.error((Object)msg, (Throwable)e);
                throw new SecureVaultException(msg, e);
            }
        }
        return properties;
    }

    public static byte[] asBytes(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new SecureVaultException("Error during converting a inputstream into a bytearray ", e, log);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return out.toByteArray();
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SecureVaultException(msg);
    }
}

