/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.referencing.operation.matrix.GeneralMatrix;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.Matrix;

final class Solver
implements Matrix {
    private static final int TUPLE_SIZE = 3;
    private static final Matrix IDENTITY = new Solver();

    private Solver() {
    }

    public boolean isIdentity() {
        return true;
    }

    public double getElement(int n, int n2) {
        return n == n2 ? 1.0 : 0.0;
    }

    public void setElement(int n, int n2, double d) {
        throw new UnsupportedOperationException();
    }

    public Matrix clone() {
        return this;
    }

    public int getNumRow() {
        return 0;
    }

    public int getNumCol() {
        return 0;
    }

    static MatrixSIS inverse(MatrixSIS matrixSIS, boolean bl) throws NoninvertibleMatrixException {
        int n = matrixSIS.getNumRow();
        int n2 = matrixSIS.getNumCol();
        if (n2 != n) {
            throw new NoninvertibleMatrixException(Errors.format((short)81, (Object)n, (Object)n2));
        }
        return Solver.solve(matrixSIS, IDENTITY, null, n, n, bl);
    }

    static MatrixSIS solve(MatrixSIS matrixSIS, Matrix matrix) throws NoninvertibleMatrixException {
        int n = matrixSIS.getNumRow();
        int n2 = matrixSIS.getNumCol();
        if (n2 != n) {
            throw new NoninvertibleMatrixException(Errors.format((short)81, (Object)n, (Object)n2));
        }
        int n3 = matrix.getNumCol();
        GeneralMatrix.ensureNumRowMatch(n, matrix, n3);
        double[] dArray = null;
        if (matrix instanceof GeneralMatrix && (dArray = ((GeneralMatrix)matrix).elements).length == n * n3) {
            dArray = null;
        }
        return Solver.solve(matrixSIS, matrix, dArray, n, n3, true);
    }

    private static MatrixSIS solve(MatrixSIS matrixSIS, Matrix matrix, double[] dArray, int n, int n2, boolean bl) throws NoninvertibleMatrixException {
        int n3;
        int n4;
        int n5;
        int n6;
        assert (matrixSIS.getNumRow() == n && matrixSIS.getNumCol() == n) : n;
        assert (matrix.getNumRow() == n && matrix.getNumCol() == n2 || matrix instanceof Solver);
        double[] dArray2 = GeneralMatrix.getExtendedElements(matrixSIS, n, n, bl);
        int n7 = n - 1;
        int[] nArray = null;
        int n8 = 0;
        if (matrixSIS.isAffine()) {
            int n9 = (n - 1) * n;
            block0: while (--n9 >= 0) {
                if (!Double.isNaN(dArray2[n9])) continue;
                n6 = n9 / n;
                n5 = n9 % n;
                n4 = -1;
                if (n5 != n7) {
                    n4 = n5;
                    n3 = n7;
                    while (--n3 >= 0) {
                        if (n3 == n6 || dArray2[n3 * n + n5] == 0.0) continue;
                        nArray = null;
                        n8 = 0;
                        break block0;
                    }
                }
                n3 = n7;
                while (--n3 >= 0) {
                    if (n3 == n5 || dArray2[n6 * n + n3] == 0.0) continue;
                    if (n4 >= 0) {
                        nArray = null;
                        n8 = 0;
                        break block0;
                    }
                    n4 = n3;
                }
                if (nArray == null) {
                    nArray = new int[n7 * 6];
                }
                nArray[n8++] = n5;
                nArray[n8++] = n6;
                nArray[n8++] = n4;
                assert (n8 % 3 == 0);
            }
            for (n9 = 0; n9 < n8; n9 += 3) {
                n6 = nArray[n9];
                n5 = nArray[n9 + 1];
                n4 = n5 * n + n6;
                dArray2[n4] = n6 == n7 ? 0.0 : 1.0;
                dArray2[n4 + n * n] = 0.0;
            }
        }
        MatrixSIS matrixSIS2 = Solver.solve(dArray2, matrix, dArray, n, n2);
        n6 = 0;
        while (n6 < n8) {
            assert (n6 % 3 == 0);
            n5 = nArray[n6++];
            n4 = nArray[n6++];
            n3 = nArray[n6++];
            if (n5 != n7) {
                matrixSIS2.setElement(n5, n4, Double.NaN);
                if (matrixSIS2.getElement(n5, n7) == 0.0) continue;
                matrixSIS2.setElement(n5, n7, Double.NaN);
                continue;
            }
            if (n3 < 0) continue;
            matrixSIS2.setElement(n3, n7, Double.NaN);
        }
        return matrixSIS2;
    }

    private static MatrixSIS solve(double[] dArray, Matrix matrix, double[] dArray2, int n, int n2) throws NoninvertibleMatrixException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = n * n;
        assert (n10 == GeneralMatrix.indexOfErrors(n, n, dArray));
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        double[] dArray3 = new double[n * 2];
        DoubleDouble doubleDouble = new DoubleDouble();
        DoubleDouble doubleDouble2 = new DoubleDouble();
        for (n9 = 0; n9 < n; ++n9) {
            int n11;
            for (n11 = 0; n11 < n; ++n11) {
                n8 = n11 * n + n9;
                dArray3[n11] = dArray[n8];
                dArray3[n11 + n] = dArray[n8 + n10];
            }
            for (n11 = 0; n11 < n; ++n11) {
                n8 = n11 * n;
                n7 = Math.min(n11, n9);
                doubleDouble.clear();
                for (n6 = 0; n6 < n7; ++n6) {
                    doubleDouble2.setFrom(dArray, n8 + n6, n10);
                    doubleDouble2.multiply(dArray3, n6, n);
                    doubleDouble.add(doubleDouble2);
                }
                doubleDouble.subtract(dArray3, n11, n);
                doubleDouble.negate();
                doubleDouble.storeTo(dArray3, n11, n);
                doubleDouble.storeTo(dArray, n8 + n9, n10);
            }
            n11 = n9;
            n8 = n9;
            while (++n8 < n) {
                if (!(Math.abs(dArray3[n8]) > Math.abs(dArray3[n11]))) continue;
                n11 = n8;
            }
            if (n11 != n9) {
                n8 = n11 * n;
                n7 = n9 * n;
                for (n6 = 0; n6 < n; ++n6) {
                    DoubleDouble.swap((double[])dArray, (int)(n8 + n6), (int)(n7 + n6), (int)n10);
                }
                ArraysExt.swap((int[])nArray, (int)n11, (int)n9);
            }
            doubleDouble.setFrom(dArray, n9 * n + n9, n10);
            if (doubleDouble.isZero()) continue;
            n8 = n9;
            while (++n8 < n) {
                n7 = n8 * n + n9;
                doubleDouble2.setFrom(doubleDouble);
                doubleDouble2.inverseDivide(dArray, n7, n10);
                doubleDouble2.storeTo(dArray, n7, n10);
            }
        }
        for (n9 = 0; n9 < n; ++n9) {
            doubleDouble2.setFrom(dArray, n9 * n + n9, n10);
            if (!doubleDouble2.isZero()) continue;
            throw new NoninvertibleMatrixException(Errors.format((short)101));
        }
        GeneralMatrix generalMatrix = GeneralMatrix.createExtendedPrecision(n, n2);
        double[] dArray4 = generalMatrix.elements;
        n8 = n * n2;
        n7 = 0;
        for (n6 = 0; n6 < n; ++n6) {
            n5 = nArray[n6];
            for (n4 = 0; n4 < n2; ++n4) {
                if (dArray2 != null) {
                    n3 = n5 * n2 + n4;
                    dArray4[n7] = dArray2[n3];
                    dArray4[n7 + n8] = dArray2[n3 + n8];
                } else {
                    dArray4[n7] = matrix.getElement(n5, n4);
                }
                ++n7;
            }
        }
        for (n7 = 0; n7 < n; ++n7) {
            n6 = n7 * n2;
            n5 = n7;
            while (++n5 < n) {
                n4 = n5 * n2;
                n3 = n5 * n;
                for (int i = 0; i < n2; ++i) {
                    doubleDouble.setFrom(dArray4, n4 + i, n8);
                    doubleDouble2.setFrom(dArray4, n6 + i, n8);
                    doubleDouble2.multiply(dArray, n3 + n7, n10);
                    doubleDouble.subtract(doubleDouble2);
                    doubleDouble.storeTo(dArray4, n4 + i, n8);
                }
            }
        }
        n7 = n;
        while (--n7 >= 0) {
            n6 = n7 * n2;
            doubleDouble.setFrom(dArray, n7 * n + n7, n10);
            for (n5 = 0; n5 < n2; ++n5) {
                doubleDouble2.setFrom(doubleDouble);
                doubleDouble2.inverseDivide(dArray4, n6 + n5, n8);
                doubleDouble2.storeTo(dArray4, n6 + n5, n8);
            }
            for (n5 = 0; n5 < n7; ++n5) {
                n4 = n5 * n2;
                doubleDouble.setFrom(dArray, n5 * n + n7, n10);
                for (n3 = 0; n3 < n2; ++n3) {
                    doubleDouble2.setFrom(dArray4, n6 + n3, n8);
                    doubleDouble2.multiply(doubleDouble);
                    doubleDouble2.subtract(dArray4, n4 + n3, n8);
                    doubleDouble2.negate();
                    doubleDouble2.storeTo(dArray4, n4 + n3, n8);
                }
            }
        }
        return generalMatrix;
    }
}

