/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import java.io.Serializable;
import org.apache.sis.referencing.operation.matrix.GeneralMatrix;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.matrix.Solver;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.Matrix;

public abstract class MatrixSIS
implements Matrix,
LenientComparable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3075280376118406219L;

    protected MatrixSIS() {
    }

    static void ensureLengthMatch(int n, double[] dArray) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull((String)"elements", (Object)dArray);
        if (dArray.length != n) {
            throw new IllegalArgumentException(Errors.format((short)107, (Object)n, (Object)dArray.length));
        }
    }

    static void ensureSizeMatch(int n, Matrix matrix) {
        int n2 = matrix.getNumRow();
        int n3 = matrix.getNumCol();
        if (n2 != n || n3 != n) {
            Integer n4 = n;
            throw new MismatchedMatrixSizeException(Errors.format((short)60, (Object)n4, (Object)n4, (Object)n2, (Object)n3));
        }
    }

    static void ensureNumRowMatch(int n, Matrix matrix, int n2) {
        int n3 = matrix.getNumRow();
        if (n3 != n) {
            throw new MismatchedMatrixSizeException(Errors.format((short)60, (Object)n, (Object)"\u24a9", (Object)n3, (Object)n2));
        }
    }

    static IndexOutOfBoundsException indexOutOfBounds(int n, int n2) {
        return new IndexOutOfBoundsException(Errors.format((short)50, (Object)n, (Object)n2));
    }

    public static MatrixSIS castOrCopy(Matrix matrix) {
        if (matrix == null || matrix instanceof MatrixSIS) {
            return (MatrixSIS)matrix;
        }
        return Matrices.copy(matrix);
    }

    public Number getNumber(int n, int n2) {
        return this.getElement(n, n2);
    }

    public abstract double getElement(int var1, int var2);

    public abstract double[] getElements();

    void getElements(double[] dArray) {
        double[] dArray2 = this.getElements();
        System.arraycopy(dArray2, 0, dArray, 0, dArray2.length);
    }

    public abstract void setElements(double[] var1);

    public abstract boolean isAffine();

    public abstract boolean isIdentity();

    public abstract void transpose();

    public abstract void normalizeColumns();

    public MatrixSIS multiply(Matrix matrix) throws MismatchedMatrixSizeException {
        int n = this.getNumRow();
        int n2 = this.getNumCol();
        int n3 = matrix.getNumCol();
        MatrixSIS.ensureNumRowMatch(n2, matrix, n3);
        GeneralMatrix generalMatrix = GeneralMatrix.createExtendedPrecision(n, n3);
        generalMatrix.setToProduct(this, matrix);
        return generalMatrix;
    }

    public MatrixSIS solve(Matrix matrix) throws MismatchedMatrixSizeException, NoninvertibleMatrixException {
        return Solver.solve(this, matrix);
    }

    public MatrixSIS inverse() throws NoninvertibleMatrixException {
        return Solver.inverse(this, true);
    }

    public boolean equals(Matrix matrix, double d) {
        return Matrices.equals(this, matrix, d, false);
    }

    public boolean equals(Object object, ComparisonMode comparisonMode) {
        return object instanceof Matrix && Matrices.equals(this, (Matrix)object, comparisonMode);
    }

    public MatrixSIS clone() {
        try {
            return (MatrixSIS)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public String toString() {
        return Matrices.toString(this);
    }
}

