/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Arrays;
import java.util.Date;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.datum.GeodeticDatum;

public class TimeDependentBWP
extends BursaWolfParameters {
    private static final long serialVersionUID = -4628799278259080258L;
    public double dtX;
    public double dtY;
    public double dtZ;
    public double drX;
    public double drY;
    public double drZ;
    public double ddS;
    private final long timeReference;

    public TimeDependentBWP(GeodeticDatum geodeticDatum, Extent extent, Date date) {
        super(geodeticDatum, extent);
        ArgumentChecks.ensureNonNull((String)"timeReference", (Object)date);
        this.timeReference = date.getTime();
    }

    @Override
    void verify() {
        super.verify();
        ArgumentChecks.ensureFinite((String)"dtX", (double)this.dtX);
        ArgumentChecks.ensureFinite((String)"dtY", (double)this.dtY);
        ArgumentChecks.ensureFinite((String)"dtZ", (double)this.dtZ);
        ArgumentChecks.ensureFinite((String)"drX", (double)this.drX);
        ArgumentChecks.ensureFinite((String)"drY", (double)this.drY);
        ArgumentChecks.ensureFinite((String)"drZ", (double)this.drZ);
    }

    public Date getTimeReference() {
        return new Date(this.timeReference);
    }

    @Override
    final DoubleDouble period(Date date) {
        long l;
        if (date != null && (l = date.getTime() - this.timeReference) != 0L) {
            DoubleDouble doubleDouble = new DoubleDouble((double)l, 0.0);
            doubleDouble.divide(3.15576E13, 0.0);
            return doubleDouble;
        }
        return null;
    }

    @Override
    final DoubleDouble param(int n, DoubleDouble doubleDouble) {
        DoubleDouble doubleDouble2 = super.param(n, doubleDouble);
        if (doubleDouble != null) {
            double d;
            double d2 = doubleDouble.value;
            double d3 = doubleDouble.error;
            switch (n) {
                case 0: {
                    d = this.dtX;
                    break;
                }
                case 1: {
                    d = this.dtY;
                    break;
                }
                case 2: {
                    d = this.dtZ;
                    break;
                }
                case 3: {
                    d = this.drX;
                    break;
                }
                case 4: {
                    d = this.drY;
                    break;
                }
                case 5: {
                    d = this.drZ;
                    break;
                }
                case 6: {
                    d = this.ddS;
                    doubleDouble.multiply(1000.0, 0.0);
                    break;
                }
                default: {
                    throw new AssertionError(n);
                }
            }
            doubleDouble.multiply(d);
            doubleDouble2.add(doubleDouble);
            doubleDouble.value = d2;
            doubleDouble.error = d3;
        }
        return doubleDouble2;
    }

    @Override
    public boolean isIdentity() {
        return super.isIdentity() && this.dtX == 0.0 && this.dtY == 0.0 && this.dtZ == 0.0;
    }

    @Override
    public boolean isTranslation() {
        return super.isTranslation() && this.drX == 0.0 && this.drY == 0.0 && this.drZ == 0.0;
    }

    @Override
    public void reverseRotation() {
        super.reverseRotation();
        this.drX = -this.drX;
        this.drY = -this.drY;
        this.drZ = -this.drZ;
    }

    @Override
    public void invert() {
        super.invert();
        this.dtX = -this.dtX;
        this.dtY = -this.dtY;
        this.dtZ = -this.dtZ;
        this.drX = -this.drX;
        this.drY = -this.drY;
        this.drZ = -this.drZ;
        this.ddS = -this.ddS;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            TimeDependentBWP timeDependentBWP = (TimeDependentBWP)object;
            return this.timeReference == timeDependentBWP.timeReference && Numerics.equals((double)this.dtX, (double)timeDependentBWP.dtX) && Numerics.equals((double)this.dtY, (double)timeDependentBWP.dtY) && Numerics.equals((double)this.dtZ, (double)timeDependentBWP.dtZ) && Numerics.equals((double)this.drX, (double)timeDependentBWP.drX) && Numerics.equals((double)this.drY, (double)timeDependentBWP.drY) && Numerics.equals((double)this.drZ, (double)timeDependentBWP.drZ) && Numerics.equals((double)this.ddS, (double)timeDependentBWP.ddS);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0xB2C873BE ^ Arrays.hashCode(new double[]{this.tX, this.tY, this.tZ, this.rX, this.rY, this.rZ, this.dS, this.dtX, this.dtY, this.dtZ, this.drX, this.drY, this.drZ, this.ddS, this.timeReference});
    }
}

