/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.Map;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.AbstractReferenceSystem;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultCompoundCRS;
import org.apache.sis.referencing.crs.DefaultEngineeringCRS;
import org.apache.sis.referencing.crs.DefaultGeodeticCRS;
import org.apache.sis.referencing.crs.DefaultImageCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.crs.SubTypes;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;

@XmlType(name="AbstractCRSType")
@XmlRootElement(name="AbstractCRS")
@XmlSeeAlso(value={DefaultGeodeticCRS.class, DefaultVerticalCRS.class, DefaultTemporalCRS.class, DefaultEngineeringCRS.class, DefaultImageCRS.class, DefaultCompoundCRS.class})
public class AbstractCRS
extends AbstractReferenceSystem
implements CoordinateReferenceSystem {
    private static final long serialVersionUID = -7433284548909530047L;
    private CoordinateSystem coordinateSystem;
    private transient Map<AxesConvention, AbstractCRS> forConvention;

    AbstractCRS() {
        super(NilReferencingObject.INSTANCE);
    }

    public AbstractCRS(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        super(map);
        ArgumentChecks.ensureNonNull((String)"cs", (Object)coordinateSystem);
        this.coordinateSystem = coordinateSystem;
    }

    protected AbstractCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        super((ReferenceSystem)coordinateReferenceSystem);
        this.coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
    }

    public static AbstractCRS castOrCopy(CoordinateReferenceSystem coordinateReferenceSystem) {
        return SubTypes.castOrCopy(coordinateReferenceSystem);
    }

    public Class<? extends CoordinateReferenceSystem> getInterface() {
        return CoordinateReferenceSystem.class;
    }

    Datum getDatum() {
        return this instanceof SingleCRS ? ((SingleCRS)this).getDatum() : null;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    final <T extends CoordinateSystem> T getCoordinateSystem(Class<T> clazz) {
        CoordinateSystem coordinateSystem = this.coordinateSystem;
        if (clazz.isInstance(coordinateSystem) && (clazz != AffineCS.class || !(coordinateSystem instanceof CartesianCS))) {
            return (T)coordinateSystem;
        }
        return null;
    }

    final void setCoordinateSystem(String string, CoordinateSystem coordinateSystem) {
        if (coordinateSystem != null && ReferencingUtilities.canSetProperty(AbstractCRS.class, "setCoordinateSystem", string, this.coordinateSystem != null)) {
            this.coordinateSystem = coordinateSystem;
        }
    }

    final AbstractCRS getCached(AxesConvention axesConvention) {
        assert (Thread.holdsLock(this));
        return this.forConvention != null ? this.forConvention.get((Object)axesConvention) : null;
    }

    final AbstractCRS setCached(AxesConvention axesConvention, AbstractCRS abstractCRS) {
        assert (Thread.holdsLock(this));
        if (this.forConvention == null) {
            this.forConvention = new EnumMap<AxesConvention, AbstractCRS>(AxesConvention.class);
        } else if (abstractCRS != this) {
            for (AbstractCRS abstractCRS2 : this.forConvention.values()) {
                if (!abstractCRS.equals(abstractCRS2)) continue;
                abstractCRS = abstractCRS2;
                break;
            }
        }
        if (this.forConvention.put(axesConvention, abstractCRS) != null) {
            throw new ConcurrentModificationException();
        }
        return abstractCRS;
    }

    public synchronized AbstractCRS forConvention(AxesConvention axesConvention) {
        ArgumentChecks.ensureNonNull((String)"convention", (Object)((Object)axesConvention));
        AbstractCRS abstractCRS = this.getCached(axesConvention);
        if (abstractCRS == null) {
            AbstractCS abstractCS = AbstractCS.castOrCopy(this.coordinateSystem);
            AbstractCS abstractCS2 = abstractCS.forConvention(axesConvention);
            abstractCRS = abstractCS2 == abstractCS ? this : this.createSameType(IdentifiedObjects.getProperties(this, "identifiers"), abstractCS2);
            abstractCRS = this.setCached(axesConvention, abstractCRS);
        }
        return abstractCRS;
    }

    AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        return new AbstractCRS(map, coordinateSystem);
    }

    final Unit<?> getUnit() {
        return ReferencingUtilities.getUnit(this.coordinateSystem);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            Datum datum = this.getDatum();
            switch (comparisonMode) {
                case STRICT: {
                    AbstractCRS abstractCRS = (AbstractCRS)object;
                    return Objects.equals((Object)datum, (Object)abstractCRS.getDatum()) && Objects.equals((Object)this.coordinateSystem, (Object)abstractCRS.coordinateSystem);
                }
            }
            return Utilities.deepEquals((Object)datum, (Object)(object instanceof SingleCRS ? ((SingleCRS)object).getDatum() : null), (ComparisonMode)comparisonMode) && Utilities.deepEquals((Object)this.getCoordinateSystem(), (Object)((CoordinateReferenceSystem)object).getCoordinateSystem(), (ComparisonMode)comparisonMode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash((Object[])new Object[]{this.getDatum(), this.coordinateSystem});
    }

    @Override
    protected String formatTo(Formatter formatter) {
        String string = super.formatTo(formatter);
        CoordinateSystem coordinateSystem = this.coordinateSystem;
        boolean bl = formatter.getConvention().majorVersion() == 1;
        Unit<?> unit = ReferencingUtilities.getUnit(coordinateSystem);
        Unit unit2 = formatter.addContextualUnit(unit);
        formatter.newLine();
        formatter.append(WKTUtilities.toFormattable(this.getDatum()));
        formatter.newLine();
        if (bl) {
            formatter.append(unit);
            if (unit == null) {
                formatter.setInvalidWKT((IdentifiedObject)this, null);
            }
        } else {
            formatter.append(WKTUtilities.toFormattable(coordinateSystem));
            formatter.indent(1);
        }
        int n = coordinateSystem.getDimension();
        for (int i = 0; i < n; ++i) {
            formatter.newLine();
            formatter.append(WKTUtilities.toFormattable(coordinateSystem.getAxis(i)));
        }
        if (!bl) {
            formatter.newLine();
            formatter.append(unit);
            formatter.indent(-1);
        }
        formatter.removeContextualUnit(unit);
        formatter.addContextualUnit(unit2);
        formatter.newLine();
        return string;
    }
}

