/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultSpatialTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class ServicesForMetadata
extends ReferencingServices {
    public Matrix getMatrix(MathTransform mathTransform) {
        return MathTransforms.getMatrix(mathTransform);
    }

    public ParameterDescriptor<?> toImplementation(ParameterDescriptor<?> parameterDescriptor) {
        return DefaultParameterDescriptor.castOrCopy(parameterDescriptor);
    }

    public FormattableObject toFormattableObject(IdentifiedObject identifiedObject) {
        return AbstractIdentifiedObject.castOrCopy(identifiedObject);
    }

    private static CoordinateOperationFactory getFactory() throws TransformException {
        CoordinateOperationFactory coordinateOperationFactory = (CoordinateOperationFactory)DefaultFactories.forClass(CoordinateOperationFactory.class);
        if (coordinateOperationFactory != null) {
            return coordinateOperationFactory;
        }
        throw new TransformException(Errors.format((short)61, (Object)"geotk-referencing"));
    }

    private static String dimensionNotFound(short s, CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem == null) {
            return Errors.format((short)173);
        }
        return Errors.format((short)s, (Object)coordinateReferenceSystem.getName());
    }

    private void setGeographicExtent(Envelope envelope, DefaultGeographicBoundingBox defaultGeographicBoundingBox, CoordinateReferenceSystem coordinateReferenceSystem, GeographicCRS geographicCRS) throws TransformException {
        if (geographicCRS != null) {
            CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
            EllipsoidalCS ellipsoidalCS = geographicCRS.getCoordinateSystem();
            if (!Utilities.equalsIgnoreMetadata((Object)ellipsoidalCS.getAxis(0), (Object)coordinateSystem.getAxis(0)) || !Utilities.equalsIgnoreMetadata((Object)ellipsoidalCS.getAxis(1), (Object)coordinateSystem.getAxis(1))) {
                CoordinateOperation coordinateOperation;
                try {
                    coordinateOperation = ServicesForMetadata.getFactory().createOperation(coordinateReferenceSystem, (CoordinateReferenceSystem)geographicCRS);
                }
                catch (FactoryException factoryException) {
                    throw new TransformException(Errors.format((short)174), (Throwable)factoryException);
                }
                envelope = Envelopes.transform(coordinateOperation, envelope);
            }
        }
        double d = envelope.getMinimum(0);
        double d2 = envelope.getMaximum(0);
        double d3 = envelope.getMinimum(1);
        double d4 = envelope.getMaximum(1);
        if (geographicCRS != null) {
            double d5 = CRS.getGreenwichLongitude((GeodeticCRS)geographicCRS);
            d += d5;
            d2 += d5;
        }
        defaultGeographicBoundingBox.setBounds(d, d2, d3, d4);
        defaultGeographicBoundingBox.setInclusion(Boolean.TRUE);
    }

    private static void setVerticalExtent(Envelope envelope, DefaultVerticalExtent defaultVerticalExtent, CoordinateReferenceSystem coordinateReferenceSystem, VerticalCRS verticalCRS) {
        int n;
        if (verticalCRS == null) {
            n = 0;
        } else {
            n = AxisDirections.indexOfColinear(coordinateReferenceSystem.getCoordinateSystem(), (CoordinateSystem)verticalCRS.getCoordinateSystem());
            assert (n >= 0) : coordinateReferenceSystem;
        }
        defaultVerticalExtent.setMinimumValue(Double.valueOf(envelope.getMinimum(n)));
        defaultVerticalExtent.setMaximumValue(Double.valueOf(envelope.getMaximum(n)));
        defaultVerticalExtent.setVerticalCRS(verticalCRS);
    }

    private static void setTemporalExtent(Envelope envelope, DefaultTemporalExtent defaultTemporalExtent, CoordinateReferenceSystem coordinateReferenceSystem, TemporalCRS temporalCRS) {
        int n = AxisDirections.indexOfColinear(coordinateReferenceSystem.getCoordinateSystem(), (CoordinateSystem)temporalCRS.getCoordinateSystem());
        assert (n >= 0) : coordinateReferenceSystem;
        DefaultTemporalCRS defaultTemporalCRS = DefaultTemporalCRS.castOrCopy(temporalCRS);
        defaultTemporalExtent.setBounds(defaultTemporalCRS.toDate(envelope.getMinimum(n)), defaultTemporalCRS.toDate(envelope.getMaximum(n)));
    }

    public void setBounds(Envelope envelope, DefaultGeographicBoundingBox defaultGeographicBoundingBox) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        GeographicCRS geographicCRS = ReferencingUtilities.toNormalizedGeographicCRS(coordinateReferenceSystem);
        if (geographicCRS == null) {
            if (coordinateReferenceSystem != null) {
                geographicCRS = CommonCRS.defaultGeographic();
            } else if (envelope.getDimension() != 2) {
                throw new TransformException(ServicesForMetadata.dimensionNotFound((short)169, coordinateReferenceSystem));
            }
        }
        this.setGeographicExtent(envelope, defaultGeographicBoundingBox, coordinateReferenceSystem, geographicCRS);
    }

    public void setBounds(Envelope envelope, DefaultVerticalExtent defaultVerticalExtent) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        VerticalCRS verticalCRS = CRS.getVerticalComponent(coordinateReferenceSystem, true);
        if (verticalCRS == null && envelope.getDimension() != 1) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)172, coordinateReferenceSystem));
        }
        ServicesForMetadata.setVerticalExtent(envelope, defaultVerticalExtent, coordinateReferenceSystem, verticalCRS);
    }

    public void setBounds(Envelope envelope, DefaultTemporalExtent defaultTemporalExtent) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        TemporalCRS temporalCRS = CRS.getTemporalComponent(coordinateReferenceSystem);
        if (temporalCRS == null) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)171, coordinateReferenceSystem));
        }
        ServicesForMetadata.setTemporalExtent(envelope, defaultTemporalExtent, coordinateReferenceSystem, temporalCRS);
    }

    public void setBounds(Envelope envelope, DefaultSpatialTemporalExtent defaultSpatialTemporalExtent) throws TransformException {
        GeographicExtent geographicExtent;
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        SingleCRS singleCRS = CRS.getHorizontalComponent(coordinateReferenceSystem);
        VerticalCRS verticalCRS = CRS.getVerticalComponent(coordinateReferenceSystem, true);
        TemporalCRS temporalCRS = CRS.getTemporalComponent(coordinateReferenceSystem);
        if (singleCRS == null && verticalCRS == null && temporalCRS == null) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)170, coordinateReferenceSystem));
        }
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = null;
        boolean bl = singleCRS != null;
        Collection collection = defaultSpatialTemporalExtent.getSpatialExtent();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            geographicExtent = (GeographicExtent)iterator.next();
            if (!(geographicExtent instanceof GeographicBoundingBox)) continue;
            if (bl && geographicExtent instanceof DefaultGeographicBoundingBox) {
                defaultGeographicBoundingBox = (DefaultGeographicBoundingBox)geographicExtent;
                bl = false;
                continue;
            }
            iterator.remove();
        }
        if (singleCRS != null) {
            if (defaultGeographicBoundingBox == null) {
                defaultGeographicBoundingBox = new DefaultGeographicBoundingBox();
                collection.add(defaultGeographicBoundingBox);
            }
            if ((geographicExtent = ReferencingUtilities.toNormalizedGeographicCRS(coordinateReferenceSystem)) == null) {
                geographicExtent = CommonCRS.defaultGeographic();
            }
            this.setGeographicExtent(envelope, defaultGeographicBoundingBox, coordinateReferenceSystem, (GeographicCRS)geographicExtent);
        }
        if (verticalCRS != null) {
            geographicExtent = defaultSpatialTemporalExtent.getVerticalExtent();
            if (!(geographicExtent instanceof DefaultVerticalExtent)) {
                geographicExtent = new DefaultVerticalExtent();
                defaultSpatialTemporalExtent.setVerticalExtent((VerticalExtent)geographicExtent);
            }
            ServicesForMetadata.setVerticalExtent(envelope, (DefaultVerticalExtent)geographicExtent, coordinateReferenceSystem, verticalCRS);
        } else {
            defaultSpatialTemporalExtent.setVerticalExtent(null);
        }
        if (temporalCRS != null) {
            ServicesForMetadata.setTemporalExtent(envelope, (DefaultTemporalExtent)defaultSpatialTemporalExtent, coordinateReferenceSystem, temporalCRS);
        } else {
            defaultSpatialTemporalExtent.setExtent(null);
        }
    }

    public void addElements(Envelope envelope, DefaultExtent defaultExtent) throws TransformException {
        DefaultGeographicBoundingBox defaultGeographicBoundingBox;
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        SingleCRS singleCRS = CRS.getHorizontalComponent(coordinateReferenceSystem);
        VerticalCRS verticalCRS = CRS.getVerticalComponent(coordinateReferenceSystem, true);
        TemporalCRS temporalCRS = CRS.getTemporalComponent(coordinateReferenceSystem);
        if (singleCRS == null && verticalCRS == null && temporalCRS == null) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)170, coordinateReferenceSystem));
        }
        if (singleCRS != null) {
            defaultGeographicBoundingBox = new DefaultGeographicBoundingBox();
            defaultGeographicBoundingBox.setInclusion(Boolean.TRUE);
            this.setBounds(envelope, defaultGeographicBoundingBox);
            defaultExtent.getGeographicElements().add(defaultGeographicBoundingBox);
        }
        if (verticalCRS != null) {
            defaultGeographicBoundingBox = new DefaultVerticalExtent();
            ServicesForMetadata.setVerticalExtent(envelope, (DefaultVerticalExtent)defaultGeographicBoundingBox, coordinateReferenceSystem, verticalCRS);
            defaultExtent.getVerticalElements().add(defaultGeographicBoundingBox);
        }
        if (temporalCRS != null) {
            defaultGeographicBoundingBox = new DefaultTemporalExtent();
            ServicesForMetadata.setTemporalExtent(envelope, (DefaultTemporalExtent)defaultGeographicBoundingBox, coordinateReferenceSystem, temporalCRS);
            defaultExtent.getTemporalElements().add(defaultGeographicBoundingBox);
        }
    }
}

