/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.ArrayEnvelope;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.geometry.SubEnvelope;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;

public class GeneralEnvelope
extends ArrayEnvelope
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3796799507279068254L;
    private static volatile Field ordinatesField;

    GeneralEnvelope(double[] dArray) {
        super(dArray);
    }

    public GeneralEnvelope(DirectPosition directPosition, DirectPosition directPosition2) throws MismatchedDimensionException, MismatchedReferenceSystemException {
        super(directPosition, directPosition2);
    }

    public GeneralEnvelope(double[] dArray, double[] dArray2) throws MismatchedDimensionException {
        super(dArray, dArray2);
    }

    public GeneralEnvelope(int n) {
        super(n);
    }

    public GeneralEnvelope(CoordinateReferenceSystem coordinateReferenceSystem) {
        super(coordinateReferenceSystem);
    }

    public GeneralEnvelope(Envelope envelope) {
        super(envelope);
    }

    public GeneralEnvelope(GeographicBoundingBox geographicBoundingBox) {
        super(geographicBoundingBox);
    }

    public GeneralEnvelope(CharSequence charSequence) throws IllegalArgumentException {
        super(charSequence);
    }

    public static GeneralEnvelope castOrCopy(Envelope envelope) {
        if (envelope == null || envelope instanceof GeneralEnvelope) {
            return (GeneralEnvelope)envelope;
        }
        return new GeneralEnvelope(envelope);
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)this.getDimension(), (CoordinateReferenceSystem)coordinateReferenceSystem);
        if (coordinateReferenceSystem != null) {
            int n = this.beginIndex();
            int n2 = this.endIndex();
            int n3 = this.ordinates.length >>> 1;
            for (int i = n; i < n2; ++i) {
                int n4;
                double d = this.ordinates[i];
                double d2 = this.ordinates[i + n3];
                if (!(d > d2) || GeneralEnvelope.isWrapAround(coordinateReferenceSystem, n4 = i - n)) continue;
                throw new IllegalStateException(GeneralEnvelope.illegalRange(coordinateReferenceSystem, n4, d, d2));
            }
        }
        this.crs = coordinateReferenceSystem;
    }

    @Override
    public void setRange(int n, double d, double d2) throws IndexOutOfBoundsException {
        int n2 = this.ordinates.length >>> 1;
        ArgumentChecks.ensureValidIndex((int)n2, (int)n);
        if (d > d2 && this.crs != null && !GeneralEnvelope.isWrapAround(this.crs, n)) {
            throw new IllegalArgumentException(GeneralEnvelope.illegalRange(this.crs, n, d, d2));
        }
        this.ordinates[n + n2] = d2;
        this.ordinates[n] = d;
    }

    public void setEnvelope(double ... dArray) {
        GeneralEnvelope.verifyArrayLength(this.ordinates.length >>> 1, dArray);
        GeneralEnvelope.verifyRanges(this.crs, dArray);
        System.arraycopy(dArray, 0, this.ordinates, 0, this.ordinates.length);
    }

    static void verifyArrayLength(int n, double[] dArray) {
        if ((dArray.length & 1) != 0) {
            throw new IllegalArgumentException(Errors.format((short)98, (Object)dArray.length));
        }
        int n2 = dArray.length >>> 1;
        if (n2 != n) {
            throw new MismatchedDimensionException(Errors.format((short)59, (Object)"ordinates", (Object)n, (Object)n2));
        }
    }

    public void setEnvelope(Envelope envelope) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.beginIndex();
        int n2 = this.endIndex() - n;
        ArgumentChecks.ensureDimensionMatches((String)"envelope", (int)n2, (Envelope)envelope);
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope.getUpperCorner();
        int n3 = this.ordinates.length >>> 1;
        for (int i = 0; i < n2; ++i) {
            int n4 = n + i;
            int n5 = n4 + n3;
            this.ordinates[n4] = directPosition.getOrdinate(i);
            this.ordinates[n5] = directPosition2.getOrdinate(i);
        }
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem != null) {
            this.crs = coordinateReferenceSystem;
            assert (this.crs.getCoordinateSystem().getDimension() == this.getDimension()) : this.crs;
            assert (envelope.getClass() != this.getClass() || this.equals(envelope)) : envelope;
        }
    }

    public void setToInfinite() {
        int n = this.beginIndex();
        int n2 = this.endIndex();
        int n3 = this.ordinates.length >>> 1;
        Arrays.fill(this.ordinates, n, n2, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.ordinates, n + n3, n2 + n3, Double.POSITIVE_INFINITY);
    }

    public void setToNaN() {
        Arrays.fill(this.ordinates, Double.NaN);
        assert (this.isAllNaN()) : this;
    }

    public void translate(double ... dArray) {
        ArgumentChecks.ensureNonNull((String)"vector", (Object)dArray);
        int n = this.beginIndex();
        ArgumentChecks.ensureDimensionMatches((String)"vector", (int)(this.endIndex() - n), (double[])dArray);
        int n2 = n + (this.ordinates.length >>> 1);
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            int n3 = n + i;
            this.ordinates[n3] = this.ordinates[n3] + d;
            int n4 = n2 + i;
            this.ordinates[n4] = this.ordinates[n4] + d;
        }
    }

    final void addSimple(double[] dArray, int n) {
        int n2 = this.ordinates.length >>> 1;
        for (int i = 0; i < n2; ++i) {
            double d = dArray[n + i];
            if (d < this.ordinates[i]) {
                this.ordinates[i] = d;
            }
            if (!(d > this.ordinates[i + n2])) continue;
            this.ordinates[i + n2] = d;
        }
    }

    public void add(DirectPosition directPosition) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"position", (Object)directPosition);
        int n = this.beginIndex();
        int n2 = this.endIndex() - n;
        ArgumentChecks.ensureDimensionMatches((String)"position", (int)n2, (DirectPosition)directPosition);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, directPosition.getCoordinateReferenceSystem(), true)) : directPosition;
        int n3 = this.ordinates.length >>> 1;
        for (int i = 0; i < n2; ++i) {
            int n4 = n + i;
            int n5 = n4 + n3;
            double d = directPosition.getOrdinate(i);
            double d2 = this.ordinates[n5];
            double d3 = this.ordinates[n4];
            if (!MathFunctions.isNegative((double)(d2 - d3))) {
                if (d < d3) {
                    this.ordinates[n4] = d;
                }
                if (!(d > d2)) continue;
                this.ordinates[n5] = d;
                continue;
            }
            this.addToClosest(n4, d, d2, d3);
        }
        assert (this.contains(directPosition) || this.isEmpty() || GeneralEnvelope.hasNaN(directPosition)) : directPosition;
    }

    private void addToClosest(int n, double d, double d2, double d3) {
        if ((d2 = d - d2) > 0.0 && (d3 -= d) > 0.0) {
            if (d3 > d2) {
                n += this.ordinates.length >>> 1;
            }
            this.ordinates[n] = d;
        }
    }

    public void add(Envelope envelope) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.beginIndex();
        int n2 = this.endIndex() - n;
        ArgumentChecks.ensureDimensionMatches((String)"envelope", (int)n2, (Envelope)envelope);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem(), true)) : envelope;
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope.getUpperCorner();
        int n3 = this.ordinates.length >>> 1;
        for (int i = 0; i < n2; ++i) {
            double d;
            double d2;
            boolean bl;
            int n4 = n + i;
            int n5 = n4 + n3;
            double d3 = this.ordinates[n4];
            double d4 = this.ordinates[n5];
            double d5 = directPosition.getOrdinate(i);
            double d6 = directPosition2.getOrdinate(i);
            boolean bl2 = MathFunctions.isNegative((double)(d4 - d3));
            if (bl2 == (bl = MathFunctions.isNegative((double)(d6 - d5)))) {
                if (d5 < d3) {
                    this.ordinates[n4] = d5;
                }
                if (d6 > d4) {
                    this.ordinates[n5] = d6;
                }
                if (!bl2 || GeneralEnvelope.isNegativeUnsafe(this.ordinates[n5] - this.ordinates[n4])) {
                    continue;
                }
            } else if (bl2) {
                if (d6 <= d4 || d5 >= d3) continue;
                d2 = d5 - d4;
                d = d3 - d6;
                if (d2 > 0.0 || d > 0.0) {
                    if (d2 > d) {
                        this.ordinates[n4] = d5;
                    }
                    if (!(d > d2)) continue;
                    this.ordinates[n5] = d6;
                    continue;
                }
            } else {
                if (d4 <= d6 || d3 >= d5) {
                    this.ordinates[n4] = d5;
                    this.ordinates[n5] = d6;
                    continue;
                }
                d2 = d3 - d6;
                d = d5 - d4;
                if (d2 > 0.0 || d > 0.0) {
                    if (d2 > d) {
                        this.ordinates[n5] = d6;
                    }
                    if (!(d > d2)) continue;
                    this.ordinates[n4] = d5;
                    continue;
                }
            }
            if (bl2) {
                this.ordinates[n4] = 0.0;
                this.ordinates[n5] = -0.0;
                continue;
            }
            this.ordinates[n4] = Double.NEGATIVE_INFINITY;
            this.ordinates[n5] = Double.POSITIVE_INFINITY;
        }
        assert (this.contains(envelope) || this.isEmpty() || GeneralEnvelope.hasNaN(envelope)) : this;
    }

    public void intersect(Envelope envelope) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.beginIndex();
        int n2 = this.endIndex() - n;
        ArgumentChecks.ensureDimensionMatches((String)"envelope", (int)n2, (Envelope)envelope);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem(), true)) : envelope;
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope.getUpperCorner();
        int n3 = this.ordinates.length >>> 1;
        block5: for (int i = n; i < n2; ++i) {
            int n4 = n + i;
            int n5 = n4 + n3;
            double d = this.ordinates[n4];
            double d2 = this.ordinates[n5];
            double d3 = directPosition.getOrdinate(i);
            double d4 = d2 - d;
            double d5 = directPosition2.getOrdinate(i);
            double d6 = d5 - d3;
            if (MathFunctions.isSameSign((double)d4, (double)d6)) {
                if ((d3 > d2 || d5 < d) && !GeneralEnvelope.isNegativeUnsafe(d4)) {
                    this.ordinates[n5] = Double.NaN;
                    this.ordinates[n4] = Double.NaN;
                    continue;
                }
            } else {
                int n6 = 0;
                if (!Double.isNaN(d4) && !Double.isNaN(d6)) {
                    if (GeneralEnvelope.isNegativeUnsafe(d4)) {
                        if (d3 <= d2) {
                            n6 = 1;
                            this.ordinates[n4] = d3;
                        }
                        if (d5 >= d) {
                            n6 |= 2;
                            this.ordinates[n5] = d5;
                        }
                    } else {
                        if (d <= d5) {
                            n6 = 1;
                        }
                        if (d2 >= d3) {
                            n6 |= 2;
                        }
                    }
                }
                switch (n6) {
                    default: {
                        throw new AssertionError(n6);
                    }
                    case 1: {
                        if (!(d5 < d2)) continue block5;
                        this.ordinates[n5] = d5;
                        break;
                    }
                    case 2: {
                        if (!(d3 > d)) continue block5;
                        this.ordinates[n4] = d3;
                        break;
                    }
                    case 0: 
                    case 3: {
                        double d7;
                        double d8;
                        double d9 = GeneralEnvelope.getSpan(GeneralEnvelope.getAxis(this.crs, i));
                        if (d6 >= d9) {
                            d8 = d;
                            d7 = d2;
                        } else if (d4 >= d9) {
                            d8 = d3;
                            d7 = d5;
                        } else {
                            d8 = Double.NaN;
                            d7 = Double.NaN;
                        }
                        this.ordinates[n4] = d8;
                        this.ordinates[n5] = d7;
                        break;
                    }
                }
                continue;
            }
            if (d3 > d) {
                this.ordinates[n4] = d3;
            }
            if (!(d5 < d2)) continue;
            this.ordinates[n5] = d5;
        }
        assert (this.isEmpty() || AbstractEnvelope.castOrCopy(envelope).contains(this)) : this;
    }

    public boolean normalize() {
        boolean bl = false;
        if (this.crs != null) {
            int n = this.ordinates.length >>> 1;
            int n2 = this.beginIndex();
            int n3 = this.endIndex() - n2;
            CoordinateSystem coordinateSystem = this.crs.getCoordinateSystem();
            for (int i = 0; i < n3; ++i) {
                double d;
                int n4 = n2 + i;
                int n5 = n4 + n;
                CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
                double d2 = coordinateSystemAxis.getMinimumValue();
                double d3 = coordinateSystemAxis.getMaximumValue();
                RangeMeaning rangeMeaning = coordinateSystemAxis.getRangeMeaning();
                if (RangeMeaning.EXACT.equals((Object)rangeMeaning)) {
                    if (this.ordinates[n4] < d2) {
                        this.ordinates[n4] = d2;
                        bl = true;
                    }
                    if (!(this.ordinates[n5] > d3)) continue;
                    this.ordinates[n5] = d3;
                    bl = true;
                    continue;
                }
                if (!RangeMeaning.WRAPAROUND.equals((Object)rangeMeaning) || !((d = d3 - d2) > 0.0) || !(d < Double.POSITIVE_INFINITY)) continue;
                double d4 = this.ordinates[n5];
                double d5 = this.ordinates[n4];
                if (Math.abs(d4 - d5) >= d) {
                    if (d5 == d2 && d4 == d3) continue;
                    if (d5 % d == 0.0 && d4 % d == 0.0) {
                        this.ordinates[n4] = 0.0;
                        this.ordinates[n5] = -0.0;
                    } else {
                        this.ordinates[n4] = d2;
                        this.ordinates[n5] = d3;
                    }
                    bl = true;
                    continue;
                }
                d5 = Math.floor((d5 - d2) / d) * d;
                d4 = Math.floor((d4 - d2) / d) * d;
                if (d5 != 0.0) {
                    int n6 = n4;
                    this.ordinates[n6] = this.ordinates[n6] - d5;
                    bl = true;
                }
                if (d4 == 0.0) continue;
                int n7 = n5;
                this.ordinates[n7] = this.ordinates[n7] - d4;
                bl = true;
            }
        }
        return bl;
    }

    public boolean simplify() throws IllegalStateException {
        boolean bl = false;
        int n = this.ordinates.length >>> 1;
        int n2 = this.beginIndex();
        int n3 = this.endIndex() - n2;
        for (int i = 0; i < n3; ++i) {
            int n4 = n2 + i;
            int n5 = n4 + n;
            double d = this.ordinates[n5];
            double d2 = this.ordinates[n4];
            if (!MathFunctions.isNegative((double)(d - d2))) continue;
            CoordinateSystemAxis coordinateSystemAxis = GeneralEnvelope.getAxis(this.crs, i);
            if (coordinateSystemAxis != null && RangeMeaning.WRAPAROUND.equals((Object)coordinateSystemAxis.getRangeMeaning())) {
                this.ordinates[n4] = coordinateSystemAxis.getMinimumValue();
                this.ordinates[n5] = coordinateSystemAxis.getMaximumValue();
                bl = true;
                continue;
            }
            throw new IllegalStateException(Errors.format((short)39, (Object)d2, (Object)d, (Object)(coordinateSystemAxis != null ? coordinateSystemAxis.getName() : Integer.valueOf(i))));
        }
        return bl;
    }

    public GeneralEnvelope subEnvelope(int n, int n2) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndexRange((int)(this.ordinates.length >>> 1), (int)n, (int)n2);
        return new SubEnvelope(this.ordinates, n, n2);
    }

    public GeneralEnvelope clone() {
        try {
            Field field = ordinatesField;
            if (field == null) {
                field = ArrayEnvelope.class.getDeclaredField("ordinates");
                field.setAccessible(true);
                ordinatesField = field;
            }
            GeneralEnvelope generalEnvelope = (GeneralEnvelope)super.clone();
            field.set(generalEnvelope, this.ordinates.clone());
            return generalEnvelope;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

