/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.awt.geom.Point2D;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DirectPosition2D
extends Point2D.Double
implements DirectPosition,
Cloneable {
    private static final long serialVersionUID = 6063110617109934018L;
    private CoordinateReferenceSystem crs;

    public DirectPosition2D() {
    }

    public DirectPosition2D(CoordinateReferenceSystem coordinateReferenceSystem) {
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)2, (CoordinateReferenceSystem)coordinateReferenceSystem);
        this.crs = coordinateReferenceSystem;
    }

    public DirectPosition2D(double d, double d2) {
        super(d, d2);
    }

    public DirectPosition2D(CoordinateReferenceSystem coordinateReferenceSystem, double d, double d2) {
        super(d, d2);
        this.crs = coordinateReferenceSystem;
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)2, (CoordinateReferenceSystem)coordinateReferenceSystem);
    }

    public DirectPosition2D(DirectPosition directPosition) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"position", (Object)directPosition);
        ArgumentChecks.ensureDimensionMatches((String)"position", (int)2, (DirectPosition)directPosition);
        this.x = directPosition.getOrdinate(0);
        this.y = directPosition.getOrdinate(1);
        this.crs = directPosition.getCoordinateReferenceSystem();
    }

    public DirectPosition2D(CharSequence charSequence) throws IllegalArgumentException {
        double[] dArray = AbstractDirectPosition.parse(charSequence);
        if (dArray == null) {
            throw new IllegalArgumentException(Errors.format((short)124, (Object)"POINT", (Object)charSequence));
        }
        ArgumentChecks.ensureDimensionMatches((String)"wkt", (int)2, (double[])dArray);
        this.x = dArray[0];
        this.y = dArray[1];
    }

    public final DirectPosition getDirectPosition() {
        return this;
    }

    public final int getDimension() {
        return 2;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)2, (CoordinateReferenceSystem)coordinateReferenceSystem);
        this.crs = coordinateReferenceSystem;
    }

    public final double[] getCoordinate() {
        return new double[]{this.x, this.y};
    }

    public final double getOrdinate(int n) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException(Errors.format((short)49, (Object)n));
    }

    public void setOrdinate(int n, double d) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                this.x = d;
                break;
            }
            case 1: {
                this.y = d;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Errors.format((short)49, (Object)n));
            }
        }
    }

    @Override
    public void setLocation(Point2D point2D) {
        CoordinateReferenceSystem coordinateReferenceSystem;
        super.setLocation(point2D);
        if (point2D instanceof DirectPosition && (coordinateReferenceSystem = ((DirectPosition)point2D).getCoordinateReferenceSystem()) != null) {
            this.setCoordinateReferenceSystem(coordinateReferenceSystem);
        }
    }

    @Override
    public String toString() {
        return AbstractDirectPosition.toString(this, AbstractDirectPosition.isSimplePrecision(this.x, this.y));
    }

    @Override
    public int hashCode() {
        int n = 31 + Numerics.hashCode((long)Double.doubleToLongBits(this.x));
        n = n * 31 + Numerics.hashCode((long)Double.doubleToLongBits(this.y));
        return n + Objects.hashCode((Object)this.crs);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DirectPosition) {
            DirectPosition directPosition = (DirectPosition)object;
            if (directPosition.getDimension() == 2 && Double.doubleToLongBits(directPosition.getOrdinate(0)) == Double.doubleToLongBits(this.x) && Double.doubleToLongBits(directPosition.getOrdinate(1)) == Double.doubleToLongBits(this.y) && Objects.equals((Object)directPosition.getCoordinateReferenceSystem(), (Object)this.crs)) {
                assert (this.hashCode() == directPosition.hashCode()) : this;
                return true;
            }
            return false;
        }
        return super.equals(object);
    }

    @Override
    public DirectPosition2D clone() {
        return (DirectPosition2D)super.clone();
    }
}

