/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.netty.NettyRpcProxy;
import org.apache.ratis.netty.server.NettyRpcService;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.netty.NettyProtos;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.RaftServerRpcWithProxy;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.io.netty.bootstrap.ServerBootstrap;
import org.apache.ratis.thirdparty.io.netty.channel.Channel;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.ratis.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.ratis.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.ratis.thirdparty.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.ratis.thirdparty.io.netty.handler.logging.LogLevel;
import org.apache.ratis.thirdparty.io.netty.handler.logging.LoggingHandler;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.ProtoUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class NettyRpcService
extends RaftServerRpcWithProxy<NettyRpcProxy, NettyRpcProxy.PeerMap> {
    static final String CLASS_NAME = NettyRpcService.class.getSimpleName();
    public static final String SEND_SERVER_REQUEST = CLASS_NAME + ".sendServerRequest";
    private final RaftServer server;
    private final EventLoopGroup bossGroup = new NioEventLoopGroup();
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private final ChannelFuture channelFuture;

    public static Builder newBuilder() {
        return new Builder(null);
    }

    private NettyRpcService(RaftServer server) {
        super(() -> ((RaftServer)server).getId(), id -> new NettyRpcProxy.PeerMap(id.toString()));
        this.server = server;
        1 initializer = new /* Unavailable Anonymous Inner Class!! */;
        int port = NettyConfigKeys.Server.port((RaftProperties)server.getProperties());
        this.channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)initializer).bind(port);
    }

    public SupportedRpcType getRpcType() {
        return SupportedRpcType.NETTY;
    }

    private Channel getChannel() {
        return this.channelFuture.awaitUninterruptibly().channel();
    }

    public void startImpl() throws IOException {
        try {
            this.channelFuture.syncUninterruptibly();
        }
        catch (Throwable t) {
            throw new IOException(this.getId() + ": Failed to start " + this.getClass().getSimpleName(), t);
        }
    }

    public void closeImpl() throws IOException {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        ChannelFuture f = this.getChannel().close();
        super.closeImpl();
        f.syncUninterruptibly();
    }

    public InetSocketAddress getInetSocketAddress() {
        return (InetSocketAddress)this.getChannel().localAddress();
    }

    NettyProtos.RaftNettyServerReplyProto handle(NettyProtos.RaftNettyServerRequestProto proto) {
        RaftProtos.RaftRpcRequestProto rpcRequest = null;
        try {
            switch (2.$SwitchMap$org$apache$ratis$proto$netty$NettyProtos$RaftNettyServerRequestProto$RaftNettyServerRequestCase[proto.getRaftNettyServerRequestCase().ordinal()]) {
                case 1: {
                    RaftProtos.RequestVoteRequestProto request = proto.getRequestVoteRequest();
                    rpcRequest = request.getServerRequest();
                    RaftProtos.RequestVoteReplyProto reply = this.server.requestVote(request);
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRequestVoteReply(reply).build();
                }
                case 2: {
                    RaftProtos.AppendEntriesRequestProto request = proto.getAppendEntriesRequest();
                    rpcRequest = request.getServerRequest();
                    RaftProtos.AppendEntriesReplyProto reply = this.server.appendEntries(request);
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setAppendEntriesReply(reply).build();
                }
                case 3: {
                    RaftProtos.InstallSnapshotRequestProto request = proto.getInstallSnapshotRequest();
                    rpcRequest = request.getServerRequest();
                    RaftProtos.InstallSnapshotReplyProto reply = this.server.installSnapshot(request);
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setInstallSnapshotReply(reply).build();
                }
                case 4: {
                    RaftProtos.RaftClientRequestProto request = proto.getRaftClientRequest();
                    rpcRequest = request.getRpcRequest();
                    RaftClientReply reply = this.server.submitClientRequest(ClientProtoUtils.toRaftClientRequest((RaftProtos.RaftClientRequestProto)request));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)reply)).build();
                }
                case 5: {
                    RaftProtos.SetConfigurationRequestProto request = proto.getSetConfigurationRequest();
                    rpcRequest = request.getRpcRequest();
                    RaftClientReply reply = this.server.setConfiguration(ClientProtoUtils.toSetConfigurationRequest((RaftProtos.SetConfigurationRequestProto)request));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)reply)).build();
                }
                case 6: {
                    RaftProtos.GroupManagementRequestProto request = proto.getGroupManagementRequest();
                    rpcRequest = request.getRpcRequest();
                    RaftClientReply reply = this.server.groupManagement(ClientProtoUtils.toGroupManagementRequest((RaftProtos.GroupManagementRequestProto)request));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)reply)).build();
                }
                case 7: {
                    RaftProtos.GroupListRequestProto request = proto.getGroupListRequest();
                    rpcRequest = request.getRpcRequest();
                    GroupListReply reply = this.server.getGroupList(ClientProtoUtils.toGroupListRequest((RaftProtos.GroupListRequestProto)request));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setGroupListReply(ClientProtoUtils.toGroupListReplyProto((GroupListReply)reply)).build();
                }
                case 8: {
                    RaftProtos.GroupInfoRequestProto request = proto.getGroupInfoRequest();
                    rpcRequest = request.getRpcRequest();
                    GroupInfoReply reply = this.server.getGroupInfo(ClientProtoUtils.toGroupInfoRequest((RaftProtos.GroupInfoRequestProto)request));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setGroupInfoReply(ClientProtoUtils.toGroupInfoReplyProto((GroupInfoReply)reply)).build();
                }
                case 9: {
                    throw new IllegalArgumentException("Request case not set in proto: " + proto.getRaftNettyServerRequestCase());
                }
            }
            throw new UnsupportedOperationException("Request case not supported: " + proto.getRaftNettyServerRequestCase());
        }
        catch (IOException ioe) {
            return NettyRpcService.toRaftNettyServerReplyProto((RaftProtos.RaftRpcRequestProto)Objects.requireNonNull(rpcRequest, "rpcRequest = null"), (IOException)ioe);
        }
    }

    private static NettyProtos.RaftNettyServerReplyProto toRaftNettyServerReplyProto(RaftProtos.RaftRpcRequestProto request, IOException e) {
        RaftProtos.RaftRpcReplyProto.Builder rpcReply = RaftProtos.RaftRpcReplyProto.newBuilder().setRequestorId(request.getRequestorId()).setReplyId(request.getReplyId()).setCallId(request.getCallId()).setSuccess(false);
        NettyProtos.RaftNettyExceptionReplyProto.Builder ioe = NettyProtos.RaftNettyExceptionReplyProto.newBuilder().setRpcReply(rpcReply).setException(ProtoUtils.writeObject2ByteString((Object)e));
        return NettyProtos.RaftNettyServerReplyProto.newBuilder().setExceptionReply(ioe).build();
    }

    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) throws IOException {
        CodeInjectionForTesting.execute((String)SEND_SERVER_REQUEST, (Object)this.getId(), null, (Object[])new Object[]{request});
        NettyProtos.RaftNettyServerRequestProto proto = NettyProtos.RaftNettyServerRequestProto.newBuilder().setRequestVoteRequest(request).build();
        RaftProtos.RaftRpcRequestProto serverRequest = request.getServerRequest();
        return this.sendRaftNettyServerRequestProto(serverRequest, proto).getRequestVoteReply();
    }

    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto request) throws IOException {
        CodeInjectionForTesting.execute((String)SEND_SERVER_REQUEST, (Object)this.getId(), null, (Object[])new Object[]{request});
        NettyProtos.RaftNettyServerRequestProto proto = NettyProtos.RaftNettyServerRequestProto.newBuilder().setAppendEntriesRequest(request).build();
        RaftProtos.RaftRpcRequestProto serverRequest = request.getServerRequest();
        return this.sendRaftNettyServerRequestProto(serverRequest, proto).getAppendEntriesReply();
    }

    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        CodeInjectionForTesting.execute((String)SEND_SERVER_REQUEST, (Object)this.getId(), null, (Object[])new Object[]{request});
        NettyProtos.RaftNettyServerRequestProto proto = NettyProtos.RaftNettyServerRequestProto.newBuilder().setInstallSnapshotRequest(request).build();
        RaftProtos.RaftRpcRequestProto serverRequest = request.getServerRequest();
        return this.sendRaftNettyServerRequestProto(serverRequest, proto).getInstallSnapshotReply();
    }

    private NettyProtos.RaftNettyServerReplyProto sendRaftNettyServerRequestProto(RaftProtos.RaftRpcRequestProto request, NettyProtos.RaftNettyServerRequestProto proto) throws IOException {
        RaftPeerId id = RaftPeerId.valueOf((ByteString)request.getReplyId());
        try {
            NettyRpcProxy p = (NettyRpcProxy)((NettyRpcProxy.PeerMap)this.getProxies()).getProxy(id);
            return p.send(request, proto);
        }
        catch (Exception e) {
            ((NettyRpcProxy.PeerMap)this.getProxies()).handleException(id, (Throwable)e, false);
            throw e;
        }
    }
}

