/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.ratis.netty.NettyRpcProxy;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.netty.NettyProtos;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.ratis.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.ProtoUtils;

public class NettyRpcProxy
implements Closeable {
    private final RaftPeer peer;
    private final Connection connection;

    public static long getCallId(NettyProtos.RaftNettyServerReplyProto proto) {
        switch (1.$SwitchMap$org$apache$ratis$proto$netty$NettyProtos$RaftNettyServerReplyProto$RaftNettyServerReplyCase[proto.getRaftNettyServerReplyCase().ordinal()]) {
            case 1: {
                return proto.getRequestVoteReply().getServerReply().getCallId();
            }
            case 2: {
                return proto.getAppendEntriesReply().getServerReply().getCallId();
            }
            case 3: {
                return proto.getInstallSnapshotReply().getServerReply().getCallId();
            }
            case 4: {
                return proto.getRaftClientReply().getRpcReply().getCallId();
            }
            case 5: {
                return proto.getExceptionReply().getRpcReply().getCallId();
            }
            case 6: {
                throw new IllegalArgumentException("Reply case not set in proto: " + proto.getRaftNettyServerReplyCase());
            }
        }
        throw new UnsupportedOperationException("Reply case not supported: " + proto.getRaftNettyServerReplyCase());
    }

    public NettyRpcProxy(RaftPeer peer, EventLoopGroup group) throws InterruptedException {
        this.peer = peer;
        this.connection = new Connection(this, group);
    }

    @Override
    public void close() {
        this.connection.close();
    }

    public NettyProtos.RaftNettyServerReplyProto send(RaftProtos.RaftRpcRequestProto request, NettyProtos.RaftNettyServerRequestProto proto) throws IOException {
        CompletableFuture reply = new CompletableFuture();
        ChannelFuture channelFuture = this.connection.offer(proto, reply);
        try {
            channelFuture.sync();
            return (NettyProtos.RaftNettyServerReplyProto)reply.get();
        }
        catch (InterruptedException e) {
            throw IOUtils.toInterruptedIOException((String)(ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request) + " sending from " + this.peer + " is interrupted."), (InterruptedException)e);
        }
        catch (ExecutionException e) {
            throw IOUtils.toIOException((ExecutionException)e);
        }
    }

    static /* synthetic */ RaftPeer access$000(NettyRpcProxy x0) {
        return x0.peer;
    }
}

