/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.rat.Defaults;
import org.apache.rat.Report;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.util.HeaderMatcherMultiplexer;
import org.apache.rat.api.RatException;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.mp.FilesReportable;
import org.apache.rat.mp.HeaderMatcherSpecification;
import org.apache.rat.mp.LicenseFamilySpecification;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.claim.ClaimStatistic;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRatMojo
extends AbstractMojo {
    public static final String[] MAVEN_DEFAULT_EXCLUDES = new String[]{"target/**/*", "cobertura.ser", "release.properties", "pom.xml.releaseBackup"};
    public static final String[] ECLIPSE_DEFAULT_EXCLUDES = new String[]{".classpath", ".project", ".settings/**/*"};
    public static final String[] IDEA_DEFAULT_EXCLUDES = new String[]{"*.iml", "*.ipr", "*.iws", ".idea/**/*"};
    @Parameter(property="rat.basedir", defaultValue="${basedir}", required=true)
    protected File basedir;
    @Parameter
    private HeaderMatcherSpecification[] licenseMatchers;
    @Parameter
    private IHeaderMatcher[] licenses;
    private LicenseFamilySpecification[] licenseFamilyNames;
    @Parameter
    private ILicenseFamily[] licenseFamilies;
    @Parameter(property="rat.addDefaultLicenseMatchers", defaultValue="true")
    private boolean addDefaultLicenseMatchers;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(property="rat.useDefaultExcludes", defaultValue="true")
    private boolean useDefaultExcludes;
    @Parameter(property="rat.useMavenDefaultExcludes", defaultValue="true")
    private boolean useMavenDefaultExcludes;
    @Parameter(property="rat.useEclipseDefaultExcludes", defaultValue="true")
    private boolean useEclipseDefaultExcludes;
    @Parameter(property="rat.useIdeaDefaultExcludes", defaultValue="true")
    private boolean useIdeaDefaultExcludes;
    @Parameter(property="rat.excludeSubprojects", defaultValue="true")
    private boolean excludeSubProjects;
    @Component
    private MavenProject project;

    protected MavenProject getProject() {
        return this.project;
    }

    protected IHeaderMatcher[] getLicenseMatchers() throws MojoFailureException, MojoExecutionException {
        ArrayList<IHeaderMatcher> list = new ArrayList<IHeaderMatcher>();
        if (this.licenses != null) {
            list.addAll(Arrays.asList(this.licenses));
        }
        if (this.licenseMatchers != null) {
            for (HeaderMatcherSpecification spec : this.licenseMatchers) {
                String className = spec.getClassName();
                IHeaderMatcher headerMatcher = this.newInstance(IHeaderMatcher.class, className);
                list.add(headerMatcher);
            }
        }
        if (this.addDefaultLicenseMatchers) {
            list.addAll(Arrays.asList(Defaults.DEFAULT_MATCHERS));
        }
        return list.toArray(new IHeaderMatcher[list.size()]);
    }

    private <T> T newInstance(Class<T> clazz, String className) throws MojoExecutionException, MojoFailureException {
        Object o;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            o = cl.loadClass(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException("Failed to instantiate class " + className + ": " + e.getMessage(), (Exception)e);
        }
        catch (ClassCastException e) {
            throw new MojoExecutionException("The class " + className + " is not implementing " + clazz.getName() + ": " + e.getMessage(), (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Illegal access to class " + className + ": " + e.getMessage(), (Exception)e);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Class " + className + " not found: " + e.getMessage(), (Exception)e);
        }
        if (!clazz.isAssignableFrom(o.getClass())) {
            throw new MojoFailureException("The class " + o.getClass().getName() + " does not implement " + clazz.getName());
        }
        return (T)o;
    }

    private void add(List<String> pList, String[] pArray) {
        if (pArray != null) {
            Collections.addAll(pList, pArray);
        }
    }

    protected IReportable getResources() {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.basedir);
        this.setExcludes(ds);
        this.setIncludes(ds);
        ds.scan();
        this.whenDebuggingLogExcludedFiles(ds);
        String[] files = ds.getIncludedFiles();
        this.logAboutIncludedFiles(files);
        try {
            return new FilesReportable(this.basedir, files);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private void logAboutIncludedFiles(String[] files) {
        if (files.length == 0) {
            this.getLog().warn((CharSequence)"No resources included.");
        } else {
            this.getLog().info((CharSequence)(files.length + " resources included (use -debug for more details)"));
            if (this.getLog().isDebugEnabled()) {
                for (String resource : files) {
                    this.getLog().debug((CharSequence)(" - included " + resource));
                }
            }
        }
    }

    private void whenDebuggingLogExcludedFiles(DirectoryScanner ds) {
        if (this.getLog().isDebugEnabled()) {
            String[] excludedFiles = ds.getExcludedFiles();
            if (excludedFiles.length == 0) {
                this.getLog().debug((CharSequence)"No excluded resources.");
            } else {
                this.getLog().debug((CharSequence)("Excluded " + excludedFiles.length + " resources:"));
                for (String resource : excludedFiles) {
                    this.getLog().debug((CharSequence)(" - excluded " + resource));
                }
            }
        }
    }

    private void setIncludes(DirectoryScanner ds) {
        if (this.includes != null) {
            ds.setIncludes(this.includes);
        }
    }

    private void setExcludes(DirectoryScanner ds) {
        List<String> excludeList = this.buildDefaultExclusions();
        if (this.excludes == null || this.excludes.length == 0) {
            this.getLog().info((CharSequence)"No excludes explicitly specified.");
        } else {
            for (String exclude : this.excludes) {
                this.getLog().info((CharSequence)("Exclude: " + exclude));
            }
        }
        this.add(excludeList, this.excludes);
        if (!excludeList.isEmpty()) {
            String[] allExcludes = excludeList.toArray(new String[excludeList.size()]);
            ds.setExcludes(allExcludes);
        }
    }

    private List<String> buildDefaultExclusions() {
        ArrayList<String> results = new ArrayList<String>();
        this.addPlexusDefaults(results);
        this.addMavenDefaults(results);
        this.addEclipseDefaults(results);
        this.addIdeaDefaults(results);
        if (this.excludeSubProjects && this.project != null && this.project.getModules() != null) {
            for (Object o : this.project.getModules()) {
                String moduleSubPath = (String)o;
                results.add(moduleSubPath + "/**/*");
            }
        }
        this.getLog().debug((CharSequence)"Finished creating list of implicit excludes.");
        if (results.isEmpty()) {
            this.getLog().info((CharSequence)"No excludes implicitly specified.");
        } else {
            this.getLog().info((CharSequence)(results.size() + " implicit excludes (use -debug for more details)."));
            for (String exclude : results) {
                this.getLog().debug((CharSequence)("Implicit exclude: " + exclude));
            }
        }
        return results;
    }

    private void addPlexusDefaults(List<String> excludeList1) {
        if (this.useDefaultExcludes) {
            this.getLog().debug((CharSequence)"Adding plexus default exclusions...");
            this.add(excludeList1, DirectoryScanner.DEFAULTEXCLUDES);
        } else {
            this.getLog().debug((CharSequence)"rat.useDefaultExcludes set to false. Plexus default exclusions will not be added");
        }
    }

    private void addMavenDefaults(List<String> excludeList1) {
        if (this.useMavenDefaultExcludes) {
            this.getLog().debug((CharSequence)"Adding exclusions often needed by Maven projects...");
            this.add(excludeList1, MAVEN_DEFAULT_EXCLUDES);
        } else {
            this.getLog().debug((CharSequence)"rat.useMavenDefaultExcludes set to false. Exclusions often needed by Maven projects will not be added.");
        }
    }

    private void addEclipseDefaults(List<String> excludeList1) {
        if (this.useEclipseDefaultExcludes) {
            this.getLog().debug((CharSequence)"Adding exclusions often needed by projects developed in Eclipse...");
            this.add(excludeList1, ECLIPSE_DEFAULT_EXCLUDES);
        } else {
            this.getLog().debug((CharSequence)"rat.useEclipseDefaultExcludes set to false. Exclusions often needed by projects developed in Eclipse will not be added.");
        }
    }

    private void addIdeaDefaults(List<String> excludeList1) {
        if (this.useIdeaDefaultExcludes) {
            this.getLog().debug((CharSequence)"Adding exclusions often needed by projects developed in IDEA...");
            this.add(excludeList1, IDEA_DEFAULT_EXCLUDES);
        } else {
            this.getLog().debug((CharSequence)"rat.useIdeaDefaultExcludes set to false. Exclusions often needed by projects developed in IDEA will not be added.");
        }
    }

    protected ClaimStatistic createReport(Writer out, InputStream style) throws MojoExecutionException, MojoFailureException {
        ReportConfiguration configuration = this.getConfiguration();
        try {
            if (style != null) {
                return Report.report((Writer)out, (IReportable)this.getResources(), (InputStream)style, (ReportConfiguration)configuration);
            }
            return Report.report((IReportable)this.getResources(), (Writer)out, (ReportConfiguration)configuration);
        }
        catch (TransformerConfigurationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (RatException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected ReportConfiguration getConfiguration() throws MojoFailureException, MojoExecutionException {
        ReportConfiguration configuration = new ReportConfiguration();
        configuration.setHeaderMatcher((IHeaderMatcher)new HeaderMatcherMultiplexer(this.getLicenseMatchers()));
        configuration.setApprovedLicenseNames(this.getApprovedLicenseNames());
        return configuration;
    }

    private ILicenseFamily[] getApprovedLicenseNames() throws MojoExecutionException, MojoFailureException {
        ArrayList<ILicenseFamily> list = new ArrayList<ILicenseFamily>();
        if (this.licenseFamilies != null) {
            list.addAll(Arrays.asList(this.licenseFamilies));
        }
        if (this.licenseFamilyNames != null) {
            for (LicenseFamilySpecification spec : this.licenseFamilyNames) {
                list.add(this.newInstance(ILicenseFamily.class, spec.getClassName()));
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new ILicenseFamily[list.size()]);
    }
}

