/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.lazytestprovider;

import java.io.IOException;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.AbstractForkInputStream;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.MasterProcessCommand;

public abstract class AbstractCommandStream
extends AbstractForkInputStream {
    private byte[] currentBuffer;
    private int currentPos;

    protected abstract boolean isClosed();

    protected boolean canContinue() {
        return !this.isClosed();
    }

    protected void beforeNextCommand() throws IOException {
    }

    protected abstract Command nextCommand();

    protected final void invalidateInternalBuffer() {
        this.currentBuffer = null;
        this.currentPos = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.isClosed()) {
            this.tryFlush();
            return -1;
        }
        if (this.currentBuffer == null) {
            this.tryFlush();
            if (!this.canContinue()) {
                this.close();
                return -1;
            }
            this.beforeNextCommand();
            if (this.isClosed()) {
                return -1;
            }
            Command cmd = this.nextCommand();
            MasterProcessCommand cmdType = cmd.getCommandType();
            this.currentBuffer = cmdType.hasDataType() ? cmdType.encode(cmd.getData()) : cmdType.encode();
        }
        int b = this.currentBuffer[this.currentPos++] & 0xFF;
        if (this.currentPos == this.currentBuffer.length) {
            this.currentBuffer = null;
            this.currentPos = 0;
        }
        return b;
    }
}

