/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;

public class RequireFileChecksum
extends AbstractNonCacheableEnforcerRule {
    protected File file;
    private String checksum;
    private String type;
    private String nonexistentFileMessage;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        if (this.file == null) {
            throw new EnforcerRuleException("Input file unspecified");
        }
        if (this.type == null) {
            throw new EnforcerRuleException("Hash type unspecified");
        }
        if (this.checksum == null) {
            throw new EnforcerRuleException("Checksum unspecified");
        }
        if (!this.file.exists()) {
            String message = this.nonexistentFileMessage;
            if (message == null) {
                message = "File does not exist: " + this.file.getAbsolutePath();
            }
            throw new EnforcerRuleException(message);
        }
        if (this.file.isDirectory()) {
            throw new EnforcerRuleException("Cannot calculate the checksum of directory: " + this.file.getAbsolutePath());
        }
        if (!this.file.canRead()) {
            throw new EnforcerRuleException("Cannot read file: " + this.file.getAbsolutePath());
        }
        String checksum = this.calculateChecksum();
        if (!checksum.equalsIgnoreCase(this.checksum)) {
            String exceptionMessage = this.getMessage();
            if (exceptionMessage == null) {
                exceptionMessage = this.type + " hash of " + this.file + " was " + checksum + " but expected " + this.checksum;
            }
            throw new EnforcerRuleException(exceptionMessage);
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setNonexistentFileMessage(String nonexistentFileMessage) {
        this.nonexistentFileMessage = nonexistentFileMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String calculateChecksum() throws EnforcerRuleException {
        try (FileInputStream inputStream = new FileInputStream(this.file);){
            String string = this.calculateChecksum(inputStream);
            return string;
        }
        catch (IOException e) {
            throw new EnforcerRuleException("Unable to calculate checksum", (Exception)e);
        }
    }

    protected String calculateChecksum(InputStream inputStream) throws IOException, EnforcerRuleException {
        String checksum;
        if ("md5".equals(this.type)) {
            checksum = DigestUtils.md5Hex((InputStream)inputStream);
        } else if ("sha1".equals(this.type)) {
            checksum = DigestUtils.sha1Hex((InputStream)inputStream);
        } else if ("sha256".equals(this.type)) {
            checksum = DigestUtils.sha256Hex((InputStream)inputStream);
        } else if ("sha384".equals(this.type)) {
            checksum = DigestUtils.sha384Hex((InputStream)inputStream);
        } else if ("sha512".equals(this.type)) {
            checksum = DigestUtils.sha512Hex((InputStream)inputStream);
        } else {
            throw new EnforcerRuleException("Unsupported hash type: " + this.type);
        }
        return checksum;
    }
}

