/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.core.AbstractLogEvent;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicyFactory;
import org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.Constants;

@Plugin(name="Async", category="Core", elementType="appender", printObject=true)
public final class AsyncAppender
extends AbstractAppender {
    private static final int DEFAULT_QUEUE_SIZE = 128;
    private static final LogEvent SHUTDOWN = new AbstractLogEvent(){};
    private static final AtomicLong THREAD_SEQUENCE = new AtomicLong(1L);
    private final BlockingQueue<LogEvent> queue;
    private final int queueSize;
    private final boolean blocking;
    private final long shutdownTimeout;
    private final Configuration config;
    private final AppenderRef[] appenderRefs;
    private final String errorRef;
    private final boolean includeLocation;
    private AppenderControl errorAppender;
    private AsyncThread thread;
    private AsyncQueueFullPolicy asyncQueueFullPolicy;

    private AsyncAppender(String name, Filter filter, AppenderRef[] appenderRefs, String errorRef, int queueSize, boolean blocking, boolean ignoreExceptions, long shutdownTimeout, Configuration config, boolean includeLocation) {
        super(name, filter, null, ignoreExceptions);
        this.queue = new ArrayBlockingQueue<LogEvent>(queueSize);
        this.queueSize = queueSize;
        this.blocking = blocking;
        this.shutdownTimeout = shutdownTimeout;
        this.config = config;
        this.appenderRefs = appenderRefs;
        this.errorRef = errorRef;
        this.includeLocation = includeLocation;
    }

    @Override
    public void start() {
        Map<String, Appender> map = this.config.getAppenders();
        ArrayList<AppenderControl> appenders = new ArrayList<AppenderControl>();
        for (AppenderRef appenderRef : this.appenderRefs) {
            Appender appender = map.get(appenderRef.getRef());
            if (appender != null) {
                appenders.add(new AppenderControl(appender, appenderRef.getLevel(), appenderRef.getFilter()));
                continue;
            }
            LOGGER.error("No appender named {} was configured", (Object)appenderRef);
        }
        if (this.errorRef != null) {
            Appender appender = map.get(this.errorRef);
            if (appender != null) {
                this.errorAppender = new AppenderControl(appender, null, null);
            } else {
                LOGGER.error("Unable to set up error Appender. No appender named {} was configured", (Object)this.errorRef);
            }
        }
        if (appenders.size() > 0) {
            this.thread = new AsyncThread(appenders, this.queue);
            this.thread.setName("AsyncAppender-" + this.getName());
        } else if (this.errorRef == null) {
            throw new ConfigurationException("No appenders are available for AsyncAppender " + this.getName());
        }
        this.asyncQueueFullPolicy = AsyncQueueFullPolicyFactory.create();
        this.thread.start();
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        LOGGER.trace("AsyncAppender stopping. Queue still has {} events.", (Object)this.queue.size());
        this.thread.shutdown();
        try {
            this.thread.join(this.shutdownTimeout);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Interrupted while stopping AsyncAppender {}", (Object)this.getName());
        }
        LOGGER.trace("AsyncAppender stopped. Queue has {} events.", (Object)this.queue.size());
        if (DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy) > 0L) {
            LOGGER.trace("AsyncAppender: {} discarded {} events.", (Object)this.asyncQueueFullPolicy, (Object)DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy));
        }
    }

    @Override
    public void append(LogEvent logEvent) {
        Log4jLogEvent memento;
        if (!this.isStarted()) {
            throw new IllegalStateException("AsyncAppender " + this.getName() + " is not active");
        }
        if (!Constants.FORMAT_MESSAGES_IN_BACKGROUND) {
            logEvent.getMessage().getFormattedMessage();
        }
        if (!this.queue.offer(memento = Log4jLogEvent.createMemento(logEvent, this.includeLocation))) {
            if (this.blocking) {
                EventRoute route = this.asyncQueueFullPolicy.getRoute(this.thread.getId(), memento.getLevel());
                route.logMessage(this, (LogEvent)memento);
            } else {
                this.error("Appender " + this.getName() + " is unable to write primary appenders. queue is full");
                this.logToErrorAppenderIfNecessary(false, memento);
            }
        }
    }

    public void logMessageInCurrentThread(LogEvent logEvent) {
        logEvent.setEndOfBatch(this.queue.isEmpty());
        boolean appendSuccessful = this.thread.callAppenders(logEvent);
        this.logToErrorAppenderIfNecessary(appendSuccessful, logEvent);
    }

    public void logMessageInBackgroundThread(LogEvent logEvent) {
        try {
            this.queue.put(logEvent);
        }
        catch (InterruptedException e) {
            boolean appendSuccessful = this.handleInterruptedException(logEvent);
            this.logToErrorAppenderIfNecessary(appendSuccessful, logEvent);
        }
    }

    private boolean handleInterruptedException(LogEvent memento) {
        boolean appendSuccessful = this.queue.offer(memento);
        if (!appendSuccessful) {
            LOGGER.warn("Interrupted while waiting for a free slot in the AsyncAppender LogEvent-queue {}", (Object)this.getName());
        }
        Thread.currentThread().interrupt();
        return appendSuccessful;
    }

    private void logToErrorAppenderIfNecessary(boolean appendSuccessful, LogEvent logEvent) {
        if (!appendSuccessful && this.errorAppender != null) {
            this.errorAppender.callAppender(logEvent);
        }
    }

    @PluginFactory
    public static AsyncAppender createAppender(@PluginElement(value="AppenderRef") AppenderRef[] appenderRefs, @PluginAttribute(value="errorRef") @PluginAliases(value={"error-ref"}) String errorRef, @PluginAttribute(value="blocking", defaultBoolean=true) boolean blocking, @PluginAttribute(value="shutdownTimeout", defaultLong=0L) long shutdownTimeout, @PluginAttribute(value="bufferSize", defaultInt=128) int size, @PluginAttribute(value="name") String name, @PluginAttribute(value="includeLocation", defaultBoolean=false) boolean includeLocation, @PluginElement(value="Filter") Filter filter, @PluginConfiguration Configuration config, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) boolean ignoreExceptions) {
        if (name == null) {
            LOGGER.error("No name provided for AsyncAppender");
            return null;
        }
        if (appenderRefs == null) {
            LOGGER.error("No appender references provided to AsyncAppender {}", (Object)name);
        }
        return new AsyncAppender(name, filter, appenderRefs, errorRef, size, blocking, ignoreExceptions, shutdownTimeout, config, includeLocation);
    }

    public String[] getAppenderRefStrings() {
        String[] result = new String[this.appenderRefs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.appenderRefs[i].getRef();
        }
        return result;
    }

    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public String getErrorRef() {
        return this.errorRef;
    }

    public int getQueueCapacity() {
        return this.queueSize;
    }

    public int getQueueRemainingCapacity() {
        return this.queue.remainingCapacity();
    }

    private class AsyncThread
    extends Thread {
        private volatile boolean shutdown = false;
        private final List<AppenderControl> appenders;
        private final BlockingQueue<LogEvent> queue;

        public AsyncThread(List<AppenderControl> appenders, BlockingQueue<LogEvent> queue) {
            this.appenders = appenders;
            this.queue = queue;
            this.setDaemon(true);
            this.setName("AsyncAppenderThread" + THREAD_SEQUENCE.getAndIncrement());
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                LogEvent event;
                try {
                    event = this.queue.take();
                    if (event == SHUTDOWN) {
                        this.shutdown = true;
                        continue;
                    }
                }
                catch (InterruptedException ex) {
                    break;
                }
                event.setEndOfBatch(this.queue.isEmpty());
                boolean success = this.callAppenders(event);
                if (success || AsyncAppender.this.errorAppender == null) continue;
                try {
                    AsyncAppender.this.errorAppender.callAppender(event);
                }
                catch (Exception exception) {}
            }
            LOGGER.trace("AsyncAppender.AsyncThread shutting down. Processing remaining {} queue events.", (Object)this.queue.size());
            int count = 0;
            int ignored = 0;
            while (!this.queue.isEmpty()) {
                try {
                    LogEvent event = this.queue.take();
                    if (event instanceof Log4jLogEvent) {
                        Log4jLogEvent logEvent = (Log4jLogEvent)event;
                        logEvent.setEndOfBatch(this.queue.isEmpty());
                        this.callAppenders(logEvent);
                        ++count;
                        continue;
                    }
                    ++ignored;
                    LOGGER.trace("Ignoring event of class {}", (Object)event.getClass().getName());
                }
                catch (InterruptedException interruptedException) {}
            }
            LOGGER.trace("AsyncAppender.AsyncThread stopped. Queue has {} events remaining. Processed {} and ignored {} events since shutdown started.", (Object)this.queue.size(), (Object)count, (Object)ignored);
        }

        boolean callAppenders(LogEvent event) {
            boolean success = false;
            for (AppenderControl control : this.appenders) {
                try {
                    control.callAppender(event);
                    success = true;
                }
                catch (Exception exception) {}
            }
            return success;
        }

        public void shutdown() {
            this.shutdown = true;
            if (this.queue.isEmpty()) {
                this.queue.offer(SHUTDOWN);
            }
        }
    }
}

