/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.PriorityQueue;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.internals.ProcessorNodePunctuator;
import org.apache.kafka.streams.processor.internals.PunctuationSchedule;

public class PunctuationQueue {
    private final PriorityQueue<PunctuationSchedule> pq = new PriorityQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cancellable schedule(PunctuationSchedule sched) {
        PriorityQueue<PunctuationSchedule> priorityQueue = this.pq;
        synchronized (priorityQueue) {
            this.pq.add(sched);
        }
        return sched.cancellable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        PriorityQueue<PunctuationSchedule> priorityQueue = this.pq;
        synchronized (priorityQueue) {
            this.pq.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mayPunctuate(long timestamp, PunctuationType type, ProcessorNodePunctuator processorNodePunctuator) {
        PriorityQueue<PunctuationSchedule> priorityQueue = this.pq;
        synchronized (priorityQueue) {
            boolean punctuated = false;
            PunctuationSchedule top = this.pq.peek();
            while (top != null && top.timestamp <= timestamp) {
                PunctuationSchedule sched = top;
                this.pq.poll();
                if (!sched.isCancelled()) {
                    processorNodePunctuator.punctuate(sched.node(), timestamp, type, sched.punctuator());
                    this.pq.add(sched.next(timestamp));
                    punctuated = true;
                }
                top = this.pq.peek();
            }
            return punctuated;
        }
    }
}

