/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.webmonitor.ExecutionGraphHolder;
import org.apache.flink.runtime.webmonitor.handlers.AbstractSubtaskAttemptRequestHandler;
import org.apache.flink.runtime.webmonitor.handlers.JsonFactory;
import org.apache.flink.runtime.webmonitor.handlers.RequestHandler;

public class SubtaskExecutionAttemptDetailsHandler
extends AbstractSubtaskAttemptRequestHandler
implements RequestHandler.JsonResponse {
    public SubtaskExecutionAttemptDetailsHandler(ExecutionGraphHolder executionGraphHolder) {
        super(executionGraphHolder);
    }

    @Override
    public String handleRequest(Execution execAttempt, Map<String, String> params) throws Exception {
        LongCounter writeRecords;
        LongCounter readRecords;
        LongCounter writeBytes;
        LongCounter readBytes;
        long endTime;
        ExecutionState status = execAttempt.getState();
        long now = System.currentTimeMillis();
        InstanceConnectionInfo location = execAttempt.getAssignedResourceLocation();
        String locationString = location == null ? "(unassigned)" : location.getHostname();
        long startTime = execAttempt.getStateTimestamp(ExecutionState.DEPLOYING);
        if (startTime == 0L) {
            startTime = -1L;
        }
        long l = endTime = status.isTerminal() ? execAttempt.getStateTimestamp(status) : -1L;
        long duration = startTime > 0L ? (endTime > 0L ? endTime : now) - startTime : -1L;
        Map metrics = execAttempt.getFlinkAccumulators();
        if (metrics != null) {
            readBytes = (LongCounter)metrics.get(AccumulatorRegistry.Metric.NUM_BYTES_IN);
            writeBytes = (LongCounter)metrics.get(AccumulatorRegistry.Metric.NUM_BYTES_OUT);
            readRecords = (LongCounter)metrics.get(AccumulatorRegistry.Metric.NUM_RECORDS_IN);
            writeRecords = (LongCounter)metrics.get(AccumulatorRegistry.Metric.NUM_RECORDS_OUT);
        } else {
            readBytes = null;
            writeBytes = null;
            readRecords = null;
            writeRecords = null;
        }
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.jacksonFactory.createJsonGenerator((Writer)writer);
        gen.writeStartObject();
        gen.writeNumberField("subtask", execAttempt.getVertex().getSubTaskIndex());
        gen.writeStringField("status", status.name());
        gen.writeNumberField("attempt", execAttempt.getAttemptNumber());
        gen.writeStringField("host", locationString);
        gen.writeNumberField("start-time", startTime);
        gen.writeNumberField("end-time", endTime);
        gen.writeNumberField("duration", duration);
        gen.writeObjectFieldStart("metrics");
        gen.writeNumberField("read-bytes", readBytes != null ? readBytes.getLocalValuePrimitive() : -1L);
        gen.writeNumberField("write-bytes", writeBytes != null ? writeBytes.getLocalValuePrimitive() : -1L);
        gen.writeNumberField("read-records", readRecords != null ? readRecords.getLocalValuePrimitive() : -1L);
        gen.writeNumberField("write-records", writeRecords != null ? writeRecords.getLocalValuePrimitive() : -1L);
        gen.writeEndObject();
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }
}

